/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress;

import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.compress.HoodieCompressor;
import org.apache.hudi.io.compress.airlift.HoodieAirliftGzipCompressor;
import org.apache.hudi.io.compress.builtin.HoodieNoneCompressor;

public class HoodieCompressorFactory {
    private HoodieCompressorFactory() {
    }

    public static HoodieCompressor getCompressor(CompressionCodec compressionCodec) {
        switch (compressionCodec) {
            case NONE: {
                return new HoodieNoneCompressor();
            }
            case GZIP: {
                return new HoodieAirliftGzipCompressor();
            }
        }
        throw new IllegalArgumentException("The compressor is not supported for compression codec: " + (Object)((Object)compressionCodec));
    }
}

