/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockCache;
import org.apache.hudi.io.hfile.HFileDataBlock;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingHFileReaderImpl
extends HFileReaderImpl {
    private static final Logger LOG = LoggerFactory.getLogger(CachingHFileReaderImpl.class);
    private static volatile HFileBlockCache GLOBAL_BLOCK_CACHE;
    private static volatile Integer INITIAL_CACHE_SIZE;
    private static volatile Integer INITIAL_CACHE_TTL;
    private static final Object CACHE_LOCK;
    private final String filePath;

    public CachingHFileReaderImpl(SeekableDataInputStream stream, long fileSize, String filePath, int cacheSize, int cacheTtlMinutes) {
        super(stream, fileSize);
        this.filePath = filePath;
        CachingHFileReaderImpl.getGlobalCache(cacheSize, cacheTtlMinutes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HFileBlockCache getGlobalCache(int cacheSize, int cacheTtlMinutes) {
        if (GLOBAL_BLOCK_CACHE == null) {
            Object object = CACHE_LOCK;
            synchronized (object) {
                if (GLOBAL_BLOCK_CACHE == null) {
                    LOG.info("Initializing global HFileBlockCache with size: {}, TTL: {} minutes.", (Object)cacheSize, (Object)cacheTtlMinutes);
                    INITIAL_CACHE_SIZE = cacheSize;
                    INITIAL_CACHE_TTL = cacheTtlMinutes;
                    GLOBAL_BLOCK_CACHE = new HFileBlockCache(cacheSize, cacheTtlMinutes, TimeUnit.MINUTES);
                } else if (!INITIAL_CACHE_SIZE.equals(cacheSize) || !INITIAL_CACHE_TTL.equals(cacheTtlMinutes)) {
                    LOG.warn("HFile block cache is already initialized. The provided configuration is being ignored. Existing config: [Size: {}, TTL: {} mins], Ignored config: [Size: {}, TTL: {} mins].", new Object[]{INITIAL_CACHE_SIZE, INITIAL_CACHE_TTL, cacheSize, cacheTtlMinutes});
                }
            }
        }
        return GLOBAL_BLOCK_CACHE;
    }

    @Override
    public HFileDataBlock instantiateHFileDataBlock(BlockIndexEntry blockToRead) throws IOException {
        HFileBlockCache.BlockCacheKey cacheKey = new HFileBlockCache.BlockCacheKey(this.filePath, blockToRead.getOffset(), blockToRead.getSize());
        try {
            HFileBlock block = GLOBAL_BLOCK_CACHE.getOrCompute(cacheKey, () -> super.instantiateHFileDataBlock(blockToRead));
            return (HFileDataBlock)block;
        }
        catch (IOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException("Failed to load HFile block", e);
        }
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public long getCacheSize() {
        return GLOBAL_BLOCK_CACHE != null ? GLOBAL_BLOCK_CACHE.size() : 0L;
    }

    public void clearCache() {
        if (GLOBAL_BLOCK_CACHE != null) {
            GLOBAL_BLOCK_CACHE.clear();
        }
    }

    public String getCacheStats() {
        return "HFileReader Cache Stats - Size: " + (GLOBAL_BLOCK_CACHE != null ? GLOBAL_BLOCK_CACHE.size() : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetGlobalCache() {
        Object object = CACHE_LOCK;
        synchronized (object) {
            if (GLOBAL_BLOCK_CACHE != null) {
                GLOBAL_BLOCK_CACHE.clear();
                GLOBAL_BLOCK_CACHE = null;
            }
            INITIAL_CACHE_SIZE = null;
            INITIAL_CACHE_TTL = null;
        }
    }

    static {
        CACHE_LOCK = new Object();
    }
}

