/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.com.google.protobuf.CodedOutputStream;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.hfile.ChecksumType;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileDataBlock;
import org.apache.hudi.io.hfile.HFileFileInfoBlock;
import org.apache.hudi.io.hfile.HFileIntermediateIndexBlock;
import org.apache.hudi.io.hfile.HFileLeafIndexBlock;
import org.apache.hudi.io.hfile.HFileMetaBlock;
import org.apache.hudi.io.hfile.HFileRootIndexBlock;
import org.apache.hudi.io.util.IOUtils;

public abstract class HFileBlock {
    public static final int HFILEBLOCK_HEADER_SIZE_NO_CHECKSUM = 24;
    public static final int HFILEBLOCK_HEADER_SIZE = 33;
    static final int CHECKSUM_SIZE = 4;
    private static final int DEFAULT_BYTES_PER_CHECKSUM = 16384;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected final HFileContext context;
    protected final byte[] byteBuff;
    protected final int startOffsetInBuff;
    protected final int sizeCheckSum;
    protected final int uncompressedEndOffset;
    private final HFileBlockType blockType;
    protected final int onDiskSizeWithoutHeader;
    protected final int uncompressedSizeWithoutHeader;
    protected final int bytesPerChecksum;
    private boolean isUnpacked = false;
    protected byte[] compressedByteBuff;
    protected int startOffsetInCompressedBuff;
    private long startOffsetInBuffForWrite = -1L;
    private long previousBlockOffsetForWrite = -1L;

    protected HFileBlock(HFileContext context, HFileBlockType blockType, byte[] byteBuff, int startOffsetInBuff) {
        this.context = context;
        this.blockType = blockType;
        this.onDiskSizeWithoutHeader = IOUtils.readInt(byteBuff, startOffsetInBuff + Header.ON_DISK_SIZE_WITHOUT_HEADER_INDEX);
        this.uncompressedSizeWithoutHeader = IOUtils.readInt(byteBuff, startOffsetInBuff + Header.UNCOMPRESSED_SIZE_WITHOUT_HEADER_INDEX);
        this.bytesPerChecksum = IOUtils.readInt(byteBuff, startOffsetInBuff + Header.BYTES_PER_CHECKSUM_INDEX);
        this.sizeCheckSum = HFileBlock.numChecksumBytes(this.getOnDiskSizeWithHeader(), this.bytesPerChecksum);
        if (CompressionCodec.NONE.equals((Object)context.getCompressionCodec())) {
            this.isUnpacked = true;
            this.startOffsetInBuff = startOffsetInBuff;
            this.byteBuff = byteBuff;
        } else {
            this.startOffsetInCompressedBuff = startOffsetInBuff;
            this.compressedByteBuff = byteBuff;
            this.startOffsetInBuff = 0;
            this.byteBuff = this.allocateBufferForUnpacking();
        }
        this.uncompressedEndOffset = this.startOffsetInBuff + 33 + this.uncompressedSizeWithoutHeader;
    }

    protected HFileBlock(HFileContext context, HFileBlockType blockType, long previousBlockOffsetForWrite) {
        this.context = context;
        this.blockType = blockType;
        this.previousBlockOffsetForWrite = previousBlockOffsetForWrite;
        this.byteBuff = null;
        this.startOffsetInBuff = -1;
        this.sizeCheckSum = -1;
        this.uncompressedEndOffset = -1;
        this.onDiskSizeWithoutHeader = -1;
        this.uncompressedSizeWithoutHeader = -1;
        this.bytesPerChecksum = -1;
    }

    public static HFileBlock parse(HFileContext context, byte[] byteBuff, int startOffsetInBuff) throws IOException {
        HFileBlockType blockType = HFileBlockType.parse(byteBuff, startOffsetInBuff);
        switch (blockType) {
            case ROOT_INDEX: {
                return new HFileRootIndexBlock(context, byteBuff, startOffsetInBuff);
            }
            case LEAF_INDEX: {
                return new HFileLeafIndexBlock(context, byteBuff, startOffsetInBuff);
            }
            case INTERMEDIATE_INDEX: {
                return new HFileIntermediateIndexBlock(context, byteBuff, startOffsetInBuff);
            }
            case FILE_INFO: {
                return new HFileFileInfoBlock(context, byteBuff, startOffsetInBuff);
            }
            case DATA: {
                return new HFileDataBlock(context, byteBuff, startOffsetInBuff);
            }
            case META: {
                return new HFileMetaBlock(context, byteBuff, startOffsetInBuff);
            }
        }
        throw new IOException("Parsing of the HFile block type " + (Object)((Object)blockType) + " is not supported");
    }

    static int numChecksumBytes(long numBytes, int bytesPerChecksum) {
        return HFileBlock.numChecksumChunks(numBytes, bytesPerChecksum) * 4;
    }

    static int numChecksumChunks(long numBytes, int bytesPerChecksum) {
        long numChunks = numBytes / (long)bytesPerChecksum;
        if (numBytes % (long)bytesPerChecksum != 0L) {
            ++numChunks;
        }
        if (numChunks > 0x1FFFFFFFL) {
            throw new IllegalArgumentException("The number of chunks is too large: " + numChunks);
        }
        return (int)numChunks;
    }

    public HFileBlockType getBlockType() {
        return this.blockType;
    }

    public byte[] getByteBuff() {
        return this.byteBuff;
    }

    public int getOnDiskSizeWithHeader() {
        return this.onDiskSizeWithoutHeader + 33;
    }

    public void unpack() throws IOException {
        if (!this.isUnpacked) {
            CompressionCodec compression = this.context.getCompressionCodec();
            if (compression != CompressionCodec.NONE) {
                System.arraycopy(this.compressedByteBuff, this.startOffsetInCompressedBuff, this.byteBuff, 0, 33);
                try (ByteArrayInputStream byteBuffInputStream = new ByteArrayInputStream(this.compressedByteBuff, this.startOffsetInCompressedBuff + 33, this.onDiskSizeWithoutHeader);){
                    this.context.getCompressor().decompress(byteBuffInputStream, this.byteBuff, 33, this.byteBuff.length - 33);
                }
            }
            this.isUnpacked = true;
        }
    }

    protected byte[] allocateBufferForUnpacking() {
        int capacity = 33 + this.uncompressedSizeWithoutHeader + this.sizeCheckSum;
        return new byte[capacity];
    }

    protected abstract ByteBuffer getUncompressedBlockDataToWrite() throws IOException;

    public ByteBuffer serialize() throws IOException {
        ByteBuffer uncompressedBlockData = this.getUncompressedBlockDataToWrite();
        ByteBuffer compressedBlockData = this.context.getCompressor().compress(uncompressedBlockData);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(Math.max(this.context.getBlockSize(), compressedBlockData.limit() + 66));
        try (DataOutputStream dataOutputStream = new DataOutputStream(baos);){
            dataOutputStream.write(this.blockType.getMagic(), 0, 8);
            int compressedDataSize = compressedBlockData.limit();
            int onDiskDataSizeWithHeader = 33 + compressedDataSize;
            int numChecksumBytes = HFileBlock.numChecksumBytes(onDiskDataSizeWithHeader, 16384);
            dataOutputStream.writeInt(compressedDataSize + numChecksumBytes);
            dataOutputStream.writeInt(uncompressedBlockData.limit());
            dataOutputStream.writeLong(this.previousBlockOffsetForWrite);
            dataOutputStream.write(this.context.getChecksumType().getCode());
            dataOutputStream.writeInt(16384);
            dataOutputStream.writeInt(onDiskDataSizeWithHeader);
            dataOutputStream.write(compressedBlockData.array(), compressedBlockData.position(), compressedBlockData.remaining());
            dataOutputStream.write(this.generateChecksumBytes(this.context.getChecksumType(), numChecksumBytes));
        }
        byte[] result = baos.toByteArray();
        return ByteBuffer.wrap(result);
    }

    protected void setStartOffsetInBuffForWrite(long startOffsetInBuffForWrite) {
        this.startOffsetInBuffForWrite = startOffsetInBuffForWrite;
    }

    protected long getStartOffsetInBuffForWrite() {
        return this.startOffsetInBuffForWrite;
    }

    private byte[] generateChecksumBytes(ChecksumType type, int numChecksumBytes) {
        if (type == ChecksumType.NULL) {
            return new byte[numChecksumBytes];
        }
        throw new HoodieException("Only NULL checksum type is supported");
    }

    static byte[] getVariableLengthEncodedBytes(int length) throws IOException {
        ByteArrayOutputStream varintBuffer = new ByteArrayOutputStream();
        CodedOutputStream varintOutput = CodedOutputStream.newInstance(varintBuffer);
        varintOutput.writeUInt32NoTag(length);
        varintOutput.flush();
        return varintBuffer.toByteArray();
    }

    static class Header {
        static int BLOCK_MAGIC_INDEX = 0;
        static int ON_DISK_SIZE_WITHOUT_HEADER_INDEX = 8;
        static int UNCOMPRESSED_SIZE_WITHOUT_HEADER_INDEX = 12;
        static int PREV_BLOCK_OFFSET_INDEX = 16;
        static int CHECKSUM_TYPE_INDEX = 24;
        static int BYTES_PER_CHECKSUM_INDEX = 25;
        static int ON_DISK_DATA_SIZE_WITH_HEADER_INDEX = 29;

        Header() {
        }
    }
}

