/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.compress.HoodieCompressor;
import org.apache.hudi.io.compress.HoodieCompressorFactory;
import org.apache.hudi.io.hfile.ChecksumType;

public class HFileContext {
    private final CompressionCodec compressionCodec;
    private final HoodieCompressor compressor;
    private final ChecksumType checksumType;
    private final int blockSize;
    private final long fileCreationTime;

    private HFileContext(CompressionCodec compressionCodec, int blockSize, ChecksumType checksumType, long fileCreationTime) {
        this.compressionCodec = compressionCodec;
        this.compressor = HoodieCompressorFactory.getCompressor(compressionCodec);
        this.blockSize = blockSize;
        this.checksumType = checksumType;
        this.fileCreationTime = fileCreationTime;
    }

    CompressionCodec getCompressionCodec() {
        return this.compressionCodec;
    }

    HoodieCompressor getCompressor() {
        return this.compressor;
    }

    int getBlockSize() {
        return this.blockSize;
    }

    ChecksumType getChecksumType() {
        return this.checksumType;
    }

    long getFileCreationTime() {
        return this.fileCreationTime;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private CompressionCodec compressionCodec = CompressionCodec.NONE;
        private int blockSize = 0x100000;
        private ChecksumType checksumType = ChecksumType.NULL;
        private long fileCreationTime = System.currentTimeMillis();

        public Builder blockSize(int blockSize) {
            this.blockSize = blockSize;
            return this;
        }

        public Builder compressionCodec(CompressionCodec compressionCodec) {
            this.compressionCodec = compressionCodec;
            return this;
        }

        public Builder checksumType(ChecksumType checksumType) {
            this.checksumType = checksumType;
            return this;
        }

        public Builder fileCreationTime(long fileCreationTime) {
            this.fileCreationTime = fileCreationTime;
            return this;
        }

        public HFileContext build() {
            return new HFileContext(this.compressionCodec, this.blockSize, this.checksumType, this.fileCreationTime);
        }
    }
}

