/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileCursor;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.KeyValueEntry;

public class HFileDataBlock
extends HFileBlock {
    private static final int KEY_LENGTH_LENGTH = 2;
    private static final int COLUMN_FAMILY_LENGTH = 1;
    private static final int VERSION_TIMESTAMP_LENGTH = 8;
    private static final int KEY_TYPE_LENGTH = 1;
    private static final long ZERO_TS_VERSION_BYTE_LENGTH = 1L;
    private static final long LATEST_TIMESTAMP = Long.MAX_VALUE;
    protected final int uncompressedContentEndRelativeOffset;
    private final List<KeyValueEntry> entriesToWrite = new ArrayList<KeyValueEntry>();

    protected HFileDataBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.DATA, byteBuff, startOffsetInBuff);
        this.uncompressedContentEndRelativeOffset = this.uncompressedEndOffset - this.sizeCheckSum - this.startOffsetInBuff;
    }

    private HFileDataBlock(HFileContext context, long previousBlockOffset) {
        super(context, HFileBlockType.DATA, previousBlockOffset);
        this.uncompressedContentEndRelativeOffset = -1;
    }

    static HFileDataBlock createDataBlockToWrite(HFileContext context, long previousBlockOffset) {
        return new HFileDataBlock(context, previousBlockOffset);
    }

    int seekTo(HFileCursor cursor, Key key, int blockStartOffsetInFile) {
        int relativeOffset;
        int lastRelativeOffset = relativeOffset = cursor.getOffset() - blockStartOffsetInFile;
        Option<KeyValue> lastKeyValue = cursor.getKeyValue();
        while (relativeOffset < this.uncompressedContentEndRelativeOffset) {
            KeyValue kv = this.readKeyValue(relativeOffset);
            int comp = kv.getKey().compareTo(key);
            if (comp == 0) {
                cursor.set(relativeOffset + blockStartOffsetInFile, kv);
                return 0;
            }
            if (comp > 0) {
                if (lastKeyValue.isPresent()) {
                    cursor.set(lastRelativeOffset + blockStartOffsetInFile, lastKeyValue.get());
                } else {
                    cursor.setOffset(lastRelativeOffset + blockStartOffsetInFile);
                }
                return this.isAtFirstKey(relativeOffset) ? -2 : 1;
            }
            long increment = 8L + (long)kv.getKeyLength() + (long)kv.getValueLength() + 1L;
            lastRelativeOffset = relativeOffset;
            relativeOffset = (int)((long)relativeOffset + increment);
            lastKeyValue = Option.of(kv);
        }
        if (lastKeyValue.isPresent()) {
            cursor.set(lastRelativeOffset + blockStartOffsetInFile, lastKeyValue.get());
        } else {
            cursor.setOffset(lastRelativeOffset + blockStartOffsetInFile);
        }
        return 1;
    }

    KeyValue readKeyValue(int offset) {
        return new KeyValue(this.byteBuff, offset);
    }

    boolean next(HFileCursor cursor, int blockStartOffsetInFile) {
        int offset = cursor.getOffset() - blockStartOffsetInFile;
        Option<KeyValue> keyValue = cursor.getKeyValue();
        if (!keyValue.isPresent()) {
            keyValue = Option.of(this.readKeyValue(offset));
        }
        cursor.increment(8L + (long)keyValue.get().getKeyLength() + (long)keyValue.get().getValueLength() + 1L);
        return cursor.getOffset() - blockStartOffsetInFile < this.uncompressedContentEndRelativeOffset;
    }

    private boolean isAtFirstKey(int relativeOffset) {
        return relativeOffset == 33;
    }

    boolean isEmpty() {
        return this.entriesToWrite.isEmpty();
    }

    void add(byte[] key, byte[] value) {
        KeyValueEntry kv = new KeyValueEntry(key, value);
        this.entriesToWrite.add(kv);
    }

    int getNumOfEntries() {
        return this.entriesToWrite.size();
    }

    byte[] getFirstKey() {
        return this.entriesToWrite.get((int)0).key;
    }

    byte[] getLastKeyContent() {
        if (this.entriesToWrite.isEmpty()) {
            return new byte[0];
        }
        return this.entriesToWrite.get((int)(this.entriesToWrite.size() - 1)).key;
    }

    @Override
    protected ByteBuffer getUncompressedBlockDataToWrite() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.context.getBlockSize());
        try (DataOutputStream dataOutputStream = new DataOutputStream(baos);){
            for (KeyValueEntry kv : this.entriesToWrite) {
                dataOutputStream.writeInt(kv.key.length + 2 + 1 + 8 + 1);
                dataOutputStream.writeInt(kv.value.length);
                dataOutputStream.writeShort((short)kv.key.length);
                dataOutputStream.write(kv.key);
                dataOutputStream.write(0);
                dataOutputStream.writeLong(Long.MAX_VALUE);
                dataOutputStream.write(4);
                dataOutputStream.write(kv.value);
                dataOutputStream.write(0);
            }
        }
        return ByteBuffer.wrap(baos.toByteArray());
    }
}

