/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.com.google.protobuf.ByteString;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.hfile.protobuf.generated.HFileProtos;
import org.apache.hudi.io.util.IOUtils;

public class HFileFileInfoBlock
extends HFileBlock {
    public static final byte[] PB_MAGIC = new byte[]{80, 66, 85, 70};
    private final Map<String, byte[]> fileInfoToWrite = new HashMap<String, byte[]>();

    public HFileFileInfoBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.FILE_INFO, byteBuff, startOffsetInBuff);
    }

    private HFileFileInfoBlock(HFileContext context) {
        super(context, HFileBlockType.FILE_INFO, -1L);
    }

    public static HFileFileInfoBlock createFileInfoBlockToWrite(HFileContext context) {
        return new HFileFileInfoBlock(context);
    }

    public HFileInfo readFileInfo() throws IOException {
        int pbMagicLength = PB_MAGIC.length;
        if (IOUtils.compareTo(PB_MAGIC, 0, pbMagicLength, this.byteBuff, this.startOffsetInBuff + 33, pbMagicLength) != 0) {
            throw new IOException("Unexpected Protobuf magic at the beginning of the HFileFileInfoBlock: " + StringUtils.fromUTF8Bytes(this.byteBuff, this.startOffsetInBuff + 33, pbMagicLength));
        }
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.byteBuff, this.startOffsetInBuff + 33 + pbMagicLength, this.uncompressedSizeWithoutHeader);
        HashMap<UTF8StringKey, byte[]> fileInfoMap = new HashMap<UTF8StringKey, byte[]>();
        HFileProtos.InfoProto infoProto = HFileProtos.InfoProto.parseDelimitedFrom(inputStream);
        for (HFileProtos.BytesBytesPair pair : infoProto.getMapEntryList()) {
            fileInfoMap.put(new UTF8StringKey(pair.getFirst().toByteArray()), pair.getSecond().toByteArray());
        }
        return new HFileInfo(fileInfoMap);
    }

    public void add(String name, byte[] value) {
        this.fileInfoToWrite.put(name, value);
    }

    public boolean containsKey(String name) {
        return this.fileInfoToWrite.containsKey(name);
    }

    @Override
    public ByteBuffer getUncompressedBlockDataToWrite() throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(this.context.getBlockSize());
        HFileProtos.InfoProto.Builder builder = HFileProtos.InfoProto.newBuilder();
        for (Map.Entry<String, byte[]> e : this.fileInfoToWrite.entrySet()) {
            HFileProtos.BytesBytesPair bbp = HFileProtos.BytesBytesPair.newBuilder().setFirst(ByteString.copyFrom(StringUtils.getUTF8Bytes(e.getKey()))).setSecond(ByteString.copyFrom(e.getValue())).build();
            builder.addMapEntry(bbp);
        }
        outputStream.write(PB_MAGIC);
        byte[] payload = builder.build().toByteArray();
        try {
            outputStream.write(HFileFileInfoBlock.getVariableLengthEncodedBytes(payload.length));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to calculate File Info variable length");
        }
        outputStream.write(payload);
        return ByteBuffer.wrap(outputStream.toByteArray());
    }
}

