/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.Key;

public abstract class HFileIndexBlock
extends HFileBlock {
    protected final List<BlockIndexEntry> entries = new ArrayList<BlockIndexEntry>();
    protected long blockDataSize = -1L;

    protected HFileIndexBlock(HFileContext context, HFileBlockType blockType, byte[] byteBuff, int startOffsetInBuff) {
        super(context, blockType, byteBuff, startOffsetInBuff);
    }

    protected HFileIndexBlock(HFileContext context, HFileBlockType blockType) {
        super(context, blockType, -1L);
    }

    public void add(byte[] firstKey, long offset, int size) {
        Key key = new Key(firstKey);
        this.entries.add(new BlockIndexEntry(key, Option.empty(), offset, size));
    }

    public int getNumOfEntries() {
        return this.entries.size();
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }
}

