/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.util.Map;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.util.IOUtils;

public class HFileInfo {
    private static final String RESERVED_PREFIX = "hfile.";
    static final UTF8StringKey LAST_KEY = new UTF8StringKey("hfile.LASTKEY");
    static final UTF8StringKey FILE_CREATION_TIME_TS = new UTF8StringKey("hfile.CREATE_TIME_TS");
    static final UTF8StringKey KEY_VALUE_VERSION = new UTF8StringKey("KEY_VALUE_VERSION");
    static final UTF8StringKey MAX_MVCC_TS_KEY = new UTF8StringKey("MAX_MEMSTORE_TS_KEY");
    static final UTF8StringKey AVG_KEY_LEN = new UTF8StringKey("hfile.AVG_KEY_LEN");
    static final UTF8StringKey AVG_VALUE_LEN = new UTF8StringKey("hfile.AVG_VALUE_LEN");
    static final int KEY_VALUE_VERSION_WITH_MVCC_TS = 1;
    private final Map<UTF8StringKey, byte[]> infoMap;
    private final long fileCreationTime;
    private final Option<Key> lastKey;

    public HFileInfo(Map<UTF8StringKey, byte[]> infoMap) {
        this.infoMap = infoMap;
        this.fileCreationTime = this.parseFileCreationTime();
        this.lastKey = this.parseLastKey();
        if (this.parseMaxMvccTs() > 0L) {
            throw new UnsupportedOperationException("HFiles with MVCC timestamps are not supported");
        }
    }

    public long getFileCreationTime() {
        return this.fileCreationTime;
    }

    public Option<Key> getLastKey() {
        return this.lastKey;
    }

    public byte[] get(UTF8StringKey key) {
        return this.infoMap.get(key);
    }

    private long parseFileCreationTime() {
        byte[] bytes = this.infoMap.get(FILE_CREATION_TIME_TS);
        return bytes != null ? IOUtils.readLong(bytes, 0) : 0L;
    }

    private Option<Key> parseLastKey() {
        byte[] bytes = this.infoMap.get(LAST_KEY);
        return bytes != null ? Option.of(new Key(bytes)) : Option.empty();
    }

    private long parseMaxMvccTs() {
        byte[] bytes = this.infoMap.get(KEY_VALUE_VERSION);
        boolean supportsMvccTs = bytes != null && IOUtils.readInt(bytes, 0) == 1;
        return supportsMvccTs ? IOUtils.readLong(this.infoMap.get(MAX_MVCC_TS_KEY), 0) : 0L;
    }
}

