/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.KeyValueEntry;

public class HFileMetaBlock
extends HFileBlock {
    protected KeyValueEntry entryToWrite;

    protected HFileMetaBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.META, byteBuff, startOffsetInBuff);
    }

    private HFileMetaBlock(HFileContext context, KeyValueEntry keyValueEntry) {
        super(context, HFileBlockType.META, -1L);
        this.entryToWrite = keyValueEntry;
    }

    static HFileMetaBlock createMetaBlockToWrite(HFileContext context, KeyValueEntry keyValueEntry) {
        return new HFileMetaBlock(context, keyValueEntry);
    }

    public ByteBuffer readContent() {
        return ByteBuffer.wrap(this.getByteBuff(), this.startOffsetInBuff + 33, this.uncompressedSizeWithoutHeader);
    }

    public byte[] getFirstKey() {
        return this.entryToWrite.key;
    }

    @Override
    public ByteBuffer getUncompressedBlockDataToWrite() throws IOException {
        return ByteBuffer.wrap(this.entryToWrite.value);
    }
}

