/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Random;
import org.apache.hudi.io.compress.CompressionCodec;
import org.apache.hudi.io.compress.HoodieCompressorFactory;
import org.apache.hudi.io.compress.airlift.HoodieAirliftGzipCompressor;
import org.apache.hudi.io.compress.builtin.HoodieNoneCompressor;
import org.apache.hudi.io.util.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.function.Executable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHoodieCompressor {
    private static final int INPUT_LENGTH = 394850;
    private static final int[] READ_PART_SIZE_LIST = new int[]{1200, 30956, 204958, 394900};
    private static final byte[] INPUT_BYTES = TestHoodieCompressor.generateRandomBytes(394850);

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest
    @EnumSource(value=CompressionCodec.class)
    public void testDefaultDecompressors(CompressionCodec codec) throws IOException {
        switch (1.$SwitchMap$org$apache$hudi$io$compress$CompressionCodec[codec.ordinal()]) {
            case 1: 
            case 2: {
                decompressor = HoodieCompressorFactory.getCompressor((CompressionCodec)codec);
                actualOutput = new byte[394950];
                stream = TestHoodieCompressor.prepareInputStream(codec);
                var5_5 = null;
                for (int sizeToRead : TestHoodieCompressor.READ_PART_SIZE_LIST) {
                    stream.mark(394850);
                    actualSizeRead = decompressor.decompress(stream, actualOutput, 4, sizeToRead);
                    Assertions.assertEquals((int)actualSizeRead, (int)Math.min(394850, sizeToRead));
                    Assertions.assertEquals((int)0, (int)IOUtils.compareTo((byte[])actualOutput, (int)4, (int)actualSizeRead, (byte[])TestHoodieCompressor.INPUT_BYTES, (int)0, (int)actualSizeRead));
                    stream.reset();
                }
                if (stream == null) break;
                if (var5_5 == null) ** GOTO lbl23
                try {
                    stream.close();
                }
                catch (Throwable var6_7) {
                    var5_5.addSuppressed(var6_7);
                }
                break;
lbl23:
                // 1 sources

                stream.close();
                break;
                catch (Throwable var6_8) {
                    try {
                        var5_5 = var6_8;
                        throw var6_8;
                    }
                    catch (Throwable var11_13) {
                        if (stream != null) {
                            if (var5_5 != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable var12_14) {
                                    var5_5.addSuppressed(var12_14);
                                }
                            } else {
                                stream.close();
                            }
                        }
                        throw var11_13;
                    }
                }
            }
            default: {
                Assertions.assertThrows(IllegalArgumentException.class, (Executable)(Executable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$testDefaultDecompressors$0(org.apache.hudi.io.compress.CompressionCodec ), ()V)((CompressionCodec)codec));
            }
        }
    }

    private static InputStream prepareInputStream(CompressionCodec codec) throws IOException {
        switch (codec) {
            case NONE: {
                return new ByteArrayInputStream(new HoodieNoneCompressor().compress(INPUT_BYTES));
            }
            case GZIP: {
                return new ByteArrayInputStream(new HoodieAirliftGzipCompressor().compress(INPUT_BYTES));
            }
        }
        throw new IllegalArgumentException("Not supported in tests.");
    }

    private static byte[] generateRandomBytes(int length) {
        Random random = new Random(36502L);
        byte[] result = new byte[length];
        int chunkSize = 16384;
        int numChunks = length / chunkSize;
        if (numChunks > 0) {
            byte[] chunk = new byte[chunkSize];
            random.nextBytes(chunk);
            for (int i = 0; i < numChunks; ++i) {
                System.arraycopy(chunk, 0, result, chunkSize * i, chunkSize);
            }
        }
        for (int i = numChunks * chunkSize; i < length; ++i) {
            result[i] = (byte)(random.nextInt() & 0xFF);
        }
        return result;
    }

    private static /* synthetic */ void lambda$testDefaultDecompressors$0(CompressionCodec codec) throws Throwable {
        HoodieCompressorFactory.getCompressor((CompressionCodec)codec);
    }
}

