/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.io.hfile.ChecksumType;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockCache;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileDataBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHFileBlockCache {
    @Test
    public void testBlockCacheBasicOperations() {
        HFileBlockCache cache = new HFileBlockCache(2, 30L, TimeUnit.MINUTES);
        Assertions.assertEquals((long)0L, (long)cache.size());
        HFileBlockCache.BlockCacheKey key1 = new HFileBlockCache.BlockCacheKey(null, 100L, 64);
        HFileBlockCache.BlockCacheKey key2 = new HFileBlockCache.BlockCacheKey(null, 200L, 64);
        HFileBlockCache.BlockCacheKey key3 = new HFileBlockCache.BlockCacheKey(null, 300L, 64);
        Assertions.assertNotEquals((Object)key1, (Object)key2);
        Assertions.assertEquals((Object)new HFileBlockCache.BlockCacheKey(null, 100L, 64), (Object)key1);
        HFileContext context = HFileContext.builder().checksumType(ChecksumType.CRC32C).blockSize(1024).build();
        byte[] validBlockData = TestHFileBlockCache.createValidHFileBlockData();
        MockHFileDataBlock block1 = new MockHFileDataBlock(context, validBlockData, 0);
        MockHFileDataBlock block2 = new MockHFileDataBlock(context, validBlockData, 0);
        MockHFileDataBlock block3 = new MockHFileDataBlock(context, validBlockData, 0);
        cache.putBlock(key1, (HFileBlock)block1);
        Assertions.assertEquals((long)1L, (long)cache.size());
        Assertions.assertEquals((Object)((Object)block1), (Object)cache.getBlock(key1));
        Assertions.assertNull((Object)cache.getBlock(key2));
        cache.putBlock(key2, (HFileBlock)block2);
        Assertions.assertEquals((long)2L, (long)cache.size());
        cache.putBlock(key3, (HFileBlock)block3);
        cache.cleanUp();
        HFileBlock result1 = cache.getBlock(key1);
        HFileBlock result2 = cache.getBlock(key2);
        HFileBlock result3 = cache.getBlock(key3);
        Assertions.assertNull((Object)result1);
        Assertions.assertSame((Object)((Object)block2), (Object)result2);
        Assertions.assertSame((Object)((Object)block3), (Object)result3);
        Assertions.assertTrue((cache.size() <= 2L ? 1 : 0) != 0, (String)("Final cache size should not exceed maximum: " + cache.size()));
        cache.clear();
        Assertions.assertEquals((long)0L, (long)cache.size());
        Assertions.assertNull((Object)cache.getBlock(key2));
        Assertions.assertNull((Object)cache.getBlock(key3));
    }

    @Test
    public void testGetOrComputeWithMissAndMultipleBlocks() throws Exception {
        HFileBlockCache cache = new HFileBlockCache(10, 30L, TimeUnit.MINUTES);
        AtomicInteger loaderExecutionCount = new AtomicInteger(0);
        HFileBlockCache.BlockCacheKey keyToCompute = new HFileBlockCache.BlockCacheKey("file-A", 1024L, 128);
        HFileBlockCache.BlockCacheKey preExistingKey = new HFileBlockCache.BlockCacheKey("file-B", 2048L, 256);
        HFileContext context = HFileContext.builder().build();
        byte[] validBlockData = TestHFileBlockCache.createValidHFileBlockData();
        MockHFileDataBlock blockToCompute = new MockHFileDataBlock(context, validBlockData, 0);
        MockHFileDataBlock preExistingBlock = new MockHFileDataBlock(context, validBlockData, 0);
        cache.putBlock(preExistingKey, (HFileBlock)preExistingBlock);
        Assertions.assertEquals((long)1L, (long)cache.size());
        Assertions.assertNull((Object)cache.getBlock(keyToCompute), (String)"Key should not be in the cache initially.");
        Callable<HFileBlock> loader = () -> {
            loaderExecutionCount.incrementAndGet();
            return blockToCompute;
        };
        HFileBlock firstResult = cache.getOrCompute(keyToCompute, loader);
        Assertions.assertEquals((int)1, (int)loaderExecutionCount.get(), (String)"Loader should be called once on first access.");
        Assertions.assertEquals((long)2L, (long)cache.size(), (String)"Cache size should be 2 after computing the new block.");
        Assertions.assertSame((Object)((Object)blockToCompute), (Object)firstResult, (String)"The newly computed block should be returned.");
        HFileBlock secondResult = cache.getOrCompute(keyToCompute, loader);
        Assertions.assertEquals((int)1, (int)loaderExecutionCount.get(), (String)"Loader should NOT be called again for a cached key.");
        Assertions.assertSame((Object)firstResult, (Object)secondResult, (String)"Repeated calls should return the exact same cached object instance.");
        Assertions.assertSame((Object)((Object)preExistingBlock), (Object)cache.getBlock(preExistingKey), (String)"Pre-existing block should remain untouched.");
    }

    private static byte[] createValidHFileBlockData() {
        int headerSize = 33;
        int dataSize = 100;
        int totalSize = 133;
        ByteBuffer buffer = ByteBuffer.allocate(133);
        buffer.put(HFileBlockType.DATA.getMagic());
        buffer.putInt(100);
        buffer.putInt(100);
        buffer.putLong(0L);
        buffer.put(ChecksumType.CRC32C.getCode());
        buffer.putInt(16384);
        buffer.putInt(133);
        for (int i = 0; i < 100; ++i) {
            buffer.put((byte)(i % 256));
        }
        return buffer.array();
    }

    private static class MockHFileDataBlock
    extends HFileDataBlock {
        public MockHFileDataBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
            super(context, byteBuff, startOffsetInBuff);
        }
    }
}

