/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.HFileReader;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.io.hfile.KeyValue;
import org.apache.hudi.io.hfile.TestHFileReader;
import org.apache.hudi.io.util.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;

class TestHFileReadCompatibility {
    private static final List<TestRecord> TEST_RECORDS = Arrays.asList(new TestRecord("row1", "value1"), new TestRecord("row2", "value2"), new TestRecord("row3", "value3"), new TestRecord("row4", "value4"), new TestRecord("row5", "value5"));

    TestHFileReadCompatibility() {
    }

    @ParameterizedTest
    @CsvSource(value={"/hfile/hudi-generated.hfile,/hfile/hbase-generated.hfile", "/hfile/hbase-generated.hfile,/hfile/hudi-generated.hfile"})
    void testHFileReadCompatibility(String hudiFilePath, String hbaseFilePath) throws Exception {
        try (HFileReader hudiReader = TestHFileReadCompatibility.createHFileReaderFromResource(hudiFilePath);
             HFile.Reader hbaseReader = TestHFileReadCompatibility.createHBaseHFileReaderFromResource(hbaseFilePath);){
            Assertions.assertEquals((long)5L, (long)hudiReader.getNumKeyValueEntries());
            Assertions.assertEquals((long)5L, (long)hbaseReader.getEntries());
            hudiReader.seekTo();
            HFileScanner scanner = hbaseReader.getScanner(true, true);
            scanner.seekTo();
            int i = 0;
            do {
                KeyValue keyValue = (KeyValue)hudiReader.getKeyValue().get();
                Cell cell = scanner.getCell();
                Assertions.assertEquals((Object)TestHFileReadCompatibility.TEST_RECORDS.get((int)i).key, (Object)keyValue.getKey().getContentInString());
                byte[] value = Arrays.copyOfRange(keyValue.getBytes(), keyValue.getValueOffset(), keyValue.getValueOffset() + keyValue.getValueLength());
                Assertions.assertArrayEquals((byte[])value, (byte[])TestHFileReadCompatibility.TEST_RECORDS.get((int)i).value.getBytes());
                byte[] key = Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
                Assertions.assertArrayEquals((byte[])TestHFileReadCompatibility.TEST_RECORDS.get((int)i).key.getBytes(), (byte[])key);
                value = Arrays.copyOfRange(cell.getValueArray(), cell.getValueOffset(), cell.getValueOffset() + cell.getValueLength());
                Assertions.assertArrayEquals((byte[])value, (byte[])TestHFileReadCompatibility.TEST_RECORDS.get((int)i).value.getBytes());
                ++i;
            } while (hudiReader.next() && scanner.next());
            Assertions.assertTrue((boolean)hbaseReader.getHFileInfo().containsKey((Object)HFileInfo.LAST_KEY.getBytes()));
            Assertions.assertTrue((boolean)hudiReader.getMetaInfo(HFileInfo.LAST_KEY).isPresent());
            if (((byte[])hudiReader.getMetaInfo(HFileInfo.LAST_KEY).get()).length < hbaseReader.getHFileInfo().get((Object)HFileInfo.LAST_KEY.getBytes()).length) {
                Assertions.assertTrue((boolean)TestHFileReadCompatibility.isPrefix((byte[])hudiReader.getMetaInfo(HFileInfo.LAST_KEY).get(), hbaseReader.getHFileInfo().get((Object)HFileInfo.LAST_KEY.getBytes())));
            } else {
                Assertions.assertTrue((boolean)TestHFileReadCompatibility.isPrefix(hbaseReader.getHFileInfo().get((Object)HFileInfo.LAST_KEY.getBytes()), (byte[])hudiReader.getMetaInfo(HFileInfo.LAST_KEY).get()));
            }
            Assertions.assertTrue((boolean)hbaseReader.getHFileInfo().containsKey((Object)HFileInfo.AVG_KEY_LEN.getBytes()));
            Assertions.assertTrue((boolean)hudiReader.getMetaInfo(HFileInfo.AVG_KEY_LEN).isPresent());
            Assertions.assertTrue((boolean)hbaseReader.getHFileInfo().containsKey((Object)HFileInfo.AVG_VALUE_LEN.getBytes()));
            Assertions.assertTrue((boolean)hudiReader.getMetaInfo(HFileInfo.AVG_VALUE_LEN).isPresent());
            Assertions.assertTrue((hbaseReader.getHFileInfo().getAvgValueLen() >= IOUtils.readInt((byte[])((byte[])hudiReader.getMetaInfo(HFileInfo.AVG_VALUE_LEN).get()), (int)0) ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)hbaseReader.getHFileInfo().shouldIncludeMemStoreTS());
            Assertions.assertFalse((boolean)hbaseReader.getHFileInfo().isDecodeMemstoreTS());
            Assertions.assertTrue((boolean)hudiReader.getMetaInfo(HFileInfo.KEY_VALUE_VERSION).isPresent());
            Assertions.assertTrue((boolean)hudiReader.getMetaInfo(HFileInfo.MAX_MVCC_TS_KEY).isPresent());
            Assertions.assertEquals((long)0L, (long)IOUtils.readLong((byte[])((byte[])hudiReader.getMetaInfo(HFileInfo.MAX_MVCC_TS_KEY).get()), (int)0));
        }
    }

    @Test
    void testHbaseReaderSucceedsWhenKeyValueVersionIsSetTo1() throws IOException {
        String fileName = "hudi-generated-for-keyvalue-versions";
        Path tempFile = new Path(Files.createTempFile(fileName, ".hfile", new FileAttribute[0]).toString());
        this.writeHFileWithHudi(tempFile, 1);
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)new Path(tempFile.toString()), (Configuration)conf);
        byte[] keyValueVersion = reader.getHFileInfo().get((Object)HFileInfo.KEY_VALUE_VERSION.getBytes());
        Assertions.assertEquals((int)1, (int)IOUtils.readInt((byte[])keyValueVersion, (int)0));
        Assertions.assertEquals((long)5L, (long)reader.getEntries());
        HFileScanner scanner = reader.getScanner(true, true);
        scanner.seekTo();
        Assertions.assertDoesNotThrow(() -> {
            int i = 0;
            do {
                Cell cell = scanner.getCell();
                byte[] key = Arrays.copyOfRange(cell.getRowArray(), cell.getRowOffset(), cell.getRowOffset() + cell.getRowLength());
                Assertions.assertArrayEquals((byte[])TestHFileReadCompatibility.TEST_RECORDS.get((int)i).key.getBytes(), (byte[])key);
                ++i;
            } while (scanner.next());
        });
    }

    static boolean isPrefix(byte[] prefix, byte[] array) {
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (prefix[i] == array[i]) continue;
            return false;
        }
        return true;
    }

    static HFileReader createHFileReaderFromResource(String fileName) throws IOException {
        byte[] hfileData = TestHFileReadCompatibility.readHFileFromResources(fileName);
        ByteBuffer buffer = ByteBuffer.wrap(hfileData);
        ByteArraySeekableDataInputStream inputStream = new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream(buffer));
        return new HFileReaderImpl((SeekableDataInputStream)inputStream, (long)hfileData.length);
    }

    static HFile.Reader createHBaseHFileReaderFromResource(String fileName) throws IOException {
        byte[] hfileData = TestHFileReadCompatibility.readHFileFromResources(fileName);
        Path tempFile = new Path(Files.createTempFile("hbase_hfile_", ".hfile", new FileAttribute[0]).toString());
        try {
            Files.write(Paths.get(tempFile.toString(), new String[0]), hfileData, new OpenOption[0]);
            Configuration conf = new Configuration();
            FileSystem fs = FileSystem.get((Configuration)conf);
            HFile.Reader reader = HFile.createReader((FileSystem)fs, (Path)new Path(tempFile.toString()), (Configuration)conf);
            return reader;
        }
        catch (IOException e) {
            Files.deleteIfExists(Paths.get(tempFile.toString(), new String[0]));
            throw e;
        }
    }

    private static byte[] readHFileFromResources(String filename) throws IOException {
        long size = Objects.requireNonNull(TestHFileReadCompatibility.class.getResource(filename)).openConnection().getContentLength();
        return FileIOUtils.readAsByteArray((InputStream)TestHFileReader.class.getResourceAsStream(filename), (int)((int)size));
    }

    void testWriteHFiles() throws IOException, URISyntaxException {
        String hbaseFile = Paths.get("src/test/resources/hfile/hbase-generated.hfile", new String[0]).toAbsolutePath().toString();
        String hudiFile = Paths.get("src/test/resources/hfile/hudi-generated.hfile", new String[0]).toAbsolutePath().toString();
        this.writeHFileWithHbase(new Path(hbaseFile));
        this.writeHFileWithHudi(new Path(hudiFile));
    }

    private void writeHFileWithHbase(Path filePath) throws IOException {
        Configuration conf = new Configuration();
        FileSystem fs = FileSystem.get((Configuration)conf);
        org.apache.hadoop.hbase.io.hfile.HFileContext context = new HFileContextBuilder().withBlockSize(65536).withCompression(Compression.Algorithm.NONE).withCellComparator((CellComparator)CellComparatorImpl.COMPARATOR).withIncludesMvcc(true).build();
        try (HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)new CacheConfig(conf)).withPath(fs, filePath).withFileContext(context).create();){
            for (TestRecord record : TEST_RECORDS) {
                org.apache.hadoop.hbase.KeyValue kv = new org.apache.hadoop.hbase.KeyValue(Bytes.toBytes((String)record.key), new byte[0], new byte[0], 0L, Bytes.toBytes((String)record.value));
                writer.append((Cell)kv);
            }
        }
    }

    private void writeHFileWithHudi(Path filePath) throws IOException {
        this.writeHFileWithHudi(filePath, 1);
    }

    private void writeHFileWithHudi(Path filePath, int keyValueVersion) throws IOException {
        HFileContext context = HFileContext.builder().blockSize(65536).build();
        try (DataOutputStream outputStream = new DataOutputStream(Files.newOutputStream(Paths.get(filePath.toString(), new String[0]), new OpenOption[0]));
             HFileWriterImpl writer = new HFileWriterImpl(context, (OutputStream)outputStream);){
            for (TestRecord record : TEST_RECORDS) {
                writer.append(record.key, record.value.getBytes("UTF-8"));
            }
            writer.appendMetaInfo("bloom_filter", "random_string".getBytes());
            if (keyValueVersion != 1) {
                writer.appendFileInfo(new String(HFileInfo.KEY_VALUE_VERSION.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes((int)keyValueVersion));
            }
        }
    }

    private static class TestRecord {
        final String key;
        final String value;

        TestRecord(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return "TestRecord{key='" + this.key + "', value='" + this.value + "'}";
        }
    }
}

