/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.io.ByteBufferBackedInputStream;
import org.apache.hudi.io.ByteArraySeekableDataInputStream;
import org.apache.hudi.io.SeekableDataInputStream;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.HFileReaderImpl;
import org.apache.hudi.io.hfile.HFileTrailer;
import org.apache.hudi.io.hfile.HFileWriterImpl;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.KeyValue;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestHFileWriter {
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileWriter.class);
    private static final String TEST_FILE = "test.hfile";
    private static final HFileContext CONTEXT = HFileContext.builder().build();

    TestHFileWriter() {
    }

    @AfterEach
    public void tearDown() throws IOException {
        Files.deleteIfExists(Paths.get(TEST_FILE, new String[0]));
    }

    @Test
    void testOverflow() throws Exception {
        TestHFileWriter.writeTestFile();
        TestHFileWriter.validateHFileSize();
        TestHFileWriter.validateHFileStructure();
        TestHFileWriter.validateConsistencyWithHFileReader();
        LOG.info("All validations passed!");
    }

    @Test
    void testSameKeyLocation() throws IOException {
        Throwable throwable;
        HFileContext context = new HFileContext.Builder().blockSize(165).build();
        String testFile = TEST_FILE;
        try {
            throwable = null;
            try (DataOutputStream outputStream = new DataOutputStream(Files.newOutputStream(Paths.get(testFile, new String[0]), new OpenOption[0]));
                 HFileWriterImpl writer2 = new HFileWriterImpl(context, (OutputStream)outputStream);){
                int i;
                for (i = 0; i < 100; ++i) {
                    writer2.append("key00", String.format("value%02d", i).getBytes());
                }
                for (i = 1; i < 11; ++i) {
                    writer2.append(String.format("key%02d", i), String.format("value%02d", i).getBytes());
                }
                String longValue = TestHFileWriter.generateRandomStringStream(200);
                writer2.append("key11", longValue.getBytes());
            }
            catch (Throwable writer2) {
                throwable = writer2;
                throw writer2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throwable = null;
        try (FileChannel channel = FileChannel.open(Paths.get(testFile, new String[0]), StandardOpenOption.READ);){
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            ByteArraySeekableDataInputStream inputStream = new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream((ByteBuffer)buf));
            HFileReaderImpl reader = new HFileReaderImpl((SeekableDataInputStream)inputStream, channel.size());
            reader.initializeMetadata();
            Assertions.assertEquals((long)111L, (long)reader.getNumKeyValueEntries());
            HFileTrailer trailer = reader.getTrailer();
            Assertions.assertEquals((int)4, (int)trailer.getDataIndexCount());
            int i = 0;
            for (Map.Entry entry : reader.getDataBlockIndexMap().entrySet()) {
                if (i == 0) {
                    Assertions.assertEquals((int)3337, (int)((BlockIndexEntry)entry.getValue()).getSize());
                    Assertions.assertEquals((Object)"key00", (Object)((Key)entry.getKey()).getContentInString());
                    ++i;
                    continue;
                }
                if (i == 1 || i == 6) {
                    Assertions.assertEquals((int)202, (int)((BlockIndexEntry)entry.getValue()).getSize());
                    Assertions.assertEquals((Object)String.format("key%02d", i), (Object)((Key)entry.getKey()).getContentInString());
                    i += 5;
                    continue;
                }
                Assertions.assertEquals((int)263, (int)((BlockIndexEntry)entry.getValue()).getSize());
                Assertions.assertEquals((Object)String.format("key%02d", i), (Object)((Key)entry.getKey()).getContentInString());
                ++i;
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    @Test
    void testUniqueKeyLocation() throws IOException {
        Throwable throwable;
        HFileContext context = new HFileContext.Builder().blockSize(100).build();
        String testFile = TEST_FILE;
        try {
            throwable = null;
            try (DataOutputStream outputStream = new DataOutputStream(Files.newOutputStream(Paths.get(testFile, new String[0]), new OpenOption[0]));
                 HFileWriterImpl writer2 = new HFileWriterImpl(context, (OutputStream)outputStream);){
                for (int i = 0; i < 50; ++i) {
                    writer2.append(String.format("key%02d", i), String.format("value%02d", i).getBytes());
                }
            }
            catch (Throwable writer2) {
                throwable = writer2;
                throw writer2;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        throwable = null;
        try (FileChannel channel = FileChannel.open(Paths.get(testFile, new String[0]), StandardOpenOption.READ);){
            MappedByteBuffer buf = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            ByteArraySeekableDataInputStream inputStream = new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream((ByteBuffer)buf));
            HFileReaderImpl reader = new HFileReaderImpl((SeekableDataInputStream)inputStream, channel.size());
            reader.initializeMetadata();
            Assertions.assertEquals((long)50L, (long)reader.getNumKeyValueEntries());
            HFileTrailer trailer = reader.getTrailer();
            Assertions.assertEquals((int)17, (int)trailer.getDataIndexCount());
            reader.seekTo();
            for (int i = 0; i < 50; ++i) {
                KeyValue kv = (KeyValue)reader.getKeyValue().get();
                TestHFileWriter.assertArrayEquals(String.format("key%02d", i).getBytes(), kv.getKey().getContentInString().getBytes());
                TestHFileWriter.assertArrayEquals(String.format("value%02d", i).getBytes(), Arrays.copyOfRange(kv.getBytes(), kv.getValueOffset(), kv.getValueOffset() + kv.getValueLength()));
                reader.next();
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private static void writeTestFile() throws Exception {
        try (DataOutputStream outputStream = new DataOutputStream(Files.newOutputStream(Paths.get(TEST_FILE, new String[0]), new OpenOption[0]));
             HFileWriterImpl writer = new HFileWriterImpl(CONTEXT, (OutputStream)outputStream);){
            writer.append("key1", "value1".getBytes());
            writer.append("key2", "value2".getBytes());
            writer.append("key3", "value3".getBytes());
        }
    }

    private static void validateHFileSize() throws IOException {
        Path path = Paths.get(TEST_FILE, new String[0]);
        long actualSize = Files.size(path);
        long expectedSize = 4537L;
        Assertions.assertEquals((long)expectedSize, (long)actualSize);
    }

    private static void validateHFileStructure() throws IOException {
        ByteBuffer fileBuffer = TestHFileWriter.mapFileToBuffer();
        TestHFileWriter.validateTrailer(fileBuffer);
        TestHFileWriter.validateDataBlocks(fileBuffer);
    }

    private static void validateConsistencyWithHFileReader() throws IOException {
        ByteBuffer content = TestHFileWriter.mapFileToBuffer();
        try (HFileReaderImpl reader = new HFileReaderImpl((SeekableDataInputStream)new ByteArraySeekableDataInputStream(new ByteBufferBackedInputStream(content)), (long)content.limit());){
            reader.initializeMetadata();
            Assertions.assertEquals((long)3L, (long)reader.getNumKeyValueEntries());
            Assertions.assertTrue((boolean)reader.getMetaInfo(HFileInfo.LAST_KEY).isPresent());
            Assertions.assertEquals((int)4, (int)((byte[])reader.getMetaInfo(HFileInfo.AVG_KEY_LEN).get()).length);
            Assertions.assertEquals((int)4, (int)((byte[])reader.getMetaInfo(HFileInfo.AVG_VALUE_LEN).get()).length);
            Assertions.assertEquals((int)8, (int)((byte[])reader.getMetaInfo(HFileInfo.MAX_MVCC_TS_KEY).get()).length);
            Assertions.assertEquals((int)1, (int)ByteBuffer.wrap((byte[])reader.getMetaInfo(HFileInfo.KEY_VALUE_VERSION).get()).getInt());
        }
    }

    private static ByteBuffer mapFileToBuffer() throws IOException {
        try (FileChannel channel = FileChannel.open(Paths.get(TEST_FILE, new String[0]), StandardOpenOption.READ);){
            MappedByteBuffer mappedByteBuffer = channel.map(FileChannel.MapMode.READ_ONLY, 0L, channel.size());
            return mappedByteBuffer;
        }
    }

    private static void validateTrailer(ByteBuffer buf) {
        int trailerStart = Math.max(0, buf.limit() - 4096);
        buf.position(trailerStart);
        byte[] trailerMagic = new byte[8];
        buf.get(trailerMagic);
        TestHFileWriter.assertArrayEquals(HFileBlockType.TRAILER.getMagic(), trailerMagic);
        buf.position(trailerStart + 4096 - 4);
        byte[] versionBytes = new byte[4];
        buf.get(versionBytes);
        int version = ByteBuffer.wrap(versionBytes).getInt();
        Assertions.assertEquals((int)3, (int)version);
    }

    private static void validateDataBlocks(ByteBuffer buf) {
        buf.position(0);
        byte[] dataBlockMagic = new byte[8];
        buf.get(dataBlockMagic);
        TestHFileWriter.assertArrayEquals(HFileBlockType.DATA.getMagic(), dataBlockMagic);
        buf.position(buf.position() + 25);
        TestHFileWriter.validateKeyValue(buf, "key1", "value1");
        TestHFileWriter.validateKeyValue(buf, "key2", "value2");
        TestHFileWriter.validateKeyValue(buf, "key3", "value3");
    }

    private static void validateKeyValue(ByteBuffer buf, String expectedKey, String expectedValue) {
        int keyLen = buf.getInt();
        int valLen = buf.getInt();
        byte[] key = new byte[keyLen];
        buf.get(key);
        byte[] keyContent = Arrays.copyOfRange(key, 2, key.length - 10);
        TestHFileWriter.assertArrayEquals(expectedKey.getBytes(StandardCharsets.UTF_8), keyContent);
        byte[] value = new byte[valLen];
        buf.get(value);
        TestHFileWriter.assertArrayEquals(expectedValue.getBytes(StandardCharsets.UTF_8), value);
        buf.get();
    }

    private static void assertArrayEquals(byte[] expected, byte[] actual) {
        if (!Arrays.equals(expected, actual)) {
            throw new AssertionError((Object)"Byte array mismatch");
        }
    }

    public static String generateRandomStringStream(int length) {
        String characters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        return random.ints(length, 0, characters.length()).mapToObj(characters::charAt).map(Object::toString).collect(Collectors.joining());
    }
}

