/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import org.apache.hudi.io.hfile.HFileBlock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHfileBlock {
    TestHfileBlock() {
    }

    @Test
    void testNumChecksumChunksZeroBytes() {
        Assertions.assertEquals((int)0, (int)HFileBlock.numChecksumChunks((long)0L, (int)512));
    }

    @Test
    void testNumChecksumChunksExactDivision() {
        Assertions.assertEquals((int)2, (int)HFileBlock.numChecksumChunks((long)1024L, (int)512));
    }

    @Test
    void testNumChecksumChunksWithRemainder() {
        Assertions.assertEquals((int)3, (int)HFileBlock.numChecksumChunks((long)1200L, (int)512));
    }

    @Test
    void testNumChecksumChunksSingleChunk() {
        Assertions.assertEquals((int)1, (int)HFileBlock.numChecksumChunks((long)200L, (int)512));
    }

    @Test
    void testNumChecksumChunksOverflowThrows() {
        long numBytes = 0x8000000000L;
        Assertions.assertThrows(IllegalArgumentException.class, () -> HFileBlock.numChecksumChunks((long)numBytes, (int)1024));
    }
}

