/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<String, Class<?>> CLAZZ_CACHE = new ConcurrentHashMap();

    public static Class<?> getClass(String clazzName) {
        return CLAZZ_CACHE.computeIfAbsent(clazzName, c -> {
            try {
                return Class.forName(c);
            }
            catch (ClassNotFoundException e) {
                throw new HoodieException("Unable to load class", e);
            }
        });
    }

    public static <T> T loadClass(String className) {
        try {
            return (T)ReflectionUtils.getClass(className).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new HoodieException("Could not load class " + className, e);
        }
    }

    public static Object loadClass(String clazz, Class<?>[] constructorArgTypes, Object ... constructorArgs) {
        try {
            return ReflectionUtils.getClass(clazz).getConstructor(constructorArgTypes).newInstance(constructorArgs);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HoodieException("Unable to instantiate class " + clazz, e);
        }
    }

    public static boolean hasConstructor(String clazz, Class<?>[] constructorArgTypes) {
        return ReflectionUtils.hasConstructor(clazz, constructorArgTypes, true);
    }

    public static boolean hasConstructor(String clazz, Class<?>[] constructorArgTypes, boolean silenceWarning) {
        try {
            ReflectionUtils.getClass(clazz).getConstructor(constructorArgTypes);
            return true;
        }
        catch (NoSuchMethodException e) {
            String message = "Unable to instantiate class " + clazz;
            if (silenceWarning) {
                LOG.debug(message, (Throwable)e);
            } else {
                LOG.warn(message, (Throwable)e);
            }
            return false;
        }
    }

    public static Object loadClass(String clazz, Object ... constructorArgs) {
        Class[] constructorArgTypes = (Class[])Arrays.stream(constructorArgs).map(Object::getClass).toArray(Class[]::new);
        return ReflectionUtils.loadClass(clazz, constructorArgTypes, constructorArgs);
    }

    public static Stream<String> getTopLevelClassesInClasspath(Class<?> clazz) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String packageName = clazz.getPackage().getName();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = null;
        try {
            resources = classLoader.getResources(path);
        }
        catch (IOException e) {
            LOG.error("Unable to fetch Resources in package " + e.getMessage());
        }
        ArrayList<File> directories = new ArrayList<File>();
        while (Objects.requireNonNull(resources).hasMoreElements()) {
            URL resource = resources.nextElement();
            try {
                directories.add(new File(resource.toURI()));
            }
            catch (URISyntaxException e) {
                LOG.error("Unable to get " + e.getMessage());
            }
        }
        ArrayList<String> classes = new ArrayList<String>();
        for (File directory : directories) {
            classes.addAll(ReflectionUtils.findClasses(directory, packageName));
        }
        return classes.stream();
    }

    private static List<String> findClasses(File directory, String packageName) {
        ArrayList<String> classes = new ArrayList<String>();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        for (File file : Objects.requireNonNull(files)) {
            if (file.isDirectory()) {
                classes.addAll(ReflectionUtils.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(packageName + '.' + file.getName().substring(0, file.getName().length() - 6));
        }
        return classes;
    }

    public static Object invokeStaticMethod(String clazz, String methodName, Object[] args, Class<?> ... parametersType) {
        try {
            Method method = Class.forName(clazz).getMethod(methodName, parametersType);
            return method.invoke(null, args);
        }
        catch (ClassNotFoundException e) {
            throw new HoodieException("Unable to find the class " + clazz, e);
        }
        catch (NoSuchMethodException e) {
            throw new HoodieException(String.format("Unable to find the method %s of the class %s ", methodName, clazz), e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new HoodieException(String.format("Unable to invoke the method %s of the class %s ", methodName, clazz), e);
        }
    }

    public static Option<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parametersType) {
        try {
            return Option.of(clazz.getMethod(methodName, parametersType));
        }
        catch (Throwable e) {
            return Option.empty();
        }
    }

    public static boolean isSubClass(String aClazzName, Class<?> superClazz) {
        return superClazz.isAssignableFrom(ReflectionUtils.getClass(aClazzName));
    }
}

