/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hudi.common.util.ValidationUtils;

public enum CompressionCodec {
    NONE("none", 2),
    BZIP2("bz2", 5),
    GZIP("gz", 1),
    LZ4("lz4", 4),
    LZO("lzo", 0),
    SNAPPY("snappy", 3),
    ZSTD("zstd", 6);

    private static final Map<String, CompressionCodec> NAME_TO_COMPRESSION_CODEC_MAP;
    private static final Map<Integer, CompressionCodec> ID_TO_COMPRESSION_CODEC_MAP;
    private final String name;
    private final int id;

    private CompressionCodec(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public static CompressionCodec findCodecByName(String name) {
        CompressionCodec codec = NAME_TO_COMPRESSION_CODEC_MAP.get(name.toLowerCase());
        ValidationUtils.checkArgument(codec != null, String.format("Cannot find compression codec: %s", name));
        return codec;
    }

    public static CompressionCodec decodeCompressionCodec(int id) {
        CompressionCodec codec = ID_TO_COMPRESSION_CODEC_MAP.get(id);
        ValidationUtils.checkArgument(codec != null, "Compression code not found for ID: " + id);
        return codec;
    }

    private static Map<String, CompressionCodec> createNameToCompressionCodecMap() {
        return Collections.unmodifiableMap(Arrays.stream(CompressionCodec.values()).collect(Collectors.toMap(CompressionCodec::getName, Function.identity())));
    }

    private static Map<Integer, CompressionCodec> createIdToCompressionCodecMap() {
        return Collections.unmodifiableMap(Arrays.stream(CompressionCodec.values()).collect(Collectors.toMap(CompressionCodec::getId, Function.identity())));
    }

    static {
        NAME_TO_COMPRESSION_CODEC_MAP = CompressionCodec.createNameToCompressionCodecMap();
        ID_TO_COMPRESSION_CODEC_MAP = CompressionCodec.createIdToCompressionCodecMap();
    }
}

