/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.compress.airlift;

import io.airlift.compress.gzip.JdkGzipHadoopStreams;
import io.airlift.compress.hadoop.HadoopInputStream;
import io.airlift.compress.hadoop.HadoopOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hudi.io.compress.HoodieCompressor;
import org.apache.hudi.io.util.IOUtils;

public class HoodieAirliftGzipCompressor
implements HoodieCompressor {
    private final JdkGzipHadoopStreams gzipStreams = new JdkGzipHadoopStreams();

    @Override
    public int decompress(InputStream compressedInput, byte[] targetByteArray, int offset, int length) throws IOException {
        try (HadoopInputStream stream = this.gzipStreams.createInputStream(compressedInput);){
            int n = IOUtils.readFully((InputStream)stream, targetByteArray, offset, length);
            return n;
        }
    }

    @Override
    public byte[] compress(byte[] data) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (HadoopOutputStream gzipOutputStream = this.gzipStreams.createOutputStream((OutputStream)byteArrayOutputStream);){
            gzipOutputStream.write(data);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public ByteBuffer compress(ByteBuffer uncompressedBytes) throws IOException {
        byte[] temp = new byte[uncompressedBytes.remaining()];
        uncompressedBytes.get(temp);
        return ByteBuffer.wrap(this.compress(temp));
    }
}

