/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.io.hfile.HFileBlock;

public class HFileBlockCache {
    private final Cache<BlockCacheKey, HFileBlock> cache;

    public HFileBlockCache(int maxCacheSize, long expireAfterWrite, TimeUnit timeUnit) {
        this.cache = Caffeine.newBuilder().maximumSize((long)maxCacheSize).expireAfterAccess(Duration.ofMillis(timeUnit.toMillis(expireAfterWrite))).build();
    }

    public HFileBlock getBlock(BlockCacheKey key) {
        return (HFileBlock)this.cache.getIfPresent((Object)key);
    }

    public void putBlock(BlockCacheKey key, HFileBlock block) {
        this.cache.put((Object)key, (Object)block);
    }

    public HFileBlock getOrCompute(BlockCacheKey key, Callable<HFileBlock> loader) throws Exception {
        return (HFileBlock)this.cache.get((Object)key, k -> {
            try {
                return (HFileBlock)loader.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public long size() {
        return this.cache.estimatedSize();
    }

    public void cleanUp() {
        this.cache.cleanUp();
    }

    public static class BlockCacheKey {
        private final String fileIdentity;
        private final long offset;
        private final int size;

        public BlockCacheKey(String fileIdentity, long offset, int size) {
            this.fileIdentity = fileIdentity;
            this.offset = offset;
            this.size = size;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BlockCacheKey that = (BlockCacheKey)o;
            return this.offset == that.offset && this.size == that.size && Objects.equals(this.fileIdentity, that.fileIdentity);
        }

        public int hashCode() {
            int result = this.fileIdentity != null ? this.fileIdentity.hashCode() : 0;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.size;
            return result;
        }

        public String toString() {
            return "BlockCacheKey{fileIdentity='" + this.fileIdentity + '\'' + ", offset=" + this.offset + ", size=" + this.size + '}';
        }
    }
}

