/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileIndexBlock;

public class HFileMetaIndexBlock
extends HFileIndexBlock {
    private HFileMetaIndexBlock(HFileContext context) {
        super(context, HFileBlockType.ROOT_INDEX);
    }

    public static HFileMetaIndexBlock createMetaIndexBlockToWrite(HFileContext context) {
        return new HFileMetaIndexBlock(context);
    }

    @Override
    public ByteBuffer getUncompressedBlockDataToWrite() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.context.getBlockSize());
        try (DataOutputStream outputStream = new DataOutputStream(baos);){
            for (BlockIndexEntry entry : this.entries) {
                outputStream.writeLong(entry.getOffset());
                outputStream.writeInt(entry.getSize());
                try {
                    byte[] keyLength = HFileMetaIndexBlock.getVariableLengthEncodedBytes(entry.getFirstKey().getLength());
                    outputStream.write(keyLength);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize number: " + entry.getFirstKey().getLength());
                }
                outputStream.write(entry.getFirstKey().getBytes());
            }
        }
        byte[] allData = baos.toByteArray();
        this.blockDataSize = allData.length;
        return ByteBuffer.wrap(allData);
    }
}

