/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.io.hfile.BlockIndexEntry;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileIndexBlock;
import org.apache.hudi.io.hfile.Key;
import org.apache.hudi.io.hfile.UTF8StringKey;
import org.apache.hudi.io.util.IOUtils;

public class HFileRootIndexBlock
extends HFileIndexBlock {
    public HFileRootIndexBlock(HFileContext context, byte[] byteBuff, int startOffsetInBuff) {
        super(context, HFileBlockType.ROOT_INDEX, byteBuff, startOffsetInBuff);
    }

    private HFileRootIndexBlock(HFileContext context) {
        super(context, HFileBlockType.ROOT_INDEX);
    }

    public static HFileRootIndexBlock createRootIndexBlockToWrite(HFileContext context) {
        return new HFileRootIndexBlock(context);
    }

    public TreeMap<Key, BlockIndexEntry> readBlockIndex(int numEntries, boolean contentKeyOnly) {
        TreeMap<Key, BlockIndexEntry> blockIndexEntryMap = new TreeMap<Key, BlockIndexEntry>();
        List<BlockIndexEntry> indexEntryList = this.readBlockIndexEntry(numEntries, contentKeyOnly);
        for (int i = 0; i < numEntries; ++i) {
            Key key = indexEntryList.get(i).getFirstKey();
            blockIndexEntryMap.put(key, new BlockIndexEntry(key, i < numEntries - 1 ? Option.of(indexEntryList.get(i + 1).getFirstKey()) : Option.empty(), indexEntryList.get(i).getOffset(), indexEntryList.get(i).getSize()));
        }
        return blockIndexEntryMap;
    }

    public List<BlockIndexEntry> readBlockIndexEntry(int numEntries, boolean contentKeyOnly) {
        ArrayList<BlockIndexEntry> indexEntryList = new ArrayList<BlockIndexEntry>();
        int buffOffset = this.startOffsetInBuff + 33;
        for (int i = 0; i < numEntries; ++i) {
            long offset = IOUtils.readLong(this.byteBuff, buffOffset);
            int size = IOUtils.readInt(this.byteBuff, buffOffset + 8);
            int varLongSizeOnDist = IOUtils.decodeVarLongSizeOnDisk(this.byteBuff, buffOffset + 12);
            int keyLength = (int)IOUtils.readVarLong(this.byteBuff, buffOffset + 12, varLongSizeOnDist);
            byte[] keyBytes = IOUtils.copy(this.byteBuff, buffOffset + 12 + varLongSizeOnDist, keyLength);
            Key key = contentKeyOnly ? new UTF8StringKey(keyBytes) : new Key(keyBytes);
            indexEntryList.add(new BlockIndexEntry(key, Option.empty(), offset, size));
            buffOffset += 12 + varLongSizeOnDist + keyLength;
        }
        return indexEntryList;
    }

    @Override
    public ByteBuffer getUncompressedBlockDataToWrite() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(this.context.getBlockSize());
        try (DataOutputStream outputStream = new DataOutputStream(baos);){
            for (BlockIndexEntry entry : this.entries) {
                outputStream.writeLong(entry.getOffset());
                outputStream.writeInt(entry.getSize());
                try {
                    byte[] keyLength = HFileRootIndexBlock.getVariableLengthEncodedBytes(entry.getFirstKey().getLength() + 2);
                    outputStream.write(keyLength);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to serialize number: " + entry.getFirstKey().getLength() + 2);
                }
                outputStream.writeShort((short)entry.getFirstKey().getLength());
                outputStream.write(entry.getFirstKey().getBytes());
            }
        }
        byte[] allData = baos.toByteArray();
        this.blockDataSize = allData.length;
        return ByteBuffer.wrap(allData);
    }
}

