/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.hfile;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.io.hfile.HFileBlock;
import org.apache.hudi.io.hfile.HFileBlockType;
import org.apache.hudi.io.hfile.HFileContext;
import org.apache.hudi.io.hfile.HFileDataBlock;
import org.apache.hudi.io.hfile.HFileFileInfoBlock;
import org.apache.hudi.io.hfile.HFileInfo;
import org.apache.hudi.io.hfile.HFileMetaBlock;
import org.apache.hudi.io.hfile.HFileMetaIndexBlock;
import org.apache.hudi.io.hfile.HFileRootIndexBlock;
import org.apache.hudi.io.hfile.HFileWriter;
import org.apache.hudi.io.hfile.KeyValueEntry;
import org.apache.hudi.io.hfile.protobuf.generated.HFileProtos;
import org.apache.hudi.io.util.IOUtils;

public class HFileWriterImpl
implements HFileWriter {
    private static final String COMPARATOR_CLASS_NAME = "org.apache.hudi.io.storage.HoodieHBaseKVComparator";
    private static final byte HFILE_VERSION = 3;
    private static final int EXTRA_BYTES_PER_DATA_ENTRY = 21;
    private final OutputStream outputStream;
    private final HFileContext context;
    private final Map<String, byte[]> metaInfo = new HashMap<String, byte[]>();
    private HFileDataBlock currentDataBlock;
    private final HFileRootIndexBlock rootIndexBlock;
    private final HFileMetaIndexBlock metaIndexBlock;
    private final HFileFileInfoBlock fileInfoBlock;
    private long uncompressedDataBlockBytes;
    private long totalUncompressedDataBlockBytes;
    private long currentOffset;
    private long loadOnOpenSectionOffset;
    private final int blockSize;
    private byte[] lastKey = new byte[0];
    private long firstDataBlockOffset = -1L;
    private long lastDataBlockOffset;
    private long totalNumberOfRecords = 0L;
    private long totalKeyLength = 0L;
    private long totalValueLength = 0L;

    public HFileWriterImpl(HFileContext context, OutputStream outputStream) {
        this.outputStream = outputStream;
        this.context = context;
        this.blockSize = this.context.getBlockSize();
        this.uncompressedDataBlockBytes = 0L;
        this.totalUncompressedDataBlockBytes = 0L;
        this.currentOffset = 0L;
        this.currentDataBlock = HFileDataBlock.createDataBlockToWrite(context, -1L);
        this.rootIndexBlock = HFileRootIndexBlock.createRootIndexBlockToWrite(context);
        this.metaIndexBlock = HFileMetaIndexBlock.createMetaIndexBlockToWrite(context);
        this.fileInfoBlock = HFileFileInfoBlock.createFileInfoBlockToWrite(context);
        this.initFileInfo();
    }

    @Override
    public void append(String key, byte[] value) throws IOException {
        byte[] keyBytes = StringUtils.getUTF8Bytes(key);
        this.lastKey = keyBytes;
        this.totalKeyLength += (long)keyBytes.length;
        this.totalValueLength += (long)value.length;
        if (!Arrays.equals(this.currentDataBlock.getLastKeyContent(), keyBytes) && this.uncompressedDataBlockBytes + (long)keyBytes.length + (long)value.length + 21L > (long)this.blockSize) {
            this.flushCurrentDataBlock();
            this.uncompressedDataBlockBytes = 0L;
        }
        this.currentDataBlock.add(keyBytes, value);
        int uncompressedKeyValueSize = keyBytes.length + value.length;
        this.uncompressedDataBlockBytes += (long)(uncompressedKeyValueSize + 21);
        this.totalUncompressedDataBlockBytes += (long)(uncompressedKeyValueSize + 21);
    }

    @Override
    public void appendMetaInfo(String name, byte[] value) {
        this.metaInfo.put(name, value);
    }

    @Override
    public void appendFileInfo(String name, byte[] value) {
        this.fileInfoBlock.add(name, value);
    }

    @Override
    public void close() throws IOException {
        this.flushCurrentDataBlock();
        this.flushMetaBlocks();
        this.writeLoadOnOpenSection();
        this.writeTrailer();
        this.outputStream.flush();
        this.outputStream.close();
    }

    private void flushCurrentDataBlock() throws IOException {
        if (this.currentDataBlock.isEmpty()) {
            return;
        }
        if (this.firstDataBlockOffset < 0L) {
            this.firstDataBlockOffset = this.currentOffset;
        }
        this.lastDataBlockOffset = this.currentOffset;
        this.totalNumberOfRecords += (long)this.currentDataBlock.getNumOfEntries();
        ByteBuffer blockBuffer = this.currentDataBlock.serialize();
        this.writeBuffer(blockBuffer);
        this.rootIndexBlock.add(this.currentDataBlock.getFirstKey(), this.lastDataBlockOffset, blockBuffer.limit());
        this.currentDataBlock = HFileDataBlock.createDataBlockToWrite(this.context, this.currentOffset);
    }

    private void flushMetaBlocks() throws IOException {
        for (Map.Entry<String, byte[]> e : this.metaInfo.entrySet()) {
            HFileMetaBlock currentMetaBlock = HFileMetaBlock.createMetaBlockToWrite(this.context, new KeyValueEntry(StringUtils.getUTF8Bytes(e.getKey()), e.getValue()));
            ByteBuffer blockBuffer = currentMetaBlock.serialize();
            long blockOffset = this.currentOffset;
            currentMetaBlock.setStartOffsetInBuffForWrite(this.currentOffset);
            this.writeBuffer(blockBuffer);
            this.metaIndexBlock.add(currentMetaBlock.getFirstKey(), blockOffset, blockBuffer.limit());
        }
    }

    private void writeLoadOnOpenSection() throws IOException {
        this.loadOnOpenSectionOffset = this.currentOffset;
        ByteBuffer dataIndexBuffer = this.rootIndexBlock.serialize();
        this.rootIndexBlock.setStartOffsetInBuffForWrite(this.currentOffset);
        this.writeBuffer(dataIndexBuffer);
        ByteBuffer metaIndexBuffer = this.metaIndexBlock.serialize();
        this.metaIndexBlock.setStartOffsetInBuffForWrite(this.currentOffset);
        this.writeBuffer(metaIndexBuffer);
        this.finishFileInfo();
        this.writeBuffer(this.fileInfoBlock.serialize());
    }

    private void writeTrailer() throws IOException {
        HFileProtos.TrailerProto.Builder builder = HFileProtos.TrailerProto.newBuilder();
        builder.setFileInfoOffset(this.fileInfoBlock.getStartOffsetInBuffForWrite());
        builder.setLoadOnOpenDataOffset(this.loadOnOpenSectionOffset);
        builder.setUncompressedDataIndexSize(this.totalUncompressedDataBlockBytes);
        builder.setDataIndexCount(this.rootIndexBlock.getNumOfEntries());
        builder.setMetaIndexCount(this.metaIndexBlock.getNumOfEntries());
        builder.setEntryCount(this.totalNumberOfRecords);
        builder.setNumDataIndexLevels(1);
        builder.setFirstDataBlockOffset(this.firstDataBlockOffset);
        builder.setLastDataBlockOffset(this.lastDataBlockOffset);
        builder.setComparatorClassName(COMPARATOR_CLASS_NAME);
        builder.setCompressionCodec(this.context.getCompressionCodec().getId());
        HFileProtos.TrailerProto trailerProto = builder.build();
        ByteBuffer trailer = ByteBuffer.allocate(4096);
        trailer.limit(4096);
        trailer.put(HFileBlockType.TRAILER.getMagic());
        trailer.put(HFileBlock.getVariableLengthEncodedBytes(trailerProto.getSerializedSize()));
        trailer.put(trailerProto.toByteArray());
        trailer.position(4095);
        trailer.put((byte)3);
        trailer.flip();
        this.writeBuffer(trailer);
    }

    private void writeBuffer(ByteBuffer buffer) throws IOException {
        this.outputStream.write(buffer.array(), 0, buffer.limit());
        this.currentOffset += (long)buffer.limit();
    }

    private void initFileInfo() {
        this.fileInfoBlock.add(new String(HFileInfo.MAX_MVCC_TS_KEY.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes(0L));
    }

    protected void finishFileInfo() {
        this.fileInfoBlock.add(new String(HFileInfo.LAST_KEY.getBytes(), StandardCharsets.UTF_8), this.addKeyLength(this.lastKey));
        this.fileInfoBlock.setStartOffsetInBuffForWrite(this.currentOffset);
        int avgKeyLen = this.totalNumberOfRecords == 0L ? 0 : (int)(this.totalKeyLength / this.totalNumberOfRecords);
        this.fileInfoBlock.add(new String(HFileInfo.AVG_KEY_LEN.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes(avgKeyLen));
        this.fileInfoBlock.add(new String(HFileInfo.FILE_CREATION_TIME_TS.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes(this.context.getFileCreationTime()));
        int avgValueLen = this.totalNumberOfRecords == 0L ? 0 : (int)(this.totalValueLength / this.totalNumberOfRecords);
        this.fileInfoBlock.add(new String(HFileInfo.AVG_VALUE_LEN.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes(avgValueLen));
        this.appendFileInfo(new String(HFileInfo.KEY_VALUE_VERSION.getBytes(), StandardCharsets.UTF_8), IOUtils.toBytes(1));
    }

    public byte[] addKeyLength(byte[] key) {
        if (0 == key.length) {
            return new byte[0];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(key.length + 2);
        byteBuffer.putShort((short)key.length);
        byteBuffer.put(key);
        return byteBuffer.array();
    }
}

