/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.JavaHoodieIndexFactory;
import org.apache.hudi.table.HoodieJavaCopyOnWriteTable;
import org.apache.hudi.table.HoodieJavaMergeOnReadTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public abstract class HoodieJavaTable<T extends HoodieRecordPayload>
extends HoodieTable<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    protected HoodieJavaTable(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        super(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieJavaTable<T> create(HoodieWriteConfig config, HoodieEngineContext context) {
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(context.getHadoopConf().get()).setBasePath(config.getBasePath()).setLoadActiveTimelineOnLoad(true).setConsistencyGuardConfig(config.getConsistencyGuardConfig()).setLayoutVersion(Option.of((Object)new TimelineLayoutVersion(config.getTimelineLayoutVersion()))).build();
        return HoodieJavaTable.create(config, context, metaClient);
    }

    public static <T extends HoodieRecordPayload> HoodieJavaTable<T> create(HoodieWriteConfig config, HoodieEngineContext context, HoodieTableMetaClient metaClient) {
        switch (metaClient.getTableType()) {
            case COPY_ON_WRITE: {
                return new HoodieJavaCopyOnWriteTable(config, context, metaClient);
            }
            case MERGE_ON_READ: {
                return new HoodieJavaMergeOnReadTable(config, context, metaClient);
            }
        }
        throw new HoodieException("Unsupported table type :" + metaClient.getTableType());
    }

    public static HoodieWriteMetadata<List<WriteStatus>> convertMetadata(HoodieWriteMetadata<HoodieData<WriteStatus>> metadata) {
        return metadata.clone((Object)((HoodieData)metadata.getWriteStatuses()).collectAsList());
    }

    protected HoodieIndex getIndex(HoodieWriteConfig config, HoodieEngineContext context) {
        return JavaHoodieIndexFactory.createIndex(config);
    }
}

