/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.deltacommit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.JavaBulkInsertHelper;
import org.apache.hudi.table.action.deltacommit.BaseJavaDeltaCommitActionExecutor;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JavaUpsertPreppedDeltaCommitActionExecutor<T>
extends BaseJavaDeltaCommitActionExecutor<T> {
    private static final Logger LOG = LogManager.getLogger(JavaUpsertPreppedDeltaCommitActionExecutor.class);
    private final List<HoodieRecord<T>> preppedInputRecords;

    public JavaUpsertPreppedDeltaCommitActionExecutor(HoodieJavaEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> preppedInputRecords) {
        super(context, config, table, instantTime, WriteOperationType.UPSERT_PREPPED);
        this.preppedInputRecords = preppedInputRecords;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        HoodieWriteMetadata result = new HoodieWriteMetadata();
        HashMap<Pair, List> recordsByFileId = new HashMap<Pair, List>();
        LinkedList insertedRecords = new LinkedList();
        for (HoodieRecord<T> record : this.preppedInputRecords) {
            if (!record.isCurrentLocationKnown()) {
                insertedRecords.add(record);
                continue;
            }
            Pair fileIdPartitionPath = Pair.of((Object)record.getCurrentLocation().getFileId(), (Object)record.getPartitionPath());
            if (!recordsByFileId.containsKey(fileIdPartitionPath)) {
                recordsByFileId.put(fileIdPartitionPath, new LinkedList());
            }
            ((List)recordsByFileId.get(fileIdPartitionPath)).add(record);
        }
        LOG.info((Object)String.format("Total update fileIDs %s, total inserts %s for commit %s", recordsByFileId.size(), insertedRecords.size(), this.instantTime));
        ArrayList<WriteStatus> allWriteStatuses = new ArrayList<WriteStatus>();
        try {
            recordsByFileId.forEach((k, v) -> {
                HoodieAppendHandle appendHandle = new HoodieAppendHandle(this.config, this.instantTime, this.table, (String)k.getRight(), (String)k.getLeft(), v.iterator(), this.taskContextSupplier);
                appendHandle.doAppend();
                allWriteStatuses.addAll(appendHandle.close());
            });
            if (insertedRecords.size() > 0) {
                HoodieWriteMetadata<List<WriteStatus>> insertResult = JavaBulkInsertHelper.newInstance().bulkInsert(insertedRecords, this.instantTime, this.table, this.config, this, false, (Option<BulkInsertPartitioner>)Option.empty());
                allWriteStatuses.addAll((Collection)insertResult.getWriteStatuses());
            }
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw e;
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + this.instantTime, e);
        }
        this.updateIndex(allWriteStatuses, (HoodieWriteMetadata<List<WriteStatus>>)result);
        return result;
    }
}

