/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaWriteHelper;

public class JavaInsertOverwriteCommitActionExecutor<T>
extends BaseJavaCommitActionExecutor<T> {
    private final List<HoodieRecord<T>> inputRecords;

    public JavaInsertOverwriteCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords) {
        this(context, config, table, instantTime, inputRecords, WriteOperationType.INSERT_OVERWRITE);
    }

    public JavaInsertOverwriteCommitActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> inputRecords, WriteOperationType writeOperationType) {
        super(context, config, table, instantTime, writeOperationType);
        this.inputRecords = inputRecords;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        return JavaWriteHelper.newInstance().write(this.instantTime, this.inputRecords, this.context, this.table, this.config.shouldCombineBeforeInsert(), this.config.getInsertShuffleParallelism(), this, this.operationType);
    }

    @Override
    protected String getCommitActionType() {
        return "replacecommit";
    }

    @Override
    protected Map<String, List<String>> getPartitionToReplacedFileIds(HoodieWriteMetadata<List<WriteStatus>> writeResult) {
        return this.context.mapToPair(((List)writeResult.getWriteStatuses()).stream().map(status -> status.getStat().getPartitionPath()).distinct().collect(Collectors.toList()), (SerializablePairFunction & Serializable)partitionPath -> Pair.of((Object)partitionPath, this.getAllExistingFileIds((String)partitionPath)), Integer.valueOf(1));
    }

    private List<String> getAllExistingFileIds(String partitionPath) {
        return this.table.getSliceView().getLatestFileSlices(partitionPath).map(fg -> fg.getFileId()).distinct().collect(Collectors.toList());
    }
}

