/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import com.codahale.metrics.Timer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieJavaTableServiceClient;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.JavaHoodieIndexFactory;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.JavaHoodieBackedTableMetadataWriter;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.upgrade.JavaUpgradeDowngradeHelper;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;

public class HoodieJavaWriteClient<T>
extends BaseHoodieWriteClient<T, List<HoodieRecord<T>>, List<HoodieKey>, List<WriteStatus>> {
    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig) {
        super(context, writeConfig, (SupportsUpgradeDowngrade)JavaUpgradeDowngradeHelper.getInstance());
        this.tableServiceClient = new HoodieJavaTableServiceClient(context, writeConfig, (Option<EmbeddedTimelineService>)this.getTimelineServer());
    }

    public HoodieJavaWriteClient(HoodieEngineContext context, HoodieWriteConfig writeConfig, boolean rollbackPending, Option<EmbeddedTimelineService> timelineService) {
        super(context, writeConfig, timelineService, (SupportsUpgradeDowngrade)JavaUpgradeDowngradeHelper.getInstance());
        this.tableServiceClient = new HoodieJavaTableServiceClient(context, writeConfig, (Option<EmbeddedTimelineService>)this.getTimelineServer());
    }

    public List<HoodieRecord<T>> filterExists(List<HoodieRecord<T>> hoodieRecords) {
        HoodieJavaTable table = HoodieJavaTable.create(this.config, (HoodieJavaEngineContext)this.context);
        Timer.Context indexTimer = this.metrics.getIndexCtx();
        List recordsWithLocation = this.getIndex().tagLocation((HoodieData)HoodieListData.eager(hoodieRecords), this.context, table).collectAsList();
        this.metrics.updateIndexMetrics("lookup", this.metrics.getDurationInMs(indexTimer == null ? 0L : indexTimer.stop()));
        return recordsWithLocation.stream().filter(v1 -> !v1.isCurrentLocationKnown()).collect(Collectors.toList());
    }

    protected HoodieIndex createIndex(HoodieWriteConfig writeConfig) {
        return JavaHoodieIndexFactory.createIndex(this.config);
    }

    public boolean commit(String instantTime, List<WriteStatus> writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc) {
        List writeStats = writeStatuses.stream().map(WriteStatus::getStat).collect(Collectors.toList());
        return this.commitStats(instantTime, writeStats, extraMetadata, commitActionType, partitionToReplacedFileIds, extraPreCommitFunc);
    }

    protected HoodieTable createTable(HoodieWriteConfig config) {
        return this.createTableAndValidate(config, HoodieJavaTable::create);
    }

    protected HoodieTable createTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
        return this.createTableAndValidate(config, metaClient, HoodieJavaTable::create);
    }

    public List<WriteStatus> upsert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT, Option.ofNullable((Object)instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.upsert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", ((Duration)result.getIndexLookupDuration().get()).toMillis());
        }
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> upsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.UPSERT_PREPPED, Option.ofNullable((Object)instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.UPSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.upsertPrepped(this.context, instantTime, preppedRecords);
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> insert(List<HoodieRecord<T>> records, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT, Option.ofNullable((Object)instantTime));
        table.validateUpsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.insert(this.context, instantTime, records);
        if (result.getIndexLookupDuration().isPresent()) {
            this.metrics.updateIndexMetrics("lookup", ((Duration)result.getIndexLookupDuration().get()).toMillis());
        }
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> insertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.INSERT_PREPPED, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.insertPrepped(this.context, instantTime, preppedRecords);
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime) {
        return this.bulkInsert(records, instantTime, (Option<BulkInsertPartitioner>)Option.empty());
    }

    public List<WriteStatus> bulkInsert(List<HoodieRecord<T>> records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsert(this.context, instantTime, records, userDefinedBulkInsertPartitioner);
        return (List)this.postWrite(result, instantTime, table);
    }

    public void transitionInflight(String instantTime) {
        HoodieTableMetaClient metaClient = this.createMetaClient(true);
        metaClient.getActiveTimeline().transitionRequestedToInflight(metaClient.createNewInstant(HoodieInstant.State.REQUESTED, metaClient.getCommitActionType(), instantTime), Option.empty(), this.config.shouldAllowMultiWriteOnSameInstant());
    }

    public List<WriteStatus> bulkInsertPreppedRecords(List<HoodieRecord<T>> preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
        HoodieTable table = this.initTable(WriteOperationType.BULK_INSERT_PREPPED, Option.ofNullable((Object)instantTime));
        table.validateInsertSchema();
        this.preWrite(instantTime, WriteOperationType.BULK_INSERT_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.bulkInsertPrepped(this.context, instantTime, preppedRecords, bulkInsertPartitioner);
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> delete(List<HoodieKey> keys, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE, Option.ofNullable((Object)instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE, table.getMetaClient());
        HoodieWriteMetadata result = table.delete(this.context, instantTime, keys);
        return (List)this.postWrite(result, instantTime, table);
    }

    public List<WriteStatus> deletePrepped(List<HoodieRecord<T>> preppedRecords, String instantTime) {
        HoodieTable table = this.initTable(WriteOperationType.DELETE_PREPPED, Option.ofNullable((Object)instantTime));
        this.preWrite(instantTime, WriteOperationType.DELETE_PREPPED, table.getMetaClient());
        HoodieWriteMetadata result = table.deletePrepped(this.context, instantTime, preppedRecords);
        return (List)this.postWrite(result, instantTime, table);
    }

    protected void initMetadataTable(Option<String> instantTime, HoodieTableMetaClient metaClient) {
        this.initializeMetadataTable(instantTime);
    }

    private void initializeMetadataTable(Option<String> inFlightInstantTimestamp) {
        if (!this.config.isMetadataTableEnabled()) {
            return;
        }
        try (HoodieTableMetadataWriter writer = JavaHoodieBackedTableMetadataWriter.create(this.context.getStorageConf(), this.config, this.context, inFlightInstantTimestamp);){
            if (writer.isInitialized()) {
                writer.performTableServices(inFlightInstantTimestamp);
            }
        }
        catch (Exception e) {
            throw new HoodieException("Failed to instantiate Metadata table ", (Throwable)e);
        }
    }
}

