/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.common.HoodieJavaEngineContext;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseJavaCommitActionExecutor;
import org.apache.hudi.table.action.commit.JavaBulkInsertHelper;

public class JavaBulkInsertPreppedCommitActionExecutor<T>
extends BaseJavaCommitActionExecutor<T> {
    private final List<HoodieRecord<T>> preppedInputRecord;
    private final Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner;

    public JavaBulkInsertPreppedCommitActionExecutor(HoodieJavaEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, List<HoodieRecord<T>> preppedInputRecord, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
        super(context, config, table, instantTime, WriteOperationType.BULK_INSERT);
        this.preppedInputRecord = preppedInputRecord;
        this.userDefinedBulkInsertPartitioner = userDefinedBulkInsertPartitioner;
    }

    public HoodieWriteMetadata<List<WriteStatus>> execute() {
        try {
            return JavaBulkInsertHelper.newInstance().bulkInsert(this.preppedInputRecord, this.instantTime, this.table, this.config, this, false, this.userDefinedBulkInsertPartitioner);
        }
        catch (Throwable e) {
            if (e instanceof HoodieInsertException) {
                throw e;
            }
            throw new HoodieInsertException("Failed to bulk insert for commit time " + this.instantTime, e);
        }
    }
}

