/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.HoodieJavaWriteClient;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieNotSupportedException;
import org.apache.hudi.metadata.HoodieBackedTableMetadataWriter;
import org.apache.hudi.metadata.HoodieMetadataMetrics;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.JavaHoodieMetadataBulkInsertPartitioner;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieJavaTable;
import org.apache.hudi.table.HoodieTable;

public class JavaHoodieBackedTableMetadataWriter
extends HoodieBackedTableMetadataWriter<List<HoodieRecord>> {
    protected JavaHoodieBackedTableMetadataWriter(StorageConfiguration<?> storageConf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext engineContext, Option<String> inflightInstantTimestamp) {
        super(storageConf, writeConfig, failedWritesCleaningPolicy, engineContext, inflightInstantTimestamp);
    }

    HoodieTable getTable(HoodieWriteConfig writeConfig, HoodieTableMetaClient metaClient) {
        return HoodieJavaTable.create(writeConfig, this.engineContext, metaClient);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new JavaHoodieBackedTableMetadataWriter(conf, writeConfig, HoodieFailedWritesCleaningPolicy.EAGER, context, inflightInstantTimestamp);
    }

    public static HoodieTableMetadataWriter create(StorageConfiguration<?> conf, HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieEngineContext context, Option<String> inflightInstantTimestamp) {
        return new JavaHoodieBackedTableMetadataWriter(conf, writeConfig, failedWritesCleaningPolicy, context, inflightInstantTimestamp);
    }

    protected void initRegistry() {
        this.metrics = this.metadataWriteConfig.isMetricsOn() ? Option.of((Object)new HoodieMetadataMetrics(this.metadataWriteConfig.getMetricsConfig(), this.dataMetaClient.getStorage())) : Option.empty();
    }

    protected void updateColumnsToIndexWithColStats(List<String> columnsToIndex) {
    }

    protected void commit(String instantTime, Map<String, HoodieData<HoodieRecord>> partitionRecordsMap) {
        this.commitInternal(instantTime, partitionRecordsMap, false, Option.empty());
    }

    protected List<HoodieRecord> convertHoodieDataToEngineSpecificData(HoodieData<HoodieRecord> records) {
        return records.collectAsList();
    }

    protected void bulkCommit(String instantTime, String partitionName, HoodieData<HoodieRecord> records, int fileGroupCount) {
        this.commitInternal(instantTime, Collections.singletonMap(partitionName, records), true, Option.of(new JavaHoodieMetadataBulkInsertPartitioner()));
    }

    protected BaseHoodieWriteClient<?, List<HoodieRecord>, ?, ?> initializeWriteClient() {
        return new HoodieJavaWriteClient(this.engineContext, this.metadataWriteConfig);
    }

    public void deletePartitions(String instantTime, List<MetadataPartitionType> partitions) {
        throw new HoodieNotSupportedException("Dropping metadata index not supported for Java metadata table yet.");
    }

    protected void preWrite(String instantTime) {
        this.metadataMetaClient.getActiveTimeline().transitionRequestedToInflight("deltacommit", instantTime);
    }

    protected HoodieData<HoodieRecord> getExpressionIndexRecords(List<Pair<String, Pair<String, Long>>> partitionFilePathAndSizeTriplet, HoodieIndexDefinition indexDefinition, HoodieTableMetaClient metaClient, int parallelism, Schema readerSchema, StorageConfiguration<?> storageConf, String instantTime) {
        throw new HoodieNotSupportedException("Expression index not supported for Java metadata table writer yet.");
    }

    protected EngineType getEngineType() {
        return EngineType.JAVA;
    }
}

