/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.AvroLogicalTypeEnum;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.processors.DateLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DecimalLogicalTypeProcessor;
import org.apache.hudi.avro.processors.DurationLogicalTypeProcessor;
import org.apache.hudi.avro.processors.EnumTypeProcessor;
import org.apache.hudi.avro.processors.FixedTypeProcessor;
import org.apache.hudi.avro.processors.JsonFieldProcessor;
import org.apache.hudi.avro.processors.LocalTimestampMicroLogicalTypeProcessor;
import org.apache.hudi.avro.processors.LocalTimestampMilliLogicalTypeProcessor;
import org.apache.hudi.avro.processors.Parser;
import org.apache.hudi.avro.processors.TimeMicroLogicalTypeProcessor;
import org.apache.hudi.avro.processors.TimeMilliLogicalTypeProcessor;
import org.apache.hudi.avro.processors.TimestampMicroLogicalTypeProcessor;
import org.apache.hudi.avro.processors.TimestampMilliLogicalTypeProcessor;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieJsonConversionException;
import org.apache.hudi.exception.HoodieJsonToAvroConversionException;

public class MercifulJsonConverter {
    private static final Map<String, Map<String, String>> SANITIZED_FIELD_MAPPINGS = new ConcurrentHashMap<String, Map<String, String>>();
    private final Map<Schema.Type, JsonFieldProcessor> fieldTypeProcessorMap;
    private final Map<String, JsonFieldProcessor> fieldLogicalTypeProcessorMap;
    protected final ObjectMapper mapper;
    protected final String invalidCharMask;
    protected final boolean shouldSanitize;

    public MercifulJsonConverter() {
        this(false, "__");
    }

    public MercifulJsonConverter(boolean shouldSanitize, String invalidCharMask) {
        this(new ObjectMapper(), shouldSanitize, invalidCharMask);
    }

    public MercifulJsonConverter(ObjectMapper mapper, boolean shouldSanitize, String invalidCharMask) {
        this.mapper = mapper;
        this.shouldSanitize = shouldSanitize;
        this.invalidCharMask = invalidCharMask;
        this.fieldTypeProcessorMap = this.getFieldTypeProcessors();
        this.fieldLogicalTypeProcessorMap = this.getLogicalFieldTypeProcessors();
    }

    public GenericRecord convert(String json, Schema schema) {
        try {
            Map jsonObjectMap = (Map)this.mapper.readValue(json, Map.class);
            return this.convertJsonToAvro(jsonObjectMap, schema);
        }
        catch (IOException | HoodieException e) {
            throw new HoodieJsonToAvroConversionException("failed to convert json to avro", e);
        }
    }

    public static void clearCache(String schemaFullName) {
        SANITIZED_FIELD_MAPPINGS.remove(schemaFullName);
    }

    private GenericRecord convertJsonToAvro(Map<String, Object> inputJson, Schema schema) {
        GenericData.Record avroRecord = new GenericData.Record(schema);
        for (Schema.Field f : schema.getFields()) {
            Object val = this.shouldSanitize ? MercifulJsonConverter.getFieldFromJson(f, inputJson, schema.getFullName(), this.invalidCharMask) : inputJson.get(f.name());
            if (val == null) continue;
            avroRecord.put(f.pos(), this.convertJsonField(val, f.name(), f.schema()));
        }
        return avroRecord;
    }

    protected static Object getFieldFromJson(Schema.Field fieldSchema, Map<String, Object> inputJson, String schemaFullName, String invalidCharMask) {
        Object match;
        Map schemaToJsonFieldNames = SANITIZED_FIELD_MAPPINGS.computeIfAbsent(schemaFullName, unused -> new ConcurrentHashMap());
        if (!schemaToJsonFieldNames.containsKey(fieldSchema.name())) {
            for (String inputFieldName : inputJson.keySet()) {
                if (schemaToJsonFieldNames.containsKey(inputFieldName)) continue;
                String sanitizedJsonFieldName = HoodieAvroUtils.sanitizeName(inputFieldName, invalidCharMask);
                schemaToJsonFieldNames.putIfAbsent(sanitizedJsonFieldName, inputFieldName);
            }
        }
        if ((match = inputJson.get(schemaToJsonFieldNames.getOrDefault(fieldSchema.name(), fieldSchema.name()))) != null) {
            return match;
        }
        for (String alias : fieldSchema.aliases()) {
            if (!inputJson.containsKey(alias)) continue;
            return inputJson.get(alias);
        }
        return null;
    }

    private Schema getNonNull(Schema schema) {
        List types = schema.getTypes();
        Schema.Type firstType = ((Schema)types.get(0)).getType();
        return firstType.equals((Object)Schema.Type.NULL) ? (Schema)types.get(1) : (Schema)types.get(0);
    }

    private boolean isOptional(Schema schema) {
        return schema.getType().equals((Object)Schema.Type.UNION) && schema.getTypes().size() == 2 && (((Schema)schema.getTypes().get(0)).getType().equals((Object)Schema.Type.NULL) || ((Schema)schema.getTypes().get(1)).getType().equals((Object)Schema.Type.NULL));
    }

    protected Object convertJsonField(Object value, String name, Schema schema) {
        if (this.isOptional(schema)) {
            if (value == null) {
                return null;
            }
            schema = this.getNonNull(schema);
        } else if (value == null) {
            throw this.buildConversionException(String.format("Symbol %s not in enum", value.toString()), schema.getFullName(), schema, this.shouldSanitize, this.invalidCharMask);
        }
        return this.convertField(value, name, schema);
    }

    private Object convertField(Object value, String name, Schema schema) {
        JsonFieldProcessor processor = this.getProcessorForSchema(schema);
        return processor.convertField(value, name, schema);
    }

    protected JsonFieldProcessor getProcessorForSchema(Schema schema) {
        JsonFieldProcessor processor = null;
        String customizedLogicalType = schema.getProp("logicalType");
        LogicalType logicalType = schema.getLogicalType();
        Schema.Type type = schema.getType();
        processor = customizedLogicalType != null && !customizedLogicalType.isEmpty() ? this.fieldLogicalTypeProcessorMap.get(customizedLogicalType) : (logicalType != null ? this.fieldLogicalTypeProcessorMap.get(logicalType.getName()) : this.fieldTypeProcessorMap.get(type));
        ValidationUtils.checkArgument(processor != null, String.format("JsonConverter cannot handle type: %s", type));
        return processor;
    }

    private Map<Schema.Type, JsonFieldProcessor> getFieldTypeProcessors() {
        EnumMap<Schema.Type, JsonFieldProcessor> fieldTypeProcessors = new EnumMap<Schema.Type, JsonFieldProcessor>(Schema.Type.class);
        fieldTypeProcessors.put(Schema.Type.STRING, MercifulJsonConverter.generateStringTypeHandler());
        fieldTypeProcessors.put(Schema.Type.BOOLEAN, this.generateBooleanTypeHandler());
        fieldTypeProcessors.put(Schema.Type.DOUBLE, this.generateDoubleTypeHandler());
        fieldTypeProcessors.put(Schema.Type.FLOAT, this.generateFloatTypeHandler());
        fieldTypeProcessors.put(Schema.Type.INT, this.generateIntTypeHandler());
        fieldTypeProcessors.put(Schema.Type.LONG, this.generateLongTypeHandler());
        fieldTypeProcessors.put(Schema.Type.ARRAY, this.generateArrayTypeHandler());
        fieldTypeProcessors.put(Schema.Type.RECORD, this.generateRecordTypeHandler());
        fieldTypeProcessors.put(Schema.Type.ENUM, this.generateEnumTypeHandler());
        fieldTypeProcessors.put(Schema.Type.MAP, this.generateMapTypeHandler());
        fieldTypeProcessors.put(Schema.Type.BYTES, this.generateBytesTypeHandler());
        fieldTypeProcessors.put(Schema.Type.FIXED, this.generateFixedTypeHandler());
        return Collections.unmodifiableMap(fieldTypeProcessors);
    }

    private Map<String, JsonFieldProcessor> getLogicalFieldTypeProcessors() {
        return CollectionUtils.createImmutableMap(Pair.of(AvroLogicalTypeEnum.DECIMAL.getValue(), this.generateDecimalLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.TIME_MICROS.getValue(), this.generateTimeMicroLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.TIME_MILLIS.getValue(), this.generateTimeMilliLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.DATE.getValue(), this.generateDateLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MICROS.getValue(), this.generateLocalTimeStampMicroLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.LOCAL_TIMESTAMP_MILLIS.getValue(), this.generateLocalTimeStampMilliLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.TIMESTAMP_MICROS.getValue(), this.generateTimestampMicroLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.TIMESTAMP_MILLIS.getValue(), this.generateTimestampMilliLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.DURATION.getValue(), this.generateDurationLogicalTypeHandler()), Pair.of(AvroLogicalTypeEnum.UUID.getValue(), MercifulJsonConverter.generateStringTypeHandler()));
    }

    protected JsonFieldProcessor generateDecimalLogicalTypeHandler() {
        return new DecimalToAvroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateTimeMicroLogicalTypeHandler() {
        return new TimeMicroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateTimeMilliLogicalTypeHandler() {
        return new TimeMilliLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateDateLogicalTypeHandler() {
        return new DateToAvroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateLocalTimeStampMicroLogicalTypeHandler() {
        return new LocalTimestampMicroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateLocalTimeStampMilliLogicalTypeHandler() {
        return new LocalTimestampMilliLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateTimestampMicroLogicalTypeHandler() {
        return new TimestampMicroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateTimestampMilliLogicalTypeHandler() {
        return new TimestampMilliLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateDurationLogicalTypeHandler() {
        return new DurationToAvroLogicalTypeProcessor();
    }

    protected JsonFieldProcessor generateBooleanTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Boolean) {
                    return Pair.of(true, value);
                }
                return Pair.of(false, null);
            }
        };
    }

    protected JsonFieldProcessor generateIntTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).intValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Integer.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    protected JsonFieldProcessor generateDoubleTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).doubleValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Double.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    protected JsonFieldProcessor generateFloatTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, Float.valueOf(((Number)value).floatValue()));
                }
                if (value instanceof String) {
                    return Pair.of(true, Float.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    protected JsonFieldProcessor generateLongTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                if (value instanceof Number) {
                    return Pair.of(true, ((Number)value).longValue());
                }
                if (value instanceof String) {
                    return Pair.of(true, Long.valueOf((String)value));
                }
                return Pair.of(false, null);
            }
        };
    }

    private static JsonFieldProcessor generateStringTypeHandler() {
        return new StringProcessor();
    }

    protected JsonFieldProcessor generateBytesTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of(true, ByteBuffer.wrap(value.toString().getBytes()));
            }
        };
    }

    protected JsonFieldProcessor generateFixedTypeHandler() {
        return new AvroFixedTypeProcessor();
    }

    protected JsonFieldProcessor generateEnumTypeHandler() {
        return new AvroEnumTypeProcessor();
    }

    protected JsonFieldProcessor generateRecordTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of(true, MercifulJsonConverter.this.convertJsonToAvro((Map)value, schema));
            }
        };
    }

    protected JsonFieldProcessor generateArrayTypeHandler() {
        return new JsonFieldProcessor(){

            private List<Object> convertToJavaObject(Object value, String name, Schema schema) {
                Schema elementSchema = schema.getElementType();
                ArrayList<Object> listRes = new ArrayList<Object>();
                for (Object v : (List)value) {
                    listRes.add(MercifulJsonConverter.this.convertJsonField(v, name, elementSchema));
                }
                return listRes;
            }

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                return Pair.of(true, new GenericData.Array(schema, this.convertToJavaObject(value, name, schema)));
            }
        };
    }

    protected JsonFieldProcessor generateMapTypeHandler() {
        return new JsonFieldProcessor(){

            @Override
            public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
                Schema valueSchema = schema.getValueType();
                HashMap mapRes = new HashMap();
                for (Map.Entry v : ((Map)value).entrySet()) {
                    mapRes.put(v.getKey(), MercifulJsonConverter.this.convertJsonField(v.getValue(), name, valueSchema));
                }
                return Pair.of(true, mapRes);
            }
        };
    }

    protected HoodieJsonConversionException buildConversionException(Object value, String fieldName, Schema schema, boolean shouldSanitize, String invalidCharMask) {
        String errorMsg = shouldSanitize ? String.format("Json to Avro Type conversion error for field %s, %s for %s. Field sanitization is enabled with a mask of %s.", fieldName, value, schema, invalidCharMask) : String.format("Json to Avro Type conversion error for field %s, %s for %s", fieldName, value, schema);
        return new HoodieJsonConversionException(errorMsg);
    }

    private static class AvroEnumTypeProcessor
    extends EnumTypeProcessor {
        private AvroEnumTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return Pair.of(true, new GenericData.EnumSymbol(schema, this.convertToJavaObject(value, name, schema)));
        }
    }

    private static class AvroFixedTypeProcessor
    extends FixedTypeProcessor {
        private AvroFixedTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return Pair.of(true, new GenericData.Fixed(schema, this.convertToJavaObject(value, name, schema)));
        }
    }

    private static class StringProcessor
    extends JsonFieldProcessor {
        private static final ObjectMapper STRING_MAPPER = new ObjectMapper();

        private StringProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            if (value instanceof String) {
                return Pair.of(true, value);
            }
            try {
                return Pair.of(true, STRING_MAPPER.writeValueAsString(value));
            }
            catch (IOException ex) {
                return Pair.of(false, null);
            }
        }
    }

    private static class DateToAvroLogicalTypeProcessor
    extends DateLogicalTypeProcessor {
        private DateToAvroLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            return this.convertCommon(new Parser.IntParser(){

                @Override
                public Pair<Boolean, Object> handleStringValue(String value) {
                    if (!this.isWellFormedDateTime(value)) {
                        return Pair.of(false, null);
                    }
                    Pair result = this.convertToLocalDate(value);
                    if (!((Boolean)result.getLeft()).booleanValue()) {
                        return Pair.of(false, null);
                    }
                    LocalDate date = (LocalDate)result.getRight();
                    int daysSinceEpoch = (int)ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), date);
                    return Pair.of(true, daysSinceEpoch);
                }
            }, value, schema);
        }
    }

    private static class DurationToAvroLogicalTypeProcessor
    extends DurationLogicalTypeProcessor {
        private DurationToAvroLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            if (!DurationToAvroLogicalTypeProcessor.isValidDurationTypeConfig(schema)) {
                return Pair.of(false, null);
            }
            if (!this.isValidDurationInput(value)) {
                return Pair.of(false, null);
            }
            List list = (List)value;
            List converval = list.stream().filter(Integer.class::isInstance).map(Integer.class::cast).collect(Collectors.toList());
            ByteBuffer buffer = ByteBuffer.allocate(schema.getFixedSize()).order(ByteOrder.LITTLE_ENDIAN);
            for (Integer element : converval) {
                buffer.putInt(element);
            }
            return Pair.of(true, new GenericData.Fixed(schema, buffer.array()));
        }
    }

    private class DecimalToAvroLogicalTypeProcessor
    extends DecimalLogicalTypeProcessor {
        private DecimalToAvroLogicalTypeProcessor() {
        }

        @Override
        public Pair<Boolean, Object> convert(Object value, String name, Schema schema) {
            if (!DecimalToAvroLogicalTypeProcessor.isValidDecimalTypeConfig(schema)) {
                return Pair.of(false, null);
            }
            if (value instanceof List && schema.getType() == Schema.Type.FIXED) {
                JsonFieldProcessor processor = MercifulJsonConverter.this.generateFixedTypeHandler();
                return processor.convert(value, name, schema);
            }
            LogicalTypes.Decimal decimalType = (LogicalTypes.Decimal)schema.getLogicalType();
            Pair<Boolean, BigDecimal> parseResult = DecimalToAvroLogicalTypeProcessor.parseObjectToBigDecimal(value, schema);
            if (Boolean.FALSE.equals(parseResult.getLeft())) {
                return Pair.of(false, null);
            }
            BigDecimal bigDecimal = parseResult.getRight();
            switch (schema.getType()) {
                case BYTES: {
                    ByteBuffer byteBuffer = new Conversions.DecimalConversion().toBytes(bigDecimal, schema, (LogicalType)decimalType);
                    return Pair.of(true, byteBuffer);
                }
                case FIXED: {
                    GenericFixed fixedValue = new Conversions.DecimalConversion().toFixed(bigDecimal, schema, (LogicalType)decimalType);
                    return Pair.of(true, fixedValue);
                }
            }
            return Pair.of(false, null);
        }
    }
}

