/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.config;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.apache.hudi.common.config.EnumDescription;
import org.apache.hudi.common.config.EnumFieldDescription;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;

public class ConfigProperty<T>
implements Serializable {
    private final String key;
    private final T defaultValue;
    private final String docOnDefaultValue;
    private final String doc;
    private final Option<String> sinceVersion;
    private final Option<String> deprecatedVersion;
    private final Set<String> validValues;
    private final boolean advanced;
    private final String[] alternatives;
    private final Option<Function<HoodieConfig, Option<T>>> inferFunction;

    ConfigProperty(String key, T defaultValue, String docOnDefaultValue, String doc, Option<String> sinceVersion, Option<String> deprecatedVersion, Option<Function<HoodieConfig, Option<T>>> inferFunc, Set<String> validValues, boolean advanced, String ... alternatives) {
        this.key = Objects.requireNonNull(key);
        this.defaultValue = defaultValue;
        this.docOnDefaultValue = docOnDefaultValue;
        this.doc = doc;
        this.sinceVersion = sinceVersion;
        this.deprecatedVersion = deprecatedVersion;
        this.inferFunction = inferFunc;
        this.validValues = validValues;
        this.advanced = advanced;
        this.alternatives = alternatives;
    }

    public String key() {
        return this.key;
    }

    public T defaultValue() {
        if (this.defaultValue == null) {
            throw new HoodieException(String.format("There's no default value for this config: %s", this.key));
        }
        return this.defaultValue;
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public String getDocOnDefaultValue() {
        return StringUtils.isNullOrEmpty(this.docOnDefaultValue) ? "" : this.docOnDefaultValue;
    }

    public String doc() {
        return StringUtils.isNullOrEmpty(this.doc) ? "" : this.doc;
    }

    public Option<String> getSinceVersion() {
        return this.sinceVersion;
    }

    public Option<String> getDeprecatedVersion() {
        return this.deprecatedVersion;
    }

    public boolean hasInferFunction() {
        return this.getInferFunction().isPresent();
    }

    Option<Function<HoodieConfig, Option<T>>> getInferFunction() {
        return this.inferFunction;
    }

    public void checkValues(String value) {
        if (!this.isValid(value)) {
            throw new IllegalArgumentException("The value of " + this.key + " should be one of " + String.join((CharSequence)",", this.validValues) + ", but was " + value);
        }
    }

    private boolean isValid(String value) {
        return this.validValues == null || this.validValues.isEmpty() || this.validValues.contains(value.toUpperCase());
    }

    public List<String> getAlternatives() {
        return Arrays.asList(this.alternatives);
    }

    public boolean isAdvanced() {
        return this.advanced;
    }

    public ConfigProperty<T> withDocumentation(String doc) {
        Objects.requireNonNull(doc);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, this.validValues, this.advanced, this.alternatives);
    }

    public <U extends Enum<U>> ConfigProperty<T> withDocumentation(Class<U> e) {
        return this.withDocumentation(e, "");
    }

    private <U extends Enum<U>> boolean isDefaultField(Class<U> e, Field f) {
        if (!this.hasDefaultValue()) {
            return false;
        }
        if (this.defaultValue() instanceof String) {
            return f.getName().equals(((String)this.defaultValue()).toUpperCase());
        }
        return ((Enum)Enum.valueOf(e, f.getName())).equals(this.defaultValue());
    }

    public <U extends Enum<U>> ConfigProperty<T> withDocumentation(Class<U> e, String doc) {
        Objects.requireNonNull(e);
        StringBuilder sb = new StringBuilder();
        if (StringUtils.nonEmpty(doc)) {
            sb.append(doc);
            sb.append('\n');
        }
        sb.append(e.getName());
        sb.append(": ");
        EnumDescription description = e.getAnnotation(EnumDescription.class);
        Objects.requireNonNull(description);
        sb.append(description.value());
        for (Field f : e.getFields()) {
            if (!f.isEnumConstant() || !this.isValid(f.getName())) continue;
            EnumFieldDescription fieldDescription = f.getAnnotation(EnumFieldDescription.class);
            Objects.requireNonNull(fieldDescription);
            sb.append("\n    ");
            sb.append(f.getName());
            if (this.isDefaultField(e, f)) {
                sb.append("(default)");
            }
            sb.append(": ");
            sb.append(fieldDescription.value());
        }
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, sb.toString(), this.sinceVersion, this.deprecatedVersion, this.inferFunction, this.validValues, this.advanced, this.alternatives);
    }

    public ConfigProperty<T> withValidValues(String ... validValues) {
        Objects.requireNonNull(validValues);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, new HashSet<String>(Arrays.asList(validValues)), this.advanced, this.alternatives);
    }

    public ConfigProperty<T> withAlternatives(String ... alternatives) {
        Objects.requireNonNull(alternatives);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, this.validValues, this.advanced, alternatives);
    }

    public ConfigProperty<T> sinceVersion(String sinceVersion) {
        Objects.requireNonNull(sinceVersion);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, Option.of(sinceVersion), this.deprecatedVersion, this.inferFunction, this.validValues, this.advanced, this.alternatives);
    }

    public ConfigProperty<T> deprecatedAfter(String deprecatedVersion) {
        Objects.requireNonNull(deprecatedVersion);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, this.sinceVersion, Option.of(deprecatedVersion), this.inferFunction, this.validValues, this.advanced, this.alternatives);
    }

    public ConfigProperty<T> withInferFunction(Function<HoodieConfig, Option<T>> inferFunction) {
        Objects.requireNonNull(inferFunction);
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, Option.of(inferFunction), this.validValues, this.advanced, this.alternatives);
    }

    public ConfigProperty<T> markAdvanced() {
        return new ConfigProperty<T>(this.key, this.defaultValue, this.docOnDefaultValue, this.doc, this.sinceVersion, this.deprecatedVersion, this.inferFunction, this.validValues, true, this.alternatives);
    }

    public static PropertyBuilder key(String key) {
        Objects.requireNonNull(key);
        return new PropertyBuilder(key);
    }

    public String toString() {
        return String.format("Key: '%s' , default: %s , isAdvanced: %s , description: %s since version: %s deprecated after: %s", this.key, this.defaultValue, this.advanced, this.doc, this.sinceVersion.isPresent() ? this.sinceVersion.get() : "version is not defined", this.deprecatedVersion.isPresent() ? this.deprecatedVersion.get() : "version is not defined");
    }

    public static final class PropertyBuilder {
        private final String key;

        PropertyBuilder(String key) {
            this.key = key;
        }

        public <T> ConfigProperty<T> defaultValue(T value) {
            return this.defaultValue(value, "");
        }

        public <T> ConfigProperty<T> defaultValue(T value, String docOnDefaultValue) {
            Objects.requireNonNull(value);
            Objects.requireNonNull(docOnDefaultValue);
            ConfigProperty<T> configProperty = new ConfigProperty<T>(this.key, value, docOnDefaultValue, "", Option.empty(), Option.empty(), Option.empty(), Collections.emptySet(), false, new String[0]);
            return configProperty;
        }

        public ConfigProperty<String> noDefaultValue() {
            return this.noDefaultValue("");
        }

        public ConfigProperty<String> noDefaultValue(String docOnDefaultValue) {
            ConfigProperty<Object> configProperty = new ConfigProperty<Object>(this.key, null, docOnDefaultValue, "", Option.empty(), Option.empty(), Option.empty(), Collections.emptySet(), false, new String[0]);
            return configProperty;
        }
    }
}

