/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.view;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.function.SerializableSupplier;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileGroup;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Functions;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.org.apache.http.client.HttpResponseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PriorityBasedFileSystemView
implements SyncableFileSystemView,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(PriorityBasedFileSystemView.class);
    private final SyncableFileSystemView preferredView;
    private final SerializableSupplier<SyncableFileSystemView> secondaryViewSupplier;
    private SyncableFileSystemView secondaryView;
    private boolean errorOnPreferredView;

    public PriorityBasedFileSystemView(SyncableFileSystemView preferredView, SerializableSupplier<SyncableFileSystemView> secondaryViewSupplier) {
        this.preferredView = preferredView;
        this.secondaryViewSupplier = secondaryViewSupplier;
        this.secondaryView = null;
        this.errorOnPreferredView = false;
    }

    private <R> R execute(Functions.Function0<R> preferredFunction, Functions.Function0<R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply();
        }
        try {
            return preferredFunction.apply();
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply();
        }
    }

    private <T1, R> R execute(T1 val, Functions.Function1<T1, R> preferredFunction, Functions.Function1<T1, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val);
        }
        try {
            return preferredFunction.apply(val);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val);
        }
    }

    private <T1, T2, R> R execute(T1 val, T2 val2, Functions.Function2<T1, T2, R> preferredFunction, Functions.Function2<T1, T2, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2);
        }
        try {
            return preferredFunction.apply(val, val2);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2);
        }
    }

    private <T1, T2, T3, R> R execute(T1 val, T2 val2, T3 val3, Functions.Function3<T1, T2, T3, R> preferredFunction, Functions.Function3<T1, T2, T3, R> secondaryFunction) {
        if (this.errorOnPreferredView) {
            LOG.warn("Routing request to secondary file-system view");
            return secondaryFunction.apply(val, val2, val3);
        }
        try {
            return preferredFunction.apply(val, val2, val3);
        }
        catch (RuntimeException re) {
            this.handleRuntimeException(re);
            this.errorOnPreferredView = true;
            return secondaryFunction.apply(val, val2, val3);
        }
    }

    private void handleRuntimeException(RuntimeException re) {
        if (re.getCause() instanceof HttpResponseException && ((HttpResponseException)re.getCause()).getStatusCode() == 400) {
            LOG.warn("Got error running preferred function. Likely due to another concurrent writer in progress. Trying secondary");
        } else {
            LOG.error("Got error running preferred function. Trying secondary", re);
        }
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestBaseFiles, path -> this.getSecondaryView().getLatestBaseFiles((String)path));
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFiles() {
        return this.execute(this.preferredView::getLatestBaseFiles, () -> this.getSecondaryView().getLatestBaseFiles());
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesBeforeOrOn(String partitionPath, String maxCommitTime) {
        return this.execute(partitionPath, maxCommitTime, this.preferredView::getLatestBaseFilesBeforeOrOn, (path, commitTime) -> this.getSecondaryView().getLatestBaseFilesBeforeOrOn((String)path, (String)commitTime));
    }

    @Override
    public Map<String, Stream<HoodieBaseFile>> getAllLatestBaseFilesBeforeOrOn(String maxCommitTime) {
        return this.execute(maxCommitTime, this.preferredView::getAllLatestBaseFilesBeforeOrOn, commitTime -> this.getSecondaryView().getAllLatestBaseFilesBeforeOrOn((String)commitTime));
    }

    @Override
    public Option<HoodieBaseFile> getLatestBaseFile(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestBaseFile, (path, id) -> this.getSecondaryView().getLatestBaseFile((String)path, (String)id));
    }

    @Override
    public Option<HoodieBaseFile> getBaseFileOn(String partitionPath, String instantTime, String fileId) {
        return this.execute(partitionPath, instantTime, fileId, this.preferredView::getBaseFileOn, (path, instant, id) -> this.getSecondaryView().getBaseFileOn((String)path, (String)instant, (String)id));
    }

    @Override
    public Stream<HoodieBaseFile> getLatestBaseFilesInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestBaseFilesInRange, commits -> this.getSecondaryView().getLatestBaseFilesInRange((List<String>)commits));
    }

    @Override
    public void loadAllPartitions() {
        this.execute(() -> {
            this.preferredView.loadAllPartitions();
            return null;
        }, () -> {
            this.getSecondaryView().loadAllPartitions();
            return null;
        });
    }

    @Override
    public void loadPartitions(List<String> partitionPaths) {
        this.execute(() -> {
            this.preferredView.loadPartitions(partitionPaths);
            return null;
        }, () -> {
            this.getSecondaryView().loadPartitions(partitionPaths);
            return null;
        });
    }

    @Override
    public Stream<HoodieBaseFile> getAllBaseFiles(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllBaseFiles, path -> this.getSecondaryView().getAllBaseFiles((String)path));
    }

    @Override
    public Stream<FileSlice> getLatestFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlices, path -> this.getSecondaryView().getLatestFileSlices((String)path));
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesIncludingInflight(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlicesIncludingInflight, path -> this.getSecondaryView().getLatestFileSlicesIncludingInflight((String)path));
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesStateless(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestFileSlicesStateless, path -> this.getSecondaryView().getLatestFileSlicesStateless((String)path));
    }

    @Override
    public Stream<FileSlice> getLatestUnCompactedFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getLatestUnCompactedFileSlices, path -> this.getSecondaryView().getLatestUnCompactedFileSlices((String)path));
    }

    @Override
    public Stream<FileSlice> getLatestFileSlicesBeforeOrOn(String partitionPath, String maxCommitTime, boolean includeFileSlicesInPendingCompaction) {
        return this.execute(partitionPath, maxCommitTime, includeFileSlicesInPendingCompaction, this.preferredView::getLatestFileSlicesBeforeOrOn, (path, commitTime, includeSlices) -> this.getSecondaryView().getLatestFileSlicesBeforeOrOn((String)path, (String)commitTime, (boolean)includeSlices));
    }

    @Override
    public Map<String, Stream<FileSlice>> getAllLatestFileSlicesBeforeOrOn(String maxCommitTime) {
        return this.execute(maxCommitTime, this.preferredView::getAllLatestFileSlicesBeforeOrOn, instantTime -> this.getSecondaryView().getAllLatestFileSlicesBeforeOrOn((String)instantTime));
    }

    @Override
    public Stream<FileSlice> getLatestMergedFileSlicesBeforeOrOn(String partitionPath, String maxInstantTime) {
        return this.execute(partitionPath, maxInstantTime, this.preferredView::getLatestMergedFileSlicesBeforeOrOn, (path, instantTime) -> this.getSecondaryView().getLatestMergedFileSlicesBeforeOrOn((String)path, (String)instantTime));
    }

    @Override
    public Stream<FileSlice> getLatestFileSliceInRange(List<String> commitsToReturn) {
        return this.execute(commitsToReturn, this.preferredView::getLatestFileSliceInRange, commits -> this.getSecondaryView().getLatestFileSliceInRange((List<String>)commits));
    }

    @Override
    public Stream<FileSlice> getAllFileSlices(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileSlices, path -> this.getSecondaryView().getAllFileSlices((String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroups(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileGroups, path -> this.getSecondaryView().getAllFileGroups((String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getAllFileGroupsStateless(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllFileGroupsStateless, path -> this.getSecondaryView().getAllFileGroupsStateless((String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBeforeOrOn(String maxCommitTime, String partitionPath) {
        return this.execute(maxCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsBeforeOrOn, (commitTime, path) -> this.getSecondaryView().getReplacedFileGroupsBeforeOrOn((String)commitTime, (String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsBefore(String maxCommitTime, String partitionPath) {
        return this.execute(maxCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsBefore, (commitTime, path) -> this.getSecondaryView().getReplacedFileGroupsBefore((String)commitTime, (String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getReplacedFileGroupsAfterOrOn(String minCommitTime, String partitionPath) {
        return this.execute(minCommitTime, partitionPath, this.preferredView::getReplacedFileGroupsAfterOrOn, (commitTime, path) -> this.getSecondaryView().getReplacedFileGroupsAfterOrOn((String)commitTime, (String)path));
    }

    @Override
    public Stream<HoodieFileGroup> getAllReplacedFileGroups(String partitionPath) {
        return this.execute(partitionPath, this.preferredView::getAllReplacedFileGroups, path -> this.getSecondaryView().getAllReplacedFileGroups((String)path));
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingCompactionOperations() {
        return this.execute(this.preferredView::getPendingCompactionOperations, () -> this.getSecondaryView().getPendingCompactionOperations());
    }

    @Override
    public Stream<Pair<String, CompactionOperation>> getPendingLogCompactionOperations() {
        return this.execute(this.preferredView::getPendingLogCompactionOperations, () -> this.getSecondaryView().getPendingLogCompactionOperations());
    }

    @Override
    public Stream<Pair<HoodieFileGroupId, HoodieInstant>> getFileGroupsInPendingClustering() {
        return this.execute(this.preferredView::getFileGroupsInPendingClustering, () -> this.getSecondaryView().getFileGroupsInPendingClustering());
    }

    @Override
    public void close() {
        this.preferredView.close();
        if (this.secondaryView != null) {
            this.secondaryView.close();
        }
    }

    @Override
    public void reset() {
        this.preferredView.reset();
        if (this.secondaryView != null) {
            this.secondaryView.reset();
        }
        this.errorOnPreferredView = false;
    }

    @Override
    public Option<HoodieInstant> getLastInstant() {
        return this.execute(this.preferredView::getLastInstant, () -> this.getSecondaryView().getLastInstant());
    }

    @Override
    public HoodieTimeline getTimeline() {
        return this.execute(this.preferredView::getTimeline, () -> this.getSecondaryView().getTimeline());
    }

    @Override
    public void sync() {
        this.preferredView.sync();
        if (this.secondaryView != null) {
            this.secondaryView.sync();
        }
        this.errorOnPreferredView = false;
    }

    @Override
    public Option<FileSlice> getLatestFileSlice(String partitionPath, String fileId) {
        return this.execute(partitionPath, fileId, this.preferredView::getLatestFileSlice, (path, fgId) -> this.getSecondaryView().getLatestFileSlice((String)path, (String)fgId));
    }

    SyncableFileSystemView getPreferredView() {
        return this.preferredView;
    }

    synchronized SyncableFileSystemView getSecondaryView() {
        if (this.secondaryView == null) {
            this.secondaryView = this.secondaryViewSupplier.get();
        }
        return this.secondaryView;
    }
}

