/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metaserver.service.HoodieMetaserverGateway;
import org.apache.hudi.metaserver.service.HoodieMetaserverProxyHandler;
import org.apache.hudi.metaserver.service.TableService;
import org.apache.hudi.metaserver.service.TimelineService;
import org.apache.hudi.metaserver.store.MetaserverStorage;
import org.apache.hudi.metaserver.store.RelationalDBBasedStorage;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.ThriftHoodieMetaserver;
import org.apache.hudi.metaserver.util.TServerSocketWrapper;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TThreadPoolServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetaserver {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetaserver.class);
    private static TServer server;
    private static Thread serverThread;
    private static volatile MetaserverStorage metaserverStorage;
    private static HoodieMetaserverGateway metaserverGateway;

    public static void main(String[] args) {
        HoodieMetaserver.startServer();
    }

    public static void startServer() {
        try {
            if (server != null) {
                return;
            }
            metaserverStorage = new RelationalDBBasedStorage();
            try {
                metaserverStorage.initStorage();
            }
            catch (MetaserverStorageException e) {
                throw new HoodieException("Fail to init the Metaserver's storage." + e);
            }
            TableService tableService = new TableService(metaserverStorage);
            TimelineService timelineService = new TimelineService(metaserverStorage);
            HoodieMetaserverGateway hoodieMetaserverGateway = new HoodieMetaserverGateway(tableService, timelineService);
            HoodieMetaserverProxyHandler proxyHandler = new HoodieMetaserverProxyHandler(hoodieMetaserverGateway);
            ThriftHoodieMetaserver.Iface proxy = (ThriftHoodieMetaserver.Iface)Proxy.newProxyInstance(HoodieMetaserverProxyHandler.class.getClassLoader(), new Class[]{ThriftHoodieMetaserver.Iface.class}, (InvocationHandler)proxyHandler);
            ThriftHoodieMetaserver.Processor<ThriftHoodieMetaserver.Iface> processor = new ThriftHoodieMetaserver.Processor<ThriftHoodieMetaserver.Iface>(proxy);
            TServerSocketWrapper serverTransport = new TServerSocketWrapper(9090);
            server = new TThreadPoolServer((TThreadPoolServer.Args)new TThreadPoolServer.Args(serverTransport).processor(processor));
            LOG.info("Starting the server");
            serverThread = new Thread(() -> server.serve());
            serverThread.start();
        }
        catch (Exception e) {
            LOG.error("Failed to start Metaserver.", e);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThriftHoodieMetaserver.Iface getEmbeddedMetaserver() {
        if (metaserverStorage != null) return metaserverGateway;
        Class<HoodieMetaserver> clazz = HoodieMetaserver.class;
        synchronized (HoodieMetaserver.class) {
            if (metaserverStorage != null) return metaserverGateway;
            metaserverStorage = new RelationalDBBasedStorage();
            try {
                metaserverStorage.initStorage();
            }
            catch (MetaserverStorageException e) {
                throw new HoodieException("Fail to init the Metaserver's storage." + e);
            }
            TableService tableService = new TableService(metaserverStorage);
            TimelineService timelineService = new TimelineService(metaserverStorage);
            metaserverGateway = new HoodieMetaserverGateway(tableService, timelineService);
            // ** MonitorExit[var0] (shouldn't be in output)
            return metaserverGateway;
        }
    }

    public static MetaserverStorage getMetaserverStorage() {
        return metaserverStorage;
    }

    public static void stopServer() {
        if (server != null) {
            LOG.info("Stop the server...");
            server.stop();
            serverThread.interrupt();
            server = null;
        }
        if (metaserverStorage != null) {
            metaserverStorage.close();
        }
    }
}

