/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.service;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.hudi.metaserver.service.TableService;
import org.apache.hudi.metaserver.service.TimelineService;
import org.apache.hudi.metaserver.thrift.AlreadyExistException;
import org.apache.hudi.metaserver.thrift.HoodieInstantChangeResult;
import org.apache.hudi.metaserver.thrift.MetaserverException;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.NoSuchObjectException;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.Table;
import org.apache.hudi.metaserver.thrift.ThriftHoodieMetaserver;

public class HoodieMetaserverGateway
implements ThriftHoodieMetaserver.Iface,
Serializable {
    private final TableService tableService;
    private final TimelineService timelineService;

    public HoodieMetaserverGateway(TableService tableService, TimelineService timelineService) {
        this.tableService = tableService;
        this.timelineService = timelineService;
    }

    @Override
    public void createDatabase(String db) throws AlreadyExistException, MetaserverStorageException, MetaserverException {
        this.tableService.createDatabase(db);
    }

    @Override
    public void createTable(Table table) throws MetaserverStorageException, NoSuchObjectException, AlreadyExistException, MetaserverException {
        this.tableService.createTable(table);
    }

    @Override
    public Table getTable(String db, String tb) throws NoSuchObjectException, MetaserverStorageException {
        return this.tableService.getTable(db, tb);
    }

    @Override
    public List<THoodieInstant> listInstants(String db, String tb, int num) throws MetaserverStorageException, NoSuchObjectException {
        return this.timelineService.listInstants(db, tb, num);
    }

    @Override
    public ByteBuffer getInstantMetadata(String db, String tb, THoodieInstant instant) throws MetaserverStorageException, NoSuchObjectException {
        return this.timelineService.getInstantMetadata(db, tb, instant);
    }

    @Override
    public String createNewInstantTime(String db, String tb) throws MetaserverStorageException, NoSuchObjectException {
        return this.timelineService.createNewInstantTime(db, tb);
    }

    @Override
    public HoodieInstantChangeResult createNewInstantWithTime(String db, String tb, THoodieInstant instant, ByteBuffer content) throws MetaserverStorageException, NoSuchObjectException {
        return this.timelineService.createNewInstantWithTime(db, tb, instant, content);
    }

    @Override
    public HoodieInstantChangeResult transitionInstantState(String db, String tb, THoodieInstant fromInstant, THoodieInstant toInstant, ByteBuffer metadata) throws MetaserverStorageException, NoSuchObjectException, MetaserverException {
        return this.timelineService.transitionInstantState(db, tb, fromInstant, toInstant, metadata);
    }

    @Override
    public HoodieInstantChangeResult deleteInstant(String db, String tb, THoodieInstant instant) throws MetaserverStorageException, NoSuchObjectException {
        return this.timelineService.deleteInstant(db, tb, instant);
    }
}

