/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.service;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.apache.hudi.metaserver.service.HoodieMetaserverGateway;
import org.apache.hudi.metaserver.thrift.MetaserverException;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetaserverProxyHandler
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetaserverProxyHandler.class);
    private final HoodieMetaserverGateway metaserverGateway;

    public HoodieMetaserverProxyHandler(HoodieMetaserverGateway metaserverGateway) {
        this.metaserverGateway = metaserverGateway;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Throwable err;
        try {
            return method.invoke((Object)this.metaserverGateway, args);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            err = e.getCause();
        }
        catch (Throwable e) {
            err = e;
        }
        if (err != null) {
            LOG.error("Error in calling metaserver method=" + method.getName() + " args=" + Arrays.toString(args) + " error", err);
            if (err instanceof TException) {
                throw err;
            }
            throw new MetaserverException(err.getMessage());
        }
        return null;
    }
}

