/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.service;

import java.io.Serializable;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.metaserver.store.MetaserverStorage;
import org.apache.hudi.metaserver.thrift.AlreadyExistException;
import org.apache.hudi.metaserver.thrift.MetaserverException;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.NoSuchObjectException;
import org.apache.hudi.metaserver.thrift.Table;

public class TableService
implements Serializable {
    private final MetaserverStorage store;

    public TableService(MetaserverStorage metaserverStorage) {
        this.store = metaserverStorage;
    }

    public void createDatabase(String db) throws AlreadyExistException, MetaserverStorageException, MetaserverException {
        if (this.databaseExists(db)) {
            throw new AlreadyExistException("Database " + db + " already exists");
        }
        if (!this.store.createDatabase(db)) {
            throw new MetaserverException("Fail to create the database: " + db);
        }
    }

    public Table getTable(String db, String tb) throws MetaserverStorageException, NoSuchObjectException {
        Table table = this.store.getTable(db, tb);
        if (table == null) {
            throw new NoSuchObjectException(db + "." + tb + " does not exist");
        }
        table.setTableType(HoodieTableType.COPY_ON_WRITE.toString());
        return table;
    }

    public void createTable(Table table) throws MetaserverStorageException, NoSuchObjectException, AlreadyExistException, MetaserverException {
        Long dbId = this.store.getDatabaseId(table.getDatabaseName());
        if (dbId == null) {
            this.createDatabase(table.getDatabaseName());
            dbId = this.store.getDatabaseId(table.getDatabaseName());
        }
        if (this.tableExists(table.getDatabaseName(), table.getTableName())) {
            throw new AlreadyExistException(table.getDatabaseName() + "." + table.getTableName() + " already exists");
        }
        if (!this.store.createTable(dbId, table)) {
            throw new MetaserverException("Fail to create the table: " + table);
        }
    }

    private boolean databaseExists(String db) throws MetaserverStorageException {
        return this.store.getDatabaseId(db) != null;
    }

    private boolean tableExists(String db, String tb) throws MetaserverStorageException {
        return this.store.getTableId(db, tb) != null;
    }
}

