/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store;

import java.util.List;
import org.apache.hudi.ApiMaturityLevel;
import org.apache.hudi.PublicAPIClass;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.TState;
import org.apache.hudi.metaserver.thrift.Table;

@PublicAPIClass(maturity=ApiMaturityLevel.EVOLVING)
public interface MetaserverStorage
extends AutoCloseable {
    public void initStorage() throws MetaserverStorageException;

    public boolean createDatabase(String var1) throws MetaserverStorageException;

    public Long getDatabaseId(String var1) throws MetaserverStorageException;

    @VisibleForTesting
    public boolean deleteDatabase(Long var1) throws MetaserverStorageException;

    public boolean createTable(Long var1, Table var2) throws MetaserverStorageException;

    public Table getTable(String var1, String var2) throws MetaserverStorageException;

    public Long getTableId(String var1, String var2) throws MetaserverStorageException;

    @VisibleForTesting
    public boolean deleteTable(Long var1) throws MetaserverStorageException;

    public String createNewTimestamp(long var1) throws MetaserverStorageException;

    @VisibleForTesting
    public boolean deleteTableTimestamp(Long var1) throws MetaserverStorageException;

    public boolean createInstant(long var1, THoodieInstant var3) throws MetaserverStorageException;

    public boolean updateInstant(long var1, THoodieInstant var3, THoodieInstant var4) throws MetaserverStorageException;

    public boolean deleteInstant(long var1, THoodieInstant var3) throws MetaserverStorageException;

    public List<THoodieInstant> scanInstants(long var1, List<TState> var3, int var4) throws MetaserverStorageException;

    public List<THoodieInstant> scanInstants(long var1, TState var3, int var4) throws MetaserverStorageException;

    public boolean instantExists(long var1, THoodieInstant var3) throws MetaserverStorageException;

    public void saveInstantMetadata(long var1, THoodieInstant var3, byte[] var4) throws MetaserverStorageException;

    public boolean deleteInstantMetadata(long var1, THoodieInstant var3) throws MetaserverStorageException;

    public boolean deleteInstantAllMeta(long var1, String var3) throws MetaserverStorageException;

    public Option<byte[]> getInstantMetadata(long var1, THoodieInstant var3) throws MetaserverStorageException;

    @Override
    public void close();
}

