/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store.bean;

import org.apache.hudi.metaserver.thrift.TAction;
import org.apache.hudi.metaserver.thrift.THoodieInstant;
import org.apache.hudi.metaserver.thrift.TState;

public class InstantBean {
    private Long tableId;
    private String ts;
    private Integer action;
    private Integer state;

    public InstantBean(Long tableId, THoodieInstant instant) {
        this.tableId = tableId;
        this.ts = instant.getTimestamp();
        this.action = instant.getAction().getValue();
        this.state = instant.getState().getValue();
    }

    public InstantBean(String ts, int action, int state) {
        this.ts = ts;
        this.action = action;
        this.state = state;
    }

    public InstantBean(String ts, Byte action, Byte state) {
        this.ts = ts;
        this.action = action & 0xFF;
        this.state = state & 0xFF;
    }

    public THoodieInstant toTHoodieInstant() {
        THoodieInstant instant = new THoodieInstant();
        instant.setTimestamp(this.ts);
        instant.setAction(TAction.findByValue(this.action));
        instant.setState(TState.findByValue(this.state));
        return instant;
    }

    public Long getTableId() {
        return this.tableId;
    }

    public void setTableId(Long tableId) {
        this.tableId = tableId;
    }

    public String getTs() {
        return this.ts;
    }

    public void setTs(String ts) {
        this.ts = ts;
    }

    public Integer getAction() {
        return this.action;
    }

    public void setAction(Integer action) {
        this.action = action;
    }

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public String toString() {
        return "InstantBean{tableId=" + this.tableId + ", ts='" + this.ts + '\'' + ", action=" + this.action + ", state=" + this.state + '}';
    }
}

