/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store.jdbc;

import java.io.Serializable;
import java.util.List;
import org.apache.hudi.metaserver.store.jdbc.BatchDaoOperation;
import org.apache.hudi.metaserver.store.jdbc.SqlSessionFactoryUtils;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.ibatis.session.SqlSession;

public class BasicDao
implements Serializable {
    public <T> List<T> queryForListBySql(String namespace, String sqlID, Object parameter) {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            List list = session.selectList(this.statement(namespace, sqlID), parameter);
            return list;
        }
    }

    public <T> T queryForObjectBySql(String namespace, String sqlID, Object parameter) {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            Object t = session.selectOne(this.statement(namespace, sqlID), parameter);
            return t;
        }
    }

    public int insertBySql(String namespace, String sqlID, Object parameter) {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            int res = session.insert(this.statement(namespace, sqlID), parameter);
            session.commit();
            int n = res;
            return n;
        }
    }

    public int deleteBySql(String namespace, String sqlID, Object parameter) {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            int res = session.delete(this.statement(namespace, sqlID), parameter);
            session.commit();
            int n = res;
            return n;
        }
    }

    public int updateBySql(String namespace, String sqlID, Object parameter) {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            int res = session.update(this.statement(namespace, sqlID), parameter);
            session.commit();
            int n = res;
            return n;
        }
    }

    public void batchOperateBySql(List<BatchDaoOperation> batchDaoOperations) throws MetaserverStorageException {
        try (SqlSession session = SqlSessionFactoryUtils.openSqlSession();){
            block19: for (BatchDaoOperation batchDaoOperation : batchDaoOperations) {
                switch (batchDaoOperation.getOperationType()) {
                    case "INSERT": {
                        session.insert(this.statement(batchDaoOperation.getNamespace(), batchDaoOperation.getSqlID()), batchDaoOperation.getParameter());
                        continue block19;
                    }
                    case "UPDATE": {
                        session.update(this.statement(batchDaoOperation.getNamespace(), batchDaoOperation.getSqlID()), batchDaoOperation.getParameter());
                        continue block19;
                    }
                    case "DELETE": {
                        session.delete(this.statement(batchDaoOperation.getNamespace(), batchDaoOperation.getSqlID()), batchDaoOperation.getParameter());
                        continue block19;
                    }
                }
                throw new MetaserverStorageException("Unsupported type: " + batchDaoOperation.getOperationType());
            }
            session.commit();
        }
    }

    private String statement(String namespace, String sqlID) {
        return namespace + "." + sqlID;
    }
}

