/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metaserver.store.jdbc;

import java.util.List;
import org.apache.hudi.metaserver.store.jdbc.BasicDao;
import org.apache.hudi.metaserver.store.jdbc.BatchDaoOperation;
import org.apache.hudi.metaserver.thrift.MetaserverStorageException;
import org.apache.ibatis.exceptions.PersistenceException;

public class WrapperDao
extends BasicDao {
    private final String namespace;

    public WrapperDao(String namespace) {
        this.namespace = namespace;
    }

    public <T> List<T> queryForListBySql(String sqlID, Object parameter) throws MetaserverStorageException {
        try {
            return this.queryForListBySql(this.namespace, sqlID, parameter);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    public <T> T queryForObjectBySql(String sqlID, Object parameter) throws MetaserverStorageException {
        try {
            return this.queryForObjectBySql(this.namespace, sqlID, parameter);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    public int insertBySql(String sqlID, Object parameter) throws MetaserverStorageException {
        try {
            return this.insertBySql(this.namespace, sqlID, parameter);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    public int deleteBySql(String sqlID, Object parameter) throws MetaserverStorageException {
        try {
            return this.deleteBySql(this.namespace, sqlID, parameter);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    public int updateBySql(String sqlID, Object parameter) throws MetaserverStorageException {
        try {
            return this.updateBySql(this.namespace, sqlID, parameter);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    @Override
    public void batchOperateBySql(List<BatchDaoOperation> batchDaoOperations) throws MetaserverStorageException {
        try {
            batchDaoOperations.forEach(x -> {
                if (x.getNamespace() == null) {
                    x.setNamespace(this.namespace);
                }
            });
            super.batchOperateBySql(batchDaoOperations);
        }
        catch (PersistenceException e) {
            throw new MetaserverStorageException(e.getMessage());
        }
    }

    public static class FileDao
    extends WrapperDao {
        public FileDao() {
            super("FileMapper");
        }
    }

    public static class TimelineDao
    extends WrapperDao {
        public TimelineDao() {
            super("TimelineMapper");
        }
    }

    public static class PartitionDao
    extends WrapperDao {
        public PartitionDao() {
            super("PartitionMapper");
        }
    }

    public static class TableDao
    extends WrapperDao {
        public TableDao() {
            super("TableMapper");
        }
    }
}

