/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics;

import com.codahale.metrics.MetricRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.HoodieGauge;
import org.apache.hudi.metrics.MetricsReporter;
import org.apache.hudi.metrics.MetricsReporterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final Logger LOG = LoggerFactory.getLogger(Metrics.class);
    private static final Map<String, Metrics> METRICS_INSTANCE_PER_BASEPATH = new ConcurrentHashMap<String, Metrics>();
    private final MetricRegistry registry;
    private final List<MetricsReporter> reporters;
    private final String commonMetricPrefix;
    private final String basePath;
    private boolean initialized = false;
    private transient Thread shutdownThread = null;
    private final HoodieStorage storage;

    public Metrics(HoodieMetricsConfig metricConfig, HoodieStorage storage) {
        this.storage = storage;
        this.registry = new MetricRegistry();
        this.commonMetricPrefix = metricConfig.getMetricReporterMetricsNamePrefix();
        this.reporters = new ArrayList<MetricsReporter>();
        Option<MetricsReporter> defaultReporter = MetricsReporterFactory.createReporter(metricConfig, this.registry);
        defaultReporter.ifPresent(this.reporters::add);
        if (StringUtils.nonEmpty(metricConfig.getMetricReporterFileBasedConfigs())) {
            this.reporters.addAll(this.addAdditionalMetricsExporters(metricConfig));
        }
        if (this.reporters.size() == 0) {
            throw new RuntimeException("Cannot initialize Reporters.");
        }
        this.reporters.forEach(MetricsReporter::start);
        this.basePath = Metrics.getBasePath(metricConfig);
        this.shutdownThread = new Thread(() -> this.shutdown(true));
        Runtime.getRuntime().addShutdownHook(this.shutdownThread);
        this.initialized = true;
    }

    private void registerHoodieCommonMetrics() {
        this.registerGauges(Registry.getAllMetrics(true, true), Option.of(this.commonMetricPrefix));
    }

    public static synchronized Metrics getInstance(HoodieMetricsConfig metricConfig, HoodieStorage storage) {
        String basePath = Metrics.getBasePath(metricConfig);
        if (METRICS_INSTANCE_PER_BASEPATH.containsKey(basePath)) {
            return METRICS_INSTANCE_PER_BASEPATH.get(basePath);
        }
        Metrics metrics = new Metrics(metricConfig, storage);
        METRICS_INSTANCE_PER_BASEPATH.put(basePath, metrics);
        return metrics;
    }

    public static synchronized void shutdownAllMetrics() {
        METRICS_INSTANCE_PER_BASEPATH.values().forEach(Metrics::shutdown);
        METRICS_INSTANCE_PER_BASEPATH.clear();
    }

    private List<MetricsReporter> addAdditionalMetricsExporters(HoodieMetricsConfig metricConfig) {
        ArrayList<MetricsReporter> reporterList = new ArrayList<MetricsReporter>();
        List<String> propPathList = StringUtils.split(metricConfig.getMetricReporterFileBasedConfigs(), ",");
        try (HoodieStorage newStorage = this.storage.newInstance(new StoragePath(propPathList.get(0)), this.storage.getConf());){
            for (String propPath : propPathList) {
                HoodieMetricsConfig secondarySourceConfig = HoodieMetricsConfig.newBuilder().fromInputStream(newStorage.open(new StoragePath(propPath))).withPath(metricConfig.getBasePath()).build();
                Option<MetricsReporter> reporter = MetricsReporterFactory.createReporter(secondarySourceConfig, this.registry);
                if (reporter.isPresent()) {
                    reporterList.add(reporter.get());
                    continue;
                }
                LOG.error(String.format("Could not create reporter using properties path %s base path %s", propPath, metricConfig.getBasePath()));
            }
        }
        catch (IOException e) {
            LOG.error("Failed to add MetricsExporters", e);
        }
        LOG.info("total additional metrics reporters added =" + reporterList.size());
        return reporterList;
    }

    public void shutdown() {
        this.shutdown(false);
    }

    private synchronized void shutdown(boolean fromShutdownHook) {
        if (!fromShutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
        } else {
            LOG.warn("Shutting down the metrics reporter from shutdown hook.");
        }
        if (this.initialized) {
            try {
                this.registerHoodieCommonMetrics();
                this.reporters.forEach(MetricsReporter::report);
                LOG.info("Stopping the metrics reporter...");
                this.reporters.forEach(MetricsReporter::stop);
            }
            catch (Exception e) {
                LOG.warn("Error while closing reporter", e);
            }
            finally {
                METRICS_INSTANCE_PER_BASEPATH.remove(this.basePath);
                this.initialized = false;
            }
        }
    }

    public synchronized void flush() {
        try {
            LOG.info("Reporting and flushing all metrics");
            this.registerHoodieCommonMetrics();
            this.reporters.forEach(MetricsReporter::report);
            this.registry.getNames().forEach(arg_0 -> ((MetricRegistry)this.registry).remove(arg_0));
            this.registerHoodieCommonMetrics();
        }
        catch (Exception e) {
            LOG.error("Error while reporting and flushing metrics", e);
        }
    }

    public void registerGauges(Map<String, Long> metricsMap, Option<String> prefix) {
        String metricPrefix = prefix.isPresent() ? prefix.get() + "." : "";
        metricsMap.forEach((k, v) -> this.registerGauge(metricPrefix + k, (long)v));
    }

    public Option<HoodieGauge<Long>> registerGauge(String metricName, long value) {
        HoodieGauge gauge = null;
        try {
            gauge = (HoodieGauge)this.registry.gauge(metricName, () -> new HoodieGauge<Long>(value));
            gauge.setValue(value);
        }
        catch (Exception e) {
            LOG.error("Failed to send metrics: ", e);
        }
        return Option.ofNullable(gauge);
    }

    public Option<HoodieGauge<Long>> registerGauge(String metricName) {
        return this.registerGauge(metricName, 0L);
    }

    public MetricRegistry getRegistry() {
        return this.registry;
    }

    public static boolean isInitialized(String basePath) {
        if (METRICS_INSTANCE_PER_BASEPATH.containsKey(basePath)) {
            return Metrics.METRICS_INSTANCE_PER_BASEPATH.get((Object)basePath).initialized;
        }
        return false;
    }

    private static String getBasePath(HoodieMetricsConfig metricsConfig) {
        String basePath = metricsConfig.getBasePath();
        if (basePath.endsWith(".hoodie/metadata")) {
            String toRemoveSuffix = "/.hoodie/metadata";
            basePath = basePath.substring(0, basePath.length() - toRemoveSuffix.length());
        }
        return basePath;
    }
}

