/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.com.google.protobuf.Descriptors;
import org.apache.hudi.com.google.protobuf.Message;
import org.apache.hudi.com.google.protobuf.RpcController;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.CacheEvictionStats;
import org.apache.hudi.org.apache.hadoop.hbase.CacheEvictionStatsBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterMetricsBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.RegionLocations;
import org.apache.hudi.org.apache.hadoop.hbase.RegionMetrics;
import org.apache.hudi.org.apache.hadoop.hbase.RegionMetricsBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableExistsException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.Admin;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ColumnFamilyDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.CompactType;
import org.apache.hudi.org.apache.hadoop.hbase.client.CompactionState;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.ImmutableHRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.ImmutableHTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.LogEntry;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hudi.org.apache.hadoop.hbase.client.NoServerForRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.NonceGenerator;
import org.apache.hudi.org.apache.hadoop.hbase.client.NormalizeTableFilterParams;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetryingCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallable;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCaller;
import org.apache.hudi.org.apache.hadoop.hbase.client.RpcRetryingCallerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.ServerType;
import org.apache.hudi.org.apache.hadoop.hbase.client.SnapshotDescription;
import org.apache.hudi.org.apache.hadoop.hbase.client.SyncCoprocessorRpcChannel;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableState;
import org.apache.hudi.org.apache.hadoop.hbase.client.replication.ReplicationPeerConfigUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.replication.TableCFs;
import org.apache.hudi.org.apache.hadoop.hbase.client.security.SecurityCapability;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.TimeoutIOException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcChannel;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.CoprocessorRpcUtils;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaFilter;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.wal.FailedLogCloseException;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerConfig;
import org.apache.hudi.org.apache.hadoop.hbase.replication.ReplicationPeerDescription;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.GetUserPermissionsRequest;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.ShadedAccessControlUtil;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.UserPermission;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.AccessControlProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ReplicationProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.SnapshotProtos;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.ClientSnapshotDescriptionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.HBaseSnapshotException;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.RestoreSnapshotException;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.SnapshotCreationException;
import org.apache.hudi.org.apache.hadoop.hbase.snapshot.UnknownSnapshotException;
import org.apache.hudi.org.apache.hadoop.hbase.util.Addressing;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.ForeignExceptionUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.base.Preconditions;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ProtocolStringList;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.apache.hudi.org.apache.hbase.thirdparty.org.apache.commons.collections4.CollectionUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseAdmin
implements Admin {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseAdmin.class);
    private ClusterConnection connection;
    private final Configuration conf;
    private final long pause;
    private final int numRetries;
    private final int syncWaitTimeout;
    private boolean aborted;
    private int operationTimeout;
    private int rpcTimeout;
    private int getProcedureTimeout;
    private RpcRetryingCallerFactory rpcCallerFactory;
    private RpcControllerFactory rpcControllerFactory;
    private NonceGenerator ng;

    @Override
    public int getOperationTimeout() {
        return this.operationTimeout;
    }

    @Override
    public int getSyncWaitTimeout() {
        return this.syncWaitTimeout;
    }

    HBaseAdmin(ClusterConnection connection) throws IOException {
        this.conf = connection.getConfiguration();
        this.connection = connection;
        this.pause = this.conf.getLong("hbase.client.pause", 100L);
        this.numRetries = this.conf.getInt("hbase.client.retries.number", 15);
        this.operationTimeout = this.conf.getInt("hbase.client.operation.timeout", 1200000);
        this.rpcTimeout = this.conf.getInt("hbase.rpc.timeout", 60000);
        this.syncWaitTimeout = this.conf.getInt("hbase.client.sync.wait.timeout.msec", 600000);
        this.getProcedureTimeout = this.conf.getInt("hbase.client.procedure.future.get.timeout.msec", 600000);
        this.rpcCallerFactory = connection.getRpcRetryingCallerFactory();
        this.rpcControllerFactory = connection.getRpcControllerFactory();
        this.ng = this.connection.getNonceGenerator();
    }

    @Override
    public void abort(String why, Throwable e) {
        this.aborted = true;
        throw new RuntimeException(why, e);
    }

    @Override
    public boolean isAborted() {
        return this.aborted;
    }

    @Override
    public boolean abortProcedure(long procId, boolean mayInterruptIfRunning) throws IOException {
        return HBaseAdmin.get(this.abortProcedureAsync(procId, mayInterruptIfRunning), this.syncWaitTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public Future<Boolean> abortProcedureAsync(final long procId, boolean mayInterruptIfRunning) throws IOException {
        Boolean abortProcResponse = ((MasterProtos.AbortProcedureResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.AbortProcedureResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.AbortProcedureResponse rpcCall() throws Exception {
                MasterProtos.AbortProcedureRequest abortProcRequest = MasterProtos.AbortProcedureRequest.newBuilder().setProcId(procId).build();
                return this.master.abortProcedure(this.getRpcController(), abortProcRequest);
            }
        })).getIsProcedureAborted();
        return new AbortProcedureFuture(this, procId, abortProcResponse);
    }

    @Override
    public List<TableDescriptor> listTableDescriptors() throws IOException {
        return this.listTableDescriptors(null, false);
    }

    @Override
    public List<TableDescriptor> listTableDescriptors(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<TableDescriptor>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<TableDescriptor> rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables);
                return ProtobufUtil.toTableDescriptorList(this.master.getTableDescriptors(this.getRpcController(), req));
            }
        });
    }

    @Override
    public TableDescriptor getDescriptor(TableName tableName) throws TableNotFoundException, IOException {
        return HBaseAdmin.getTableDescriptor(tableName, this.getConnection(), this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.rpcTimeout);
    }

    @Override
    public Future<Void> modifyTableAsync(final TableDescriptor td) throws IOException {
        MasterProtos.ModifyTableResponse response = (MasterProtos.ModifyTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.ModifyTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.ModifyTableResponse rpcCall() throws Exception {
                this.setPriority(td.getTableName());
                MasterProtos.ModifyTableRequest request = RequestConverter.buildModifyTableRequest(td.getTableName(), td, this.nonceGroup, this.nonce);
                return this.master.modifyTable(this.getRpcController(), request);
            }
        });
        return new ModifyTableFuture(this, td.getTableName(), response);
    }

    @Override
    public List<TableDescriptor> listTableDescriptorsByNamespace(final byte[] name) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<TableDescriptor>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<TableDescriptor> rpcCall() throws Exception {
                return this.master.listTableDescriptorsByNamespace(this.getRpcController(), MasterProtos.ListTableDescriptorsByNamespaceRequest.newBuilder().setNamespaceName(Bytes.toString(name)).build()).getTableSchemaList().stream().map(ProtobufUtil::toTableDescriptor).collect(Collectors.toList());
            }
        });
    }

    @Override
    public List<TableDescriptor> listTableDescriptors(final List<TableName> tableNames) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<TableDescriptor>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<TableDescriptor> rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                return ProtobufUtil.toTableDescriptorList(this.master.getTableDescriptors(this.getRpcController(), req));
            }
        });
    }

    @Override
    public List<RegionInfo> getRegions(ServerName sn) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        return ProtobufUtil.getOnlineRegions(controller, admin);
    }

    @Override
    public List<RegionInfo> getRegions(TableName tableName) throws IOException {
        if (TableName.isMetaTableName(tableName)) {
            return Arrays.asList(RegionInfoBuilder.FIRST_META_REGIONINFO);
        }
        return MetaTableAccessor.getTableRegions(this.connection, tableName, true);
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public boolean tableExists(final TableName tableName) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<Boolean>(){

            @Override
            protected Boolean rpcCall(int callTimeout) throws Exception {
                return MetaTableAccessor.getTableState(HBaseAdmin.this.getConnection(), tableName) != null;
            }
        });
    }

    @Override
    public HTableDescriptor[] listTables() throws IOException {
        return this.listTables((Pattern)null, false);
    }

    @Override
    public HTableDescriptor[] listTables(Pattern pattern) throws IOException {
        return this.listTables(pattern, false);
    }

    @Override
    public HTableDescriptor[] listTables(String regex) throws IOException {
        return this.listTables(Pattern.compile(regex), false);
    }

    @Override
    public HTableDescriptor[] listTables(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return (HTableDescriptor[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<HTableDescriptor[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected HTableDescriptor[] rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(pattern, includeSysTables);
                return (HTableDescriptor[])ProtobufUtil.toTableDescriptorList(this.master.getTableDescriptors(this.getRpcController(), req)).stream().map(ImmutableHTableDescriptor::new).toArray(HTableDescriptor[]::new);
            }
        });
    }

    @Override
    public HTableDescriptor[] listTables(String regex, boolean includeSysTables) throws IOException {
        return this.listTables(Pattern.compile(regex), includeSysTables);
    }

    @Override
    public TableName[] listTableNames() throws IOException {
        return this.listTableNames((Pattern)null, false);
    }

    @Override
    public TableName[] listTableNames(String regex) throws IOException {
        return this.listTableNames(Pattern.compile(regex), false);
    }

    @Override
    public TableName[] listTableNames(final Pattern pattern, final boolean includeSysTables) throws IOException {
        return (TableName[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<TableName[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected TableName[] rpcCall() throws Exception {
                MasterProtos.GetTableNamesRequest req = RequestConverter.buildGetTableNamesRequest(pattern, includeSysTables);
                return ProtobufUtil.getTableNameArray(this.master.getTableNames(this.getRpcController(), req).getTableNamesList());
            }
        });
    }

    @Override
    public TableName[] listTableNames(String regex, boolean includeSysTables) throws IOException {
        return this.listTableNames(Pattern.compile(regex), includeSysTables);
    }

    @Override
    public HTableDescriptor getTableDescriptor(TableName tableName) throws IOException {
        return HBaseAdmin.getHTableDescriptor(tableName, this.getConnection(), this.rpcCallerFactory, this.rpcControllerFactory, this.operationTimeout, this.rpcTimeout);
    }

    static TableDescriptor getTableDescriptor(final TableName tableName, Connection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, int operationTimeout, int rpcTimeout) throws IOException {
        if (tableName == null) {
            return null;
        }
        TableDescriptor td = (TableDescriptor)HBaseAdmin.executeCallable(new MasterCallable<TableDescriptor>(connection, rpcControllerFactory){

            @Override
            protected TableDescriptor rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                MasterProtos.GetTableDescriptorsResponse htds = this.master.getTableDescriptors(this.getRpcController(), req);
                if (!htds.getTableSchemaList().isEmpty()) {
                    return ProtobufUtil.toTableDescriptor(htds.getTableSchemaList().get(0));
                }
                return null;
            }
        }, rpcCallerFactory, operationTimeout, rpcTimeout);
        if (td != null) {
            return td;
        }
        throw new TableNotFoundException(tableName.getNameAsString());
    }

    @Deprecated
    static HTableDescriptor getHTableDescriptor(final TableName tableName, Connection connection, RpcRetryingCallerFactory rpcCallerFactory, RpcControllerFactory rpcControllerFactory, int operationTimeout, int rpcTimeout) throws IOException {
        if (tableName == null) {
            return null;
        }
        HTableDescriptor htd = (HTableDescriptor)HBaseAdmin.executeCallable(new MasterCallable<HTableDescriptor>(connection, rpcControllerFactory){

            @Override
            protected HTableDescriptor rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableName);
                MasterProtos.GetTableDescriptorsResponse htds = this.master.getTableDescriptors(this.getRpcController(), req);
                if (!htds.getTableSchemaList().isEmpty()) {
                    return new ImmutableHTableDescriptor(ProtobufUtil.toTableDescriptor(htds.getTableSchemaList().get(0)));
                }
                return null;
            }
        }, rpcCallerFactory, operationTimeout, rpcTimeout);
        if (htd != null) {
            return new ImmutableHTableDescriptor(htd);
        }
        throw new TableNotFoundException(tableName.getNameAsString());
    }

    private long getPauseTime(int tries) {
        int triesCount = tries;
        if (triesCount >= HConstants.RETRY_BACKOFF.length) {
            triesCount = HConstants.RETRY_BACKOFF.length - 1;
        }
        return this.pause * (long)HConstants.RETRY_BACKOFF[triesCount];
    }

    @Override
    public void createTable(TableDescriptor desc, byte[] startKey, byte[] endKey, int numRegions) throws IOException {
        if (numRegions < 3) {
            throw new IllegalArgumentException("Must create at least three regions");
        }
        if (Bytes.compareTo(startKey, endKey) >= 0) {
            throw new IllegalArgumentException("Start key must be smaller than end key");
        }
        if (numRegions == 3) {
            this.createTable(desc, new byte[][]{startKey, endKey});
            return;
        }
        byte[][] splitKeys = Bytes.split(startKey, endKey, numRegions - 3);
        if (splitKeys == null || splitKeys.length != numRegions - 1) {
            throw new IllegalArgumentException("Unable to split key range into enough regions");
        }
        this.createTable(desc, splitKeys);
    }

    @Override
    public Future<Void> createTableAsync(final TableDescriptor desc, final byte[][] splitKeys) throws IOException {
        if (desc.getTableName() == null) {
            throw new IllegalArgumentException("TableName cannot be null");
        }
        if (splitKeys != null && splitKeys.length > 0) {
            Arrays.sort(splitKeys, Bytes.BYTES_COMPARATOR);
            byte[] lastKey = null;
            for (byte[] splitKey : splitKeys) {
                if (Bytes.compareTo(splitKey, HConstants.EMPTY_BYTE_ARRAY) == 0) {
                    throw new IllegalArgumentException("Empty split key must not be passed in the split keys.");
                }
                if (lastKey != null && Bytes.equals(splitKey, lastKey)) {
                    throw new IllegalArgumentException("All split keys must be unique, found duplicate: " + Bytes.toStringBinary(splitKey) + ", " + Bytes.toStringBinary(lastKey));
                }
                lastKey = splitKey;
            }
        }
        MasterProtos.CreateTableResponse response = (MasterProtos.CreateTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.CreateTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.CreateTableResponse rpcCall() throws Exception {
                this.setPriority(desc.getTableName());
                MasterProtos.CreateTableRequest request = RequestConverter.buildCreateTableRequest(desc, splitKeys, this.nonceGroup, this.nonce);
                return this.master.createTable(this.getRpcController(), request);
            }
        });
        return new CreateTableFuture(this, desc, splitKeys, response);
    }

    @Override
    public Future<Void> deleteTableAsync(final TableName tableName) throws IOException {
        MasterProtos.DeleteTableResponse response = (MasterProtos.DeleteTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.DeleteTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.DeleteTableResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.DeleteTableRequest req = RequestConverter.buildDeleteTableRequest(tableName, this.nonceGroup, this.nonce);
                return this.master.deleteTable(this.getRpcController(), req);
            }
        });
        return new DeleteTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] deleteTables(String regex) throws IOException {
        return this.deleteTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] deleteTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            try {
                this.deleteTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to delete table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public Future<Void> truncateTableAsync(final TableName tableName, final boolean preserveSplits) throws IOException {
        MasterProtos.TruncateTableResponse response = (MasterProtos.TruncateTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.TruncateTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.TruncateTableResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                LOG.info("Started truncating " + tableName);
                MasterProtos.TruncateTableRequest req = RequestConverter.buildTruncateTableRequest(tableName, preserveSplits, this.nonceGroup, this.nonce);
                return this.master.truncateTable(this.getRpcController(), req);
            }
        });
        return new TruncateTableFuture(this, tableName, preserveSplits, response);
    }

    private byte[][] getTableSplits(TableName tableName) throws IOException {
        Object splits = null;
        try (RegionLocator locator = this.getConnection().getRegionLocator(tableName);){
            byte[][] startKeys = locator.getStartKeys();
            if (startKeys.length == 1) {
                byte[][] byArray = splits;
                return byArray;
            }
            splits = new byte[startKeys.length - 1][];
            for (int i = 1; i < startKeys.length; ++i) {
                splits[i - 1] = startKeys[i];
            }
        }
        return splits;
    }

    @Override
    public Future<Void> enableTableAsync(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(tableName.getName());
        MasterProtos.EnableTableResponse response = (MasterProtos.EnableTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.EnableTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.EnableTableResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                LOG.info("Started enable of " + tableName);
                MasterProtos.EnableTableRequest req = RequestConverter.buildEnableTableRequest(tableName, this.nonceGroup, this.nonce);
                return this.master.enableTable(this.getRpcController(), req);
            }
        });
        return new EnableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] enableTables(String regex) throws IOException {
        return this.enableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] enableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableDisabled(table.getTableName())) continue;
            try {
                this.enableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to enable table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public Future<Void> disableTableAsync(final TableName tableName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(tableName.getName());
        MasterProtos.DisableTableResponse response = (MasterProtos.DisableTableResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.DisableTableResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.DisableTableResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                LOG.info("Started disable of " + tableName);
                MasterProtos.DisableTableRequest req = RequestConverter.buildDisableTableRequest(tableName, this.nonceGroup, this.nonce);
                return this.master.disableTable(this.getRpcController(), req);
            }
        });
        return new DisableTableFuture(this, tableName, response);
    }

    @Override
    public HTableDescriptor[] disableTables(String regex) throws IOException {
        return this.disableTables(Pattern.compile(regex));
    }

    @Override
    public HTableDescriptor[] disableTables(Pattern pattern) throws IOException {
        LinkedList<HTableDescriptor> failed = new LinkedList<HTableDescriptor>();
        for (HTableDescriptor table : this.listTables(pattern)) {
            if (!this.isTableEnabled(table.getTableName())) continue;
            try {
                this.disableTable(table.getTableName());
            }
            catch (IOException ex) {
                LOG.info("Failed to disable table " + table.getTableName(), ex);
                failed.add(table);
            }
        }
        return failed.toArray(new HTableDescriptor[failed.size()]);
    }

    @Override
    public boolean isTableEnabled(final TableName tableName) throws IOException {
        this.checkTableExists(tableName);
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<Boolean>(){

            @Override
            protected Boolean rpcCall(int callTimeout) throws Exception {
                TableState tableState = MetaTableAccessor.getTableState(HBaseAdmin.this.getConnection(), tableName);
                if (tableState == null) {
                    throw new TableNotFoundException(tableName);
                }
                return tableState.inStates(TableState.State.ENABLED);
            }
        });
    }

    @Override
    public boolean isTableDisabled(TableName tableName) throws IOException {
        this.checkTableExists(tableName);
        return this.connection.isTableDisabled(tableName);
    }

    @Override
    public boolean isTableAvailable(TableName tableName) throws IOException {
        return this.connection.isTableAvailable(tableName, null);
    }

    @Override
    public boolean isTableAvailable(TableName tableName, byte[][] splitKeys) throws IOException {
        return this.connection.isTableAvailable(tableName, splitKeys);
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(final TableName tableName) throws IOException {
        return (Pair)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Pair<Integer, Integer>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Pair<Integer, Integer> rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.GetSchemaAlterStatusRequest req = RequestConverter.buildGetSchemaAlterStatusRequest(tableName);
                MasterProtos.GetSchemaAlterStatusResponse ret = this.master.getSchemaAlterStatus(this.getRpcController(), req);
                Pair<Integer, Integer> pair = new Pair<Integer, Integer>(ret.getYetToUpdateRegions(), ret.getTotalRegions());
                return pair;
            }
        });
    }

    @Override
    public Pair<Integer, Integer> getAlterStatus(byte[] tableName) throws IOException {
        return this.getAlterStatus(TableName.valueOf(tableName));
    }

    @Override
    public Future<Void> addColumnFamilyAsync(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        MasterProtos.AddColumnResponse response = (MasterProtos.AddColumnResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.AddColumnResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.AddColumnResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.AddColumnRequest req = RequestConverter.buildAddColumnRequest(tableName, columnFamily, this.nonceGroup, this.nonce);
                return this.master.addColumn(this.getRpcController(), req);
            }
        });
        return new AddColumnFamilyFuture(this, tableName, response);
    }

    @Override
    @Deprecated
    public void deleteColumn(TableName tableName, byte[] columnFamily) throws IOException {
        this.deleteColumnFamily(tableName, columnFamily);
    }

    @Override
    public Future<Void> deleteColumnFamilyAsync(final TableName tableName, final byte[] columnFamily) throws IOException {
        MasterProtos.DeleteColumnResponse response = (MasterProtos.DeleteColumnResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.DeleteColumnResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.DeleteColumnResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.DeleteColumnRequest req = RequestConverter.buildDeleteColumnRequest(tableName, columnFamily, this.nonceGroup, this.nonce);
                return this.master.deleteColumn(this.getRpcController(), req);
            }
        });
        return new DeleteColumnFamilyFuture(this, tableName, response);
    }

    @Override
    public Future<Void> modifyColumnFamilyAsync(final TableName tableName, final ColumnFamilyDescriptor columnFamily) throws IOException {
        MasterProtos.ModifyColumnResponse response = (MasterProtos.ModifyColumnResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.ModifyColumnResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.ModifyColumnResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.ModifyColumnRequest req = RequestConverter.buildModifyColumnRequest(tableName, columnFamily, this.nonceGroup, this.nonce);
                return this.master.modifyColumn(this.getRpcController(), req);
            }
        });
        return new ModifyColumnFamilyFuture(this, tableName, response);
    }

    @Override
    @Deprecated
    public void closeRegion(String regionName, String unused) throws IOException {
        this.unassign(Bytes.toBytes(regionName), true);
    }

    @Override
    @Deprecated
    public void closeRegion(byte[] regionName, String unused) throws IOException {
        this.unassign(regionName, true);
    }

    @Override
    @Deprecated
    public boolean closeRegionWithEncodedRegionName(String encodedRegionName, String unused) throws IOException {
        this.unassign(Bytes.toBytes(encodedRegionName), true);
        return true;
    }

    @Override
    @Deprecated
    public void closeRegion(ServerName unused, HRegionInfo hri) throws IOException {
        this.unassign(hri.getRegionName(), true);
    }

    @Override
    @Deprecated
    public List<HRegionInfo> getOnlineRegions(ServerName sn) throws IOException {
        return this.getRegions(sn).stream().map(ImmutableHRegionInfo::new).collect(Collectors.toList());
    }

    @Override
    public void flush(TableName tableName) throws IOException {
        this.flush(tableName, null);
    }

    @Override
    public void flush(TableName tableName, byte[] columnFamily) throws IOException {
        this.checkTableExists(tableName);
        if (this.isTableDisabled(tableName)) {
            LOG.info("Table is disabled: " + tableName.getNameAsString());
            return;
        }
        HashMap<String, String> props = new HashMap<String, String>();
        if (columnFamily != null) {
            props.put("family", Bytes.toString(columnFamily));
        }
        this.execProcedure("flush-table-proc", tableName.getNameAsString(), props);
    }

    @Override
    public void flushRegion(byte[] regionName) throws IOException {
        this.flushRegion(regionName, null);
    }

    @Override
    public void flushRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        Pair<RegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Unknown regionname: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        RegionInfo regionInfo = regionServerPair.getFirst();
        ServerName serverName = regionServerPair.getSecond();
        this.flush(this.connection.getAdmin(serverName), regionInfo, columnFamily);
    }

    private void flush(AdminProtos.AdminService.BlockingInterface admin, RegionInfo info, byte[] columnFamily) throws IOException {
        ProtobufUtil.call(() -> {
            HBaseRpcController controller = this.rpcControllerFactory.newController();
            AdminProtos.FlushRegionRequest request = RequestConverter.buildFlushRegionRequest(info.getRegionName(), columnFamily, false);
            admin.flushRegion(controller, request);
            return null;
        });
    }

    @Override
    public void flushRegionServer(ServerName serverName) throws IOException {
        for (RegionInfo region : this.getRegions(serverName)) {
            this.flush(this.connection.getAdmin(serverName), region, null);
        }
    }

    @Override
    public void compact(TableName tableName) throws IOException {
        this.compact(tableName, null, false, CompactType.NORMAL);
    }

    @Override
    public void compactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, false);
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, false, CompactType.NORMAL);
    }

    @Override
    public void compactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, false);
    }

    @Override
    public Map<ServerName, Boolean> compactionSwitch(boolean switchState, List<String> serverNamesList) throws IOException {
        ArrayList<ServerName> serverList = new ArrayList<ServerName>();
        if (serverNamesList.isEmpty()) {
            ClusterMetrics status = this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS));
            serverList.addAll(status.getLiveServerMetrics().keySet());
        } else {
            for (String regionServerName : serverNamesList) {
                ServerName serverName = null;
                try {
                    serverName = ServerName.valueOf(regionServerName);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Invalid ServerName format: %s", regionServerName));
                }
                if (serverName == null) {
                    throw new IllegalArgumentException(String.format("Null ServerName: %s", regionServerName));
                }
                serverList.add(serverName);
            }
        }
        HashMap<ServerName, Boolean> res = new HashMap<ServerName, Boolean>(serverList.size());
        for (ServerName serverName : serverList) {
            boolean prev_state = this.switchCompact(this.connection.getAdmin(serverName), switchState);
            res.put(serverName, prev_state);
        }
        return res;
    }

    private Boolean switchCompact(final AdminProtos.AdminService.BlockingInterface admin, final boolean onOrOff) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<Boolean>(){

            @Override
            protected Boolean rpcCall(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                AdminProtos.CompactionSwitchRequest request = AdminProtos.CompactionSwitchRequest.newBuilder().setEnabled(onOrOff).build();
                AdminProtos.CompactionSwitchResponse compactionSwitchResponse = admin.compactionSwitch(controller, request);
                return compactionSwitchResponse.getPrevState();
            }
        });
    }

    @Override
    public void compactRegionServer(ServerName serverName) throws IOException {
        for (RegionInfo region : this.getRegions(serverName)) {
            this.compact(this.connection.getAdmin(serverName), region, false, null);
        }
    }

    @Override
    public void majorCompactRegionServer(ServerName serverName) throws IOException {
        for (RegionInfo region : this.getRegions(serverName)) {
            this.compact(this.connection.getAdmin(serverName), region, true, null);
        }
    }

    @Override
    public void majorCompact(TableName tableName) throws IOException {
        this.compact(tableName, null, true, CompactType.NORMAL);
    }

    @Override
    public void majorCompactRegion(byte[] regionName) throws IOException {
        this.compactRegion(regionName, null, true);
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily) throws IOException {
        this.compact(tableName, columnFamily, true, CompactType.NORMAL);
    }

    @Override
    public void majorCompactRegion(byte[] regionName, byte[] columnFamily) throws IOException {
        this.compactRegion(regionName, columnFamily, true);
    }

    private void compact(TableName tableName, byte[] columnFamily, boolean major, CompactType compactType) throws IOException {
        switch (compactType) {
            case MOB: {
                this.compact(this.connection.getAdminForMaster(), RegionInfo.createMobRegionInfo(tableName), major, columnFamily);
                break;
            }
            case NORMAL: {
                this.checkTableExists(tableName);
                for (HRegionLocation loc : this.connection.locateRegions(tableName, false, false)) {
                    ServerName sn = loc.getServerName();
                    if (sn == null) continue;
                    try {
                        this.compact(this.connection.getAdmin(sn), loc.getRegion(), major, columnFamily);
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Trying to" + (major ? " major" : "") + " compact " + loc.getRegion() + ": " + StringUtils.stringifyException((Throwable)e));
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compactType: " + (Object)((Object)compactType));
            }
        }
    }

    private void compactRegion(byte[] regionName, byte[] columnFamily, boolean major) throws IOException {
        Pair<RegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        this.compact(this.connection.getAdmin(regionServerPair.getSecond()), regionServerPair.getFirst(), major, columnFamily);
    }

    private void compact(final AdminProtos.AdminService.BlockingInterface admin, final RegionInfo hri, final boolean major, final byte[] family) throws IOException {
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                AdminProtos.CompactRegionRequest request = RequestConverter.buildCompactRegionRequest(hri.getRegionName(), major, family);
                admin.compactRegion(controller, request);
                return null;
            }
        };
        ProtobufUtil.call(callable);
    }

    @Override
    public void move(byte[] encodedRegionName) throws IOException {
        this.move(encodedRegionName, (ServerName)null);
    }

    @Override
    public void move(final byte[] encodedRegionName, final ServerName destServerName) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(encodedRegionName);
                MasterProtos.MoveRegionRequest request = RequestConverter.buildMoveRegionRequest(encodedRegionName, destServerName);
                this.master.moveRegion(this.getRpcController(), request);
                return null;
            }
        });
    }

    @Override
    public void assign(final byte[] regionName) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(regionName);
                MasterProtos.AssignRegionRequest request = RequestConverter.buildAssignRegionRequest(HBaseAdmin.this.getRegionName(regionName));
                this.master.assignRegion(this.getRpcController(), request);
                return null;
            }
        });
    }

    @Override
    public void unassign(final byte[] regionName) throws IOException {
        final byte[] toBeUnassigned = this.getRegionName(regionName);
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(regionName);
                MasterProtos.UnassignRegionRequest request = RequestConverter.buildUnassignRegionRequest(toBeUnassigned);
                this.master.unassignRegion(this.getRpcController(), request);
                return null;
            }
        });
    }

    @Override
    public void offline(final byte[] regionName) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(regionName);
                this.master.offlineRegion(this.getRpcController(), RequestConverter.buildOfflineRegionRequest(regionName));
                return null;
            }
        });
    }

    @Override
    public boolean balancerSwitch(final boolean on, final boolean synchronous) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                MasterProtos.SetBalancerRunningRequest req = RequestConverter.buildSetBalancerRunningRequest(on, synchronous);
                return this.master.setBalancerRunning(this.getRpcController(), req).getPrevBalanceValue();
            }
        });
    }

    @Override
    public boolean balance() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.balance(this.getRpcController(), RequestConverter.buildBalanceRequest(false)).getBalancerRan();
            }
        });
    }

    @Override
    public boolean balance(final boolean force) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.balance(this.getRpcController(), RequestConverter.buildBalanceRequest(force)).getBalancerRan();
            }
        });
    }

    @Override
    public boolean isBalancerEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isBalancerEnabled(this.getRpcController(), RequestConverter.buildIsBalancerEnabledRequest()).getEnabled();
            }
        });
    }

    @Override
    public CacheEvictionStats clearBlockCache(TableName tableName) throws IOException {
        this.checkTableExists(tableName);
        CacheEvictionStatsBuilder cacheEvictionStats = CacheEvictionStats.builder();
        List<Pair<RegionInfo, ServerName>> pairs = MetaTableAccessor.getTableRegionsAndLocations(this.connection, tableName);
        Map regionInfoByServerName = pairs.stream().filter(pair -> !((RegionInfo)pair.getFirst()).isOffline()).filter(pair -> pair.getSecond() != null).collect(Collectors.groupingBy(pair -> (ServerName)pair.getSecond(), Collectors.mapping(pair -> (RegionInfo)pair.getFirst(), Collectors.toList())));
        for (Map.Entry entry : regionInfoByServerName.entrySet()) {
            CacheEvictionStats stats = this.clearBlockCache(entry.getKey(), entry.getValue());
            cacheEvictionStats = cacheEvictionStats.append(stats);
            if (stats.getExceptionCount() <= 0) continue;
            for (Map.Entry<byte[], Throwable> exception : stats.getExceptions().entrySet()) {
                LOG.debug("Failed to clear block cache for " + Bytes.toStringBinary(exception.getKey()) + " on " + entry.getKey() + ": ", exception.getValue());
            }
        }
        return cacheEvictionStats.build();
    }

    private CacheEvictionStats clearBlockCache(ServerName sn, List<RegionInfo> hris) throws IOException {
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.ClearRegionBlockCacheRequest request = RequestConverter.buildClearRegionBlockCacheRequest(hris);
        try {
            AdminProtos.ClearRegionBlockCacheResponse response = admin.clearRegionBlockCache(controller, request);
            return ProtobufUtil.toCacheEvictionStats(response.getStats());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public boolean normalize(final NormalizeTableFilterParams ntfp) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.normalize(this.getRpcController(), RequestConverter.buildNormalizeRequest(ntfp)).getNormalizerRan();
            }
        });
    }

    @Override
    public boolean isNormalizerEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isNormalizerEnabled(this.getRpcController(), RequestConverter.buildIsNormalizerEnabledRequest()).getEnabled();
            }
        });
    }

    @Override
    public boolean normalizerSwitch(final boolean on) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                MasterProtos.SetNormalizerRunningRequest req = RequestConverter.buildSetNormalizerRunningRequest(on);
                return this.master.setNormalizerRunning(this.getRpcController(), req).getPrevNormalizerValue();
            }
        });
    }

    @Override
    public boolean catalogJanitorSwitch(final boolean enable) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.enableCatalogJanitor(this.getRpcController(), RequestConverter.buildEnableCatalogJanitorRequest(enable)).getPrevValue();
            }
        });
    }

    @Override
    public int runCatalogJanitor() throws IOException {
        return (Integer)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Integer>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Integer rpcCall() throws Exception {
                return this.master.runCatalogScan(this.getRpcController(), RequestConverter.buildCatalogScanRequest()).getScanResult();
            }
        });
    }

    @Override
    public boolean isCatalogJanitorEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isCatalogJanitorEnabled(this.getRpcController(), RequestConverter.buildIsCatalogJanitorEnabledRequest()).getValue();
            }
        });
    }

    @Override
    public boolean cleanerChoreSwitch(final boolean on) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public Boolean rpcCall() throws Exception {
                return this.master.setCleanerChoreRunning(this.getRpcController(), RequestConverter.buildSetCleanerChoreRunningRequest(on)).getPrevValue();
            }
        });
    }

    @Override
    public boolean runCleanerChore() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public Boolean rpcCall() throws Exception {
                return this.master.runCleanerChore(this.getRpcController(), RequestConverter.buildRunCleanerChoreRequest()).getCleanerChoreRan();
            }
        });
    }

    @Override
    public boolean isCleanerChoreEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public Boolean rpcCall() throws Exception {
                return this.master.isCleanerChoreEnabled(this.getRpcController(), RequestConverter.buildIsCleanerChoreEnabledRequest()).getValue();
            }
        });
    }

    public void mergeRegionsSync(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        HBaseAdmin.get(this.mergeRegionsAsync(nameOfRegionA, nameOfRegionB, forcible), this.syncWaitTimeout, TimeUnit.MILLISECONDS);
    }

    @Override
    @Deprecated
    public void mergeRegions(byte[] nameOfRegionA, byte[] nameOfRegionB, boolean forcible) throws IOException {
        this.mergeRegionsAsync(nameOfRegionA, nameOfRegionB, forcible);
    }

    @Override
    public Future<Void> mergeRegionsAsync(byte[][] nameofRegionsToMerge, final boolean forcible) throws IOException {
        Preconditions.checkArgument(nameofRegionsToMerge.length >= 2, "Can not merge only %s region", nameofRegionsToMerge.length);
        final byte[][] encodedNameofRegionsToMerge = new byte[nameofRegionsToMerge.length][];
        for (int i = 0; i < nameofRegionsToMerge.length; ++i) {
            encodedNameofRegionsToMerge[i] = RegionInfo.isEncodedRegionName(nameofRegionsToMerge[i]) ? nameofRegionsToMerge[i] : Bytes.toBytes(RegionInfo.encodeRegionName(nameofRegionsToMerge[i]));
        }
        TableName tableName = null;
        for (int i = 0; i < nameofRegionsToMerge.length; ++i) {
            Pair<RegionInfo, ServerName> pair = this.getRegion(nameofRegionsToMerge[i]);
            if (pair != null) {
                if (pair.getFirst().getReplicaId() != 0) {
                    throw new IllegalArgumentException("Can't invoke merge on non-default regions directly");
                }
                if (tableName == null) {
                    tableName = pair.getFirst().getTable();
                    continue;
                }
                if (tableName.equals(pair.getFirst().getTable())) continue;
                throw new IllegalArgumentException("Cannot merge regions from two different tables " + tableName + " and " + pair.getFirst().getTable());
            }
            throw new UnknownRegionException("Can't invoke merge on unknown region " + Bytes.toStringBinary(encodedNameofRegionsToMerge[i]));
        }
        MasterProtos.MergeTableRegionsResponse response = (MasterProtos.MergeTableRegionsResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.MergeTableRegionsResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.MergeTableRegionsResponse rpcCall() throws Exception {
                MasterProtos.MergeTableRegionsRequest request = RequestConverter.buildMergeTableRegionsRequest(encodedNameofRegionsToMerge, forcible, this.nonceGroup, this.nonce);
                return this.master.mergeTableRegions(this.getRpcController(), request);
            }
        });
        return new MergeTableRegionsFuture(this, tableName, response);
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint) throws IOException {
        this.splitRegionSync(regionName, splitPoint, this.syncWaitTimeout, TimeUnit.MILLISECONDS);
    }

    public void splitRegionSync(byte[] regionName, byte[] splitPoint, long timeout, TimeUnit units) throws IOException {
        HBaseAdmin.get(this.splitRegionAsync(regionName, splitPoint), timeout, units);
    }

    @Override
    public Future<Void> splitRegionAsync(byte[] regionName, byte[] splitPoint) throws IOException {
        byte[] encodedNameofRegionToSplit = HRegionInfo.isEncodedRegionName(regionName) ? regionName : Bytes.toBytes(HRegionInfo.encodeRegionName(regionName));
        Pair<RegionInfo, ServerName> pair = this.getRegion(regionName);
        if (pair != null) {
            if (pair.getFirst() != null && pair.getFirst().getReplicaId() != 0) {
                throw new IllegalArgumentException("Can't invoke split on non-default regions directly");
            }
        } else {
            throw new UnknownRegionException("Can't invoke merge on unknown region " + Bytes.toStringBinary(encodedNameofRegionToSplit));
        }
        return this.splitRegionAsync(pair.getFirst(), splitPoint);
    }

    Future<Void> splitRegionAsync(final RegionInfo hri, final byte[] splitPoint) throws IOException {
        final TableName tableName = hri.getTable();
        if (hri.getStartKey() != null && splitPoint != null && Bytes.compareTo(hri.getStartKey(), splitPoint) == 0) {
            throw new IOException("should not give a splitkey which equals to startkey!");
        }
        MasterProtos.SplitTableRegionResponse response = (MasterProtos.SplitTableRegionResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.SplitTableRegionResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.SplitTableRegionResponse rpcCall() throws Exception {
                this.setPriority(tableName);
                MasterProtos.SplitTableRegionRequest request = RequestConverter.buildSplitTableRegionRequest(hri, splitPoint, this.nonceGroup, this.nonce);
                return this.master.splitRegion(this.getRpcController(), request);
            }
        });
        return new SplitTableRegionFuture(this, tableName, response);
    }

    @Override
    public void split(TableName tableName) throws IOException {
        this.split(tableName, null);
    }

    @Override
    public void splitRegion(byte[] regionName) throws IOException {
        this.splitRegion(regionName, null);
    }

    @Override
    public void split(TableName tableName, byte[] splitPoint) throws IOException {
        this.checkTableExists(tableName);
        for (HRegionLocation loc : this.connection.locateRegions(tableName, false, false)) {
            RegionInfo r;
            ServerName sn = loc.getServerName();
            if (sn == null || (r = loc.getRegion()).isSplitParent() || r.getReplicaId() != 0 || splitPoint != null && !r.containsRow(splitPoint)) continue;
            this.splitRegionAsync(r, splitPoint);
        }
    }

    @Override
    public void splitRegion(byte[] regionName, byte[] splitPoint) throws IOException {
        Pair<RegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getFirst() != null && regionServerPair.getFirst().getReplicaId() != 0) {
            throw new IllegalArgumentException("Can't split replicas directly. Replicas are auto-split when their primary is split.");
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        this.splitRegionAsync(regionServerPair.getFirst(), splitPoint);
    }

    Pair<RegionInfo, ServerName> getRegion(byte[] regionName) throws IOException {
        if (regionName == null) {
            throw new IllegalArgumentException("Pass a table name or region name");
        }
        Pair pair = MetaTableAccessor.getRegion(this.connection, regionName);
        if (pair == null) {
            final String encodedName = Bytes.toString(regionName);
            if (!RegionInfo.isMD5Hash(encodedName)) {
                return null;
            }
            final AtomicReference<Object> result = new AtomicReference<Object>(null);
            MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

                @Override
                public boolean visit(Result data) throws IOException {
                    RegionInfo info = MetaTableAccessor.getRegionInfo(data);
                    if (info == null) {
                        LOG.warn("No serialized HRegionInfo in " + data);
                        return true;
                    }
                    RegionLocations rl = MetaTableAccessor.getRegionLocations(data);
                    boolean matched = false;
                    ServerName sn = null;
                    if (rl != null) {
                        for (HRegionLocation h : rl.getRegionLocations()) {
                            if (h == null || !encodedName.equals(h.getRegionInfo().getEncodedName())) continue;
                            sn = h.getServerName();
                            info = h.getRegionInfo();
                            matched = true;
                        }
                    }
                    if (!matched) {
                        return true;
                    }
                    result.set(new Pair<RegionInfo, Object>(info, sn));
                    return false;
                }
            };
            MetaTableAccessor.fullScanRegions(this.connection, visitor);
            pair = result.get();
        }
        return pair;
    }

    private byte[] getRegionName(byte[] regionNameOrEncodedRegionName) throws IOException {
        if (Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getRegionName()) || Bytes.equals(regionNameOrEncodedRegionName, HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes())) {
            return HRegionInfo.FIRST_META_REGIONINFO.getRegionName();
        }
        byte[] tmp = regionNameOrEncodedRegionName;
        Pair<RegionInfo, ServerName> regionServerPair = this.getRegion(regionNameOrEncodedRegionName);
        if (regionServerPair != null && regionServerPair.getFirst() != null) {
            tmp = regionServerPair.getFirst().getRegionName();
        }
        return tmp;
    }

    private TableName checkTableExists(final TableName tableName) throws IOException {
        return (TableName)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<TableName>(){

            @Override
            protected TableName rpcCall(int callTimeout) throws Exception {
                if (MetaTableAccessor.getTableState(HBaseAdmin.this.getConnection(), tableName) == null) {
                    throw new TableNotFoundException(tableName);
                }
                return tableName;
            }
        });
    }

    @Override
    public synchronized void shutdown() throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(200);
                this.master.shutdown(this.getRpcController(), MasterProtos.ShutdownRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopMaster() throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.setPriority(200);
                this.master.stopMaster(this.getRpcController(), MasterProtos.StopMasterRequest.newBuilder().build());
                return null;
            }
        });
    }

    @Override
    public synchronized void stopRegionServer(String hostnamePort) throws IOException {
        String hostname = Addressing.parseHostname(hostnamePort);
        int port = Addressing.parsePort(hostnamePort);
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(ServerName.valueOf(hostname, port, 0L));
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        controller.setPriority(200);
        AdminProtos.StopServerRequest request = RequestConverter.buildStopServerRequest("Called by admin client " + this.connection.toString());
        try {
            admin.stopServer(controller, request);
        }
        catch (Exception e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    @Override
    public boolean isMasterInMaintenanceMode() throws IOException {
        return ((MasterProtos.IsInMaintenanceModeResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.IsInMaintenanceModeResponse>(this.getConnection(), this.rpcControllerFactory){

            @Override
            protected MasterProtos.IsInMaintenanceModeResponse rpcCall() throws Exception {
                return this.master.isMasterInMaintenanceMode(this.getRpcController(), MasterProtos.IsInMaintenanceModeRequest.newBuilder().build());
            }
        })).getInMaintenanceMode();
    }

    @Override
    public ClusterMetrics getClusterMetrics(final EnumSet<ClusterMetrics.Option> options) throws IOException {
        return (ClusterMetrics)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ClusterMetrics>(this.getConnection(), this.rpcControllerFactory){

            @Override
            protected ClusterMetrics rpcCall() throws Exception {
                MasterProtos.GetClusterStatusRequest req = RequestConverter.buildGetClusterStatusRequest(options);
                return ClusterMetricsBuilder.toClusterMetrics(this.master.getClusterStatus(this.getRpcController(), req).getClusterStatus());
            }
        });
    }

    @Override
    public List<RegionMetrics> getRegionMetrics(ServerName serverName, TableName tableName) throws IOException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(serverName);
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        AdminProtos.GetRegionLoadRequest request = RequestConverter.buildGetRegionLoadRequest(tableName);
        try {
            return admin.getRegionLoad(controller, request).getRegionLoadsList().stream().map(RegionMetricsBuilder::toRegionMetrics).collect(Collectors.toList());
        }
        catch (ServiceException se) {
            throw ProtobufUtil.getRemoteException(se);
        }
    }

    @Override
    public Configuration getConfiguration() {
        return this.conf;
    }

    private static <T> T get(Future<T> future, long timeout, TimeUnit units) throws IOException {
        try {
            return future.get(timeout, units);
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException("Interrupt while waiting on " + future);
            ioe.initCause(e);
            throw ioe;
        }
        catch (TimeoutException e) {
            throw new TimeoutIOException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new IOException(e.getCause());
        }
    }

    @Override
    public Future<Void> createNamespaceAsync(final NamespaceDescriptor descriptor) throws IOException {
        MasterProtos.CreateNamespaceResponse response = (MasterProtos.CreateNamespaceResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.CreateNamespaceResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.CreateNamespaceResponse rpcCall() throws Exception {
                return this.master.createNamespace(this.getRpcController(), MasterProtos.CreateNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
            }
        });
        return new NamespaceFuture(this, descriptor.getName(), response.getProcId()){

            @Override
            public String getOperationType() {
                return "CREATE_NAMESPACE";
            }
        };
    }

    @Override
    public Future<Void> modifyNamespaceAsync(final NamespaceDescriptor descriptor) throws IOException {
        MasterProtos.ModifyNamespaceResponse response = (MasterProtos.ModifyNamespaceResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.ModifyNamespaceResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.ModifyNamespaceResponse rpcCall() throws Exception {
                return this.master.modifyNamespace(this.getRpcController(), MasterProtos.ModifyNamespaceRequest.newBuilder().setNamespaceDescriptor(ProtobufUtil.toProtoNamespaceDescriptor(descriptor)).build());
            }
        });
        return new NamespaceFuture(this, descriptor.getName(), response.getProcId()){

            @Override
            public String getOperationType() {
                return "MODIFY_NAMESPACE";
            }
        };
    }

    @Override
    public Future<Void> deleteNamespaceAsync(final String name) throws IOException {
        MasterProtos.DeleteNamespaceResponse response = (MasterProtos.DeleteNamespaceResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.DeleteNamespaceResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.DeleteNamespaceResponse rpcCall() throws Exception {
                return this.master.deleteNamespace(this.getRpcController(), MasterProtos.DeleteNamespaceRequest.newBuilder().setNamespaceName(name).build());
            }
        });
        return new NamespaceFuture(this, name, response.getProcId()){

            @Override
            public String getOperationType() {
                return "DELETE_NAMESPACE";
            }
        };
    }

    @Override
    public NamespaceDescriptor getNamespaceDescriptor(final String name) throws NamespaceNotFoundException, IOException {
        return (NamespaceDescriptor)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<NamespaceDescriptor>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected NamespaceDescriptor rpcCall() throws Exception {
                return ProtobufUtil.toNamespaceDescriptor(this.master.getNamespaceDescriptor(this.getRpcController(), MasterProtos.GetNamespaceDescriptorRequest.newBuilder().setNamespaceName(name).build()).getNamespaceDescriptor());
            }
        });
    }

    @Override
    public String[] listNamespaces() throws IOException {
        return (String[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<String[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected String[] rpcCall() throws Exception {
                ProtocolStringList list = this.master.listNamespaces(this.getRpcController(), MasterProtos.ListNamespacesRequest.newBuilder().build()).getNamespaceNameList();
                return list.toArray(new String[list.size()]);
            }
        });
    }

    @Override
    public NamespaceDescriptor[] listNamespaceDescriptors() throws IOException {
        return (NamespaceDescriptor[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<NamespaceDescriptor[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected NamespaceDescriptor[] rpcCall() throws Exception {
                List<HBaseProtos.NamespaceDescriptor> list = this.master.listNamespaceDescriptors(this.getRpcController(), MasterProtos.ListNamespaceDescriptorsRequest.newBuilder().build()).getNamespaceDescriptorList();
                NamespaceDescriptor[] res = new NamespaceDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = ProtobufUtil.toNamespaceDescriptor(list.get(i));
                }
                return res;
            }
        });
    }

    @Override
    public String getProcedures() throws IOException {
        return (String)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<String>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected String rpcCall() throws Exception {
                MasterProtos.GetProceduresRequest request = MasterProtos.GetProceduresRequest.newBuilder().build();
                MasterProtos.GetProceduresResponse response = this.master.getProcedures(this.getRpcController(), request);
                return ProtobufUtil.toProcedureJson(response.getProcedureList());
            }
        });
    }

    @Override
    public String getLocks() throws IOException {
        return (String)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<String>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected String rpcCall() throws Exception {
                MasterProtos.GetLocksRequest request = MasterProtos.GetLocksRequest.newBuilder().build();
                MasterProtos.GetLocksResponse response = this.master.getLocks(this.getRpcController(), request);
                return ProtobufUtil.toLockJson(response.getLockList());
            }
        });
    }

    @Override
    public HTableDescriptor[] listTableDescriptorsByNamespace(final String name) throws IOException {
        return (HTableDescriptor[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<HTableDescriptor[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected HTableDescriptor[] rpcCall() throws Exception {
                List<HBaseProtos.TableSchema> list = this.master.listTableDescriptorsByNamespace(this.getRpcController(), MasterProtos.ListTableDescriptorsByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableSchemaList();
                HTableDescriptor[] res = new HTableDescriptor[list.size()];
                for (int i = 0; i < list.size(); ++i) {
                    res[i] = new ImmutableHTableDescriptor(ProtobufUtil.toTableDescriptor(list.get(i)));
                }
                return res;
            }
        });
    }

    @Override
    public TableName[] listTableNamesByNamespace(final String name) throws IOException {
        return (TableName[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<TableName[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected TableName[] rpcCall() throws Exception {
                List<HBaseProtos.TableName> tableNames = this.master.listTableNamesByNamespace(this.getRpcController(), MasterProtos.ListTableNamesByNamespaceRequest.newBuilder().setNamespaceName(name).build()).getTableNameList();
                TableName[] result = new TableName[tableNames.size()];
                for (int i = 0; i < tableNames.size(); ++i) {
                    result[i] = ProtobufUtil.toTableName(tableNames.get(i));
                }
                return result;
            }
        });
    }

    public static void available(Configuration conf) throws MasterNotRunningException, ZooKeeperConnectionException, IOException {
        Configuration copyOfConf = HBaseConfiguration.create(conf);
        copyOfConf.setInt("hbase.client.retries.number", 1);
        copyOfConf.setInt("zookeeper.recovery.retry", 0);
        try (ClusterConnection connection = (ClusterConnection)ConnectionFactory.createConnection(copyOfConf);){
            connection.isMasterRunning();
        }
    }

    @Override
    @Deprecated
    public List<HRegionInfo> getTableRegions(TableName tableName) throws IOException {
        return this.getRegions(tableName).stream().map(ImmutableHRegionInfo::new).collect(Collectors.toList());
    }

    @Override
    public synchronized void close() throws IOException {
    }

    @Override
    public HTableDescriptor[] getTableDescriptorsByTableName(final List<TableName> tableNames) throws IOException {
        return (HTableDescriptor[])this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<HTableDescriptor[]>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected HTableDescriptor[] rpcCall() throws Exception {
                MasterProtos.GetTableDescriptorsRequest req = RequestConverter.buildGetTableDescriptorsRequest(tableNames);
                return (HTableDescriptor[])ProtobufUtil.toTableDescriptorList(this.master.getTableDescriptors(this.getRpcController(), req)).stream().map(ImmutableHTableDescriptor::new).toArray(HTableDescriptor[]::new);
            }
        });
    }

    @Override
    public HTableDescriptor[] getTableDescriptors(List<String> names) throws IOException {
        ArrayList<TableName> tableNames = new ArrayList<TableName>(names.size());
        for (String name : names) {
            tableNames.add(TableName.valueOf(name));
        }
        return this.getTableDescriptorsByTableName(tableNames);
    }

    private AdminProtos.RollWALWriterResponse rollWALWriterImpl(ServerName sn) throws IOException, FailedLogCloseException {
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        AdminProtos.RollWALWriterRequest request = RequestConverter.buildRollWALWriterRequest();
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        try {
            return admin.rollWALWriter(controller, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
    }

    @Override
    public synchronized void rollWALWriter(ServerName serverName) throws IOException, FailedLogCloseException {
        this.rollWALWriterImpl(serverName);
    }

    @Override
    public CompactionState getCompactionState(TableName tableName) throws IOException {
        return this.getCompactionState(tableName, CompactType.NORMAL);
    }

    @Override
    public CompactionState getCompactionStateForRegion(byte[] regionName) throws IOException {
        AdminProtos.GetRegionInfoResponse response;
        Pair<RegionInfo, ServerName> regionServerPair = this.getRegion(regionName);
        if (regionServerPair == null) {
            throw new IllegalArgumentException("Invalid region: " + Bytes.toStringBinary(regionName));
        }
        if (regionServerPair.getSecond() == null) {
            throw new NoServerForRegionException(Bytes.toStringBinary(regionName));
        }
        ServerName sn = regionServerPair.getSecond();
        AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        HBaseRpcController controller = this.rpcControllerFactory.newController();
        AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(regionServerPair.getFirst().getRegionName(), true);
        try {
            response = admin.getRegionInfo(controller, request);
        }
        catch (ServiceException e) {
            throw ProtobufUtil.handleRemoteException(e);
        }
        if (response.getCompactionState() != null) {
            return ProtobufUtil.createCompactionState(response.getCompactionState());
        }
        return null;
    }

    @Override
    public void snapshot(SnapshotDescription snapshotDesc) throws IOException, SnapshotCreationException, IllegalArgumentException {
        SnapshotProtos.SnapshotDescription snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc(snapshotDesc);
        MasterProtos.SnapshotResponse response = this.asyncSnapshot(snapshot);
        final MasterProtos.IsSnapshotDoneRequest request = MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build();
        MasterProtos.IsSnapshotDoneResponse done = null;
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug("Waiting a max of " + max + " ms for snapshot '" + ClientSnapshotDescriptionUtils.toString(snapshot) + "'' to complete. (max " + maxPauseTime + " ms per retry)");
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done.getDone()) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for snapshot completion.");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug("Getting current status of snapshot from master...");
            done = (MasterProtos.IsSnapshotDoneResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection(), this.getRpcControllerFactory()){

                @Override
                protected MasterProtos.IsSnapshotDoneResponse rpcCall() throws Exception {
                    return this.master.isSnapshotDone(this.getRpcController(), request);
                }
            });
        }
        if (!done.getDone()) {
            throw new SnapshotCreationException("Snapshot '" + snapshot.getName() + "' wasn't completed in expectedTime:" + max + " ms", snapshotDesc);
        }
    }

    @Override
    public Future<Void> snapshotAsync(final SnapshotDescription snapshotDesc) throws IOException, SnapshotCreationException {
        this.asyncSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshotDesc));
        return new ProcedureFuture<Void>(this, null){

            @Override
            protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
                this.waitForState(deadlineTs, new ProcedureFuture.WaitForStateCallable(){

                    @Override
                    public void throwInterruptedException() throws InterruptedIOException {
                        throw new InterruptedIOException("Interrupted while waiting for taking snapshot" + snapshotDesc);
                    }

                    @Override
                    public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                        throw new TimeoutException("Snapshot '" + snapshotDesc.getName() + "' wasn't completed in expectedTime:" + elapsedTime + " ms");
                    }

                    @Override
                    public boolean checkState(int tries) throws IOException {
                        return HBaseAdmin.this.isSnapshotFinished(snapshotDesc);
                    }
                });
                return null;
            }
        };
    }

    private MasterProtos.SnapshotResponse asyncSnapshot(SnapshotProtos.SnapshotDescription snapshot) throws IOException {
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        final MasterProtos.SnapshotRequest request = MasterProtos.SnapshotRequest.newBuilder().setSnapshot(snapshot).build();
        return (MasterProtos.SnapshotResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.SnapshotResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.SnapshotResponse rpcCall() throws Exception {
                return this.master.snapshot(this.getRpcController(), request);
            }
        });
    }

    @Override
    public boolean isSnapshotFinished(SnapshotDescription snapshotDesc) throws IOException, HBaseSnapshotException, UnknownSnapshotException {
        final SnapshotProtos.SnapshotDescription snapshot = ProtobufUtil.createHBaseProtosSnapshotDesc(snapshotDesc);
        return ((MasterProtos.IsSnapshotDoneResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.IsSnapshotDoneResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.IsSnapshotDoneResponse rpcCall() throws Exception {
                return this.master.isSnapshotDone(this.getRpcController(), MasterProtos.IsSnapshotDoneRequest.newBuilder().setSnapshot(snapshot).build());
            }
        })).getDone();
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString(snapshotName));
    }

    @Override
    public void restoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        boolean takeFailSafeSnapshot = this.conf.getBoolean("hbase.snapshot.restore.take.failsafe.snapshot", true);
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot);
    }

    @Override
    public void restoreSnapshot(byte[] snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(Bytes.toString(snapshotName), takeFailSafeSnapshot);
    }

    private TableName getTableNameBeforeRestoreSnapshot(String snapshotName) throws IOException, RestoreSnapshotException {
        TableName tableName = null;
        for (SnapshotDescription snapshotInfo : this.listSnapshots()) {
            if (!snapshotInfo.getName().equals(snapshotName)) continue;
            tableName = snapshotInfo.getTableName();
            break;
        }
        if (tableName == null) {
            throw new RestoreSnapshotException("Unable to find the table name for snapshot=" + snapshotName);
        }
        return tableName;
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot) throws IOException, RestoreSnapshotException {
        this.restoreSnapshot(snapshotName, takeFailSafeSnapshot, false);
    }

    @Override
    public void restoreSnapshot(String snapshotName, boolean takeFailSafeSnapshot, boolean restoreAcl) throws IOException, RestoreSnapshotException {
        TableName tableName = this.getTableNameBeforeRestoreSnapshot(snapshotName);
        if (!this.tableExists(tableName)) {
            this.cloneSnapshot(snapshotName, tableName, restoreAcl);
            return;
        }
        if (!this.isTableDisabled(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
        String failSafeSnapshotSnapshotName = null;
        if (takeFailSafeSnapshot) {
            failSafeSnapshotSnapshotName = this.conf.get("hbase.snapshot.restore.failsafe.name", "hbase-failsafe-{snapshot.name}-{restore.timestamp}");
            failSafeSnapshotSnapshotName = failSafeSnapshotSnapshotName.replace("{snapshot.name}", snapshotName).replace("{table.name}", tableName.toString().replace(':', '.')).replace("{restore.timestamp}", String.valueOf(EnvironmentEdgeManager.currentTime()));
            LOG.info("Taking restore-failsafe snapshot: " + failSafeSnapshotSnapshotName);
            this.snapshot(failSafeSnapshotSnapshotName, tableName);
        }
        try {
            HBaseAdmin.get(this.internalRestoreSnapshotAsync(snapshotName, tableName, restoreAcl), this.syncWaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (IOException e) {
            if (takeFailSafeSnapshot) {
                try {
                    HBaseAdmin.get(this.internalRestoreSnapshotAsync(failSafeSnapshotSnapshotName, tableName, restoreAcl), this.syncWaitTimeout, TimeUnit.MILLISECONDS);
                    String msg = "Restore snapshot=" + snapshotName + " failed. Rollback to snapshot=" + failSafeSnapshotSnapshotName + " succeeded.";
                    LOG.error(msg, e);
                    throw new RestoreSnapshotException(msg, e);
                }
                catch (IOException ex) {
                    String msg = "Failed to restore and rollback to snapshot=" + failSafeSnapshotSnapshotName;
                    LOG.error(msg, ex);
                    throw new RestoreSnapshotException(msg, e);
                }
            }
            throw new RestoreSnapshotException("Failed to restore snapshot=" + snapshotName, e);
        }
        if (takeFailSafeSnapshot) {
            try {
                LOG.info("Deleting restore-failsafe snapshot: " + failSafeSnapshotSnapshotName);
                this.deleteSnapshot(failSafeSnapshotSnapshotName);
            }
            catch (IOException e) {
                LOG.error("Unable to remove the failsafe snapshot: " + failSafeSnapshotSnapshotName, e);
            }
        }
    }

    @Override
    public Future<Void> restoreSnapshotAsync(String snapshotName) throws IOException, RestoreSnapshotException {
        TableName tableName = this.getTableNameBeforeRestoreSnapshot(snapshotName);
        if (!this.tableExists(tableName)) {
            return this.cloneSnapshotAsync(snapshotName, tableName);
        }
        if (!this.isTableDisabled(tableName)) {
            throw new TableNotDisabledException(tableName);
        }
        return this.internalRestoreSnapshotAsync(snapshotName, tableName, false);
    }

    @Override
    public Future<Void> cloneSnapshotAsync(String snapshotName, TableName tableName, boolean restoreAcl) throws IOException, TableExistsException, RestoreSnapshotException {
        if (this.tableExists(tableName)) {
            throw new TableExistsException(tableName);
        }
        return this.internalRestoreSnapshotAsync(snapshotName, tableName, restoreAcl);
    }

    @Override
    public byte[] execProcedureWithReturn(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription desc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(desc).build();
        MasterProtos.ExecProcedureResponse response = (MasterProtos.ExecProcedureResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.ExecProcedureResponse rpcCall() throws Exception {
                return this.master.execProcedureWithRet(this.getRpcController(), request);
            }
        });
        return response.hasReturnData() ? response.getReturnData().toByteArray() : null;
    }

    @Override
    public void execProcedure(String signature, String instance, Map<String, String> props) throws IOException {
        HBaseProtos.ProcedureDescription desc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        final MasterProtos.ExecProcedureRequest request = MasterProtos.ExecProcedureRequest.newBuilder().setProcedure(desc).build();
        MasterProtos.ExecProcedureResponse response = (MasterProtos.ExecProcedureResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.ExecProcedureResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.ExecProcedureResponse rpcCall() throws Exception {
                return this.master.execProcedure(this.getRpcController(), request);
            }
        });
        long start = EnvironmentEdgeManager.currentTime();
        long max = response.getExpectedTimeout();
        long maxPauseTime = max / (long)this.numRetries;
        int tries = 0;
        LOG.debug("Waiting a max of " + max + " ms for procedure '" + signature + " : " + instance + "'' to complete. (max " + maxPauseTime + " ms per retry)");
        boolean done = false;
        while (tries == 0 || EnvironmentEdgeManager.currentTime() - start < max && !done) {
            try {
                long sleep = this.getPauseTime(tries++);
                sleep = sleep > maxPauseTime ? maxPauseTime : sleep;
                LOG.debug("(#" + tries + ") Sleeping: " + sleep + "ms while waiting for procedure completion.");
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException("Interrupted").initCause(e);
            }
            LOG.debug("Getting current status of procedure from master...");
            done = this.isProcedureFinished(signature, instance, props);
        }
        if (!done) {
            throw new IOException("Procedure '" + signature + " : " + instance + "' wasn't completed in expectedTime:" + max + " ms");
        }
    }

    @Override
    public boolean isProcedureFinished(String signature, String instance, Map<String, String> props) throws IOException {
        final HBaseProtos.ProcedureDescription desc = ProtobufUtil.buildProcedureDescription(signature, instance, props);
        return ((MasterProtos.IsProcedureDoneResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.IsProcedureDoneResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected MasterProtos.IsProcedureDoneResponse rpcCall() throws Exception {
                return this.master.isProcedureDone(this.getRpcController(), MasterProtos.IsProcedureDoneRequest.newBuilder().setProcedure(desc).build());
            }
        })).getDone();
    }

    private Future<Void> internalRestoreSnapshotAsync(String snapshotName, TableName tableName, final boolean restoreAcl) throws IOException, RestoreSnapshotException {
        final SnapshotProtos.SnapshotDescription snapshot = SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).setTable(tableName.getNameAsString()).build();
        ClientSnapshotDescriptionUtils.assertSnapshotRequestIsValid(snapshot);
        MasterProtos.RestoreSnapshotResponse response = (MasterProtos.RestoreSnapshotResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<MasterProtos.RestoreSnapshotResponse>(this.getConnection(), this.getRpcControllerFactory()){
            Long nonceGroup;
            Long nonce;
            {
                super(connection, rpcConnectionFactory);
                this.nonceGroup = HBaseAdmin.this.ng.getNonceGroup();
                this.nonce = HBaseAdmin.this.ng.newNonce();
            }

            @Override
            protected MasterProtos.RestoreSnapshotResponse rpcCall() throws Exception {
                MasterProtos.RestoreSnapshotRequest request = MasterProtos.RestoreSnapshotRequest.newBuilder().setSnapshot(snapshot).setNonceGroup(this.nonceGroup).setNonce(this.nonce).setRestoreACL(restoreAcl).build();
                return this.master.restoreSnapshot(this.getRpcController(), request);
            }
        });
        return new RestoreSnapshotFuture(this, snapshot, tableName, response);
    }

    @Override
    public List<SnapshotDescription> listSnapshots() throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<SnapshotDescription>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<SnapshotDescription> rpcCall() throws Exception {
                List<SnapshotProtos.SnapshotDescription> snapshotsList = this.master.getCompletedSnapshots(this.getRpcController(), MasterProtos.GetCompletedSnapshotsRequest.newBuilder().build()).getSnapshotsList();
                ArrayList<SnapshotDescription> result = new ArrayList<SnapshotDescription>(snapshotsList.size());
                for (SnapshotProtos.SnapshotDescription snapshot : snapshotsList) {
                    result.add(ProtobufUtil.createSnapshotDesc(snapshot));
                }
                return result;
            }
        });
    }

    @Override
    public List<SnapshotDescription> listSnapshots(String regex) throws IOException {
        return this.listSnapshots(Pattern.compile(regex));
    }

    @Override
    public List<SnapshotDescription> listSnapshots(Pattern pattern) throws IOException {
        LinkedList<SnapshotDescription> matched = new LinkedList<SnapshotDescription>();
        List<SnapshotDescription> snapshots = this.listSnapshots();
        for (SnapshotDescription snapshot : snapshots) {
            if (!pattern.matcher(snapshot.getName()).matches()) continue;
            matched.add(snapshot);
        }
        return matched;
    }

    @Override
    public List<SnapshotDescription> listTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        return this.listTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public List<SnapshotDescription> listTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        TableName[] tableNames = this.listTableNames(tableNamePattern);
        LinkedList<SnapshotDescription> tableSnapshots = new LinkedList<SnapshotDescription>();
        List<SnapshotDescription> snapshots = this.listSnapshots(snapshotNamePattern);
        List<TableName> listOfTableNames = Arrays.asList(tableNames);
        for (SnapshotDescription snapshot : snapshots) {
            if (!listOfTableNames.contains(snapshot.getTableName())) continue;
            tableSnapshots.add(snapshot);
        }
        return tableSnapshots;
    }

    @Override
    public void deleteSnapshot(byte[] snapshotName) throws IOException {
        this.deleteSnapshot(Bytes.toString(snapshotName));
    }

    @Override
    public void deleteSnapshot(final String snapshotName) throws IOException {
        TableName.isLegalFullyQualifiedTableName(Bytes.toBytes(snapshotName));
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.master.deleteSnapshot(this.getRpcController(), MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(SnapshotProtos.SnapshotDescription.newBuilder().setName(snapshotName).build()).build());
                return null;
            }
        });
    }

    @Override
    public void deleteSnapshots(String regex) throws IOException {
        this.deleteSnapshots(Pattern.compile(regex));
    }

    @Override
    public void deleteSnapshots(Pattern pattern) throws IOException {
        List<SnapshotDescription> snapshots = this.listSnapshots(pattern);
        for (SnapshotDescription snapshot : snapshots) {
            try {
                this.internalDeleteSnapshot(snapshot);
            }
            catch (IOException ex) {
                LOG.info("Failed to delete snapshot " + snapshot.getName() + " for table " + snapshot.getTableNameAsString(), ex);
            }
        }
    }

    private void internalDeleteSnapshot(final SnapshotDescription snapshot) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.master.deleteSnapshot(this.getRpcController(), MasterProtos.DeleteSnapshotRequest.newBuilder().setSnapshot(ProtobufUtil.createHBaseProtosSnapshotDesc(snapshot)).build());
                return null;
            }
        });
    }

    @Override
    public void deleteTableSnapshots(String tableNameRegex, String snapshotNameRegex) throws IOException {
        this.deleteTableSnapshots(Pattern.compile(tableNameRegex), Pattern.compile(snapshotNameRegex));
    }

    @Override
    public void deleteTableSnapshots(Pattern tableNamePattern, Pattern snapshotNamePattern) throws IOException {
        List<SnapshotDescription> snapshots = this.listTableSnapshots(tableNamePattern, snapshotNamePattern);
        for (SnapshotDescription snapshot : snapshots) {
            try {
                this.internalDeleteSnapshot(snapshot);
                LOG.debug("Successfully deleted snapshot: " + snapshot.getName());
            }
            catch (IOException e) {
                LOG.error("Failed to delete snapshot: " + snapshot.getName(), e);
            }
        }
    }

    @Override
    public void setQuota(final QuotaSettings quota) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                this.master.setQuota(this.getRpcController(), QuotaSettings.buildSetQuotaRequestProto(quota));
                return null;
            }
        });
    }

    @Override
    public QuotaRetriever getQuotaRetriever(QuotaFilter filter) throws IOException {
        return QuotaRetriever.open(this.conf, filter);
    }

    @Override
    public List<QuotaSettings> getQuota(QuotaFilter filter) throws IOException {
        LinkedList<QuotaSettings> quotas = new LinkedList<QuotaSettings>();
        try (QuotaRetriever retriever = QuotaRetriever.open(this.conf, filter);){
            Iterator<QuotaSettings> iterator = retriever.iterator();
            while (iterator.hasNext()) {
                quotas.add(iterator.next());
            }
        }
        return quotas;
    }

    private <C extends RetryingCallable<V> & Closeable, V> V executeCallable(C callable) throws IOException {
        return HBaseAdmin.executeCallable(callable, this.rpcCallerFactory, this.operationTimeout, this.rpcTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <C extends RetryingCallable<V> & Closeable, V> V executeCallable(C callable, RpcRetryingCallerFactory rpcCallerFactory, int operationTimeout, int rpcTimeout) throws IOException {
        RpcRetryingCaller caller = rpcCallerFactory.newCaller(rpcTimeout);
        try {
            Object t = caller.callWithRetries(callable, operationTimeout);
            return (V)t;
        }
        finally {
            ((Closeable)callable).close();
        }
    }

    @Override
    public CoprocessorRpcChannel coprocessorService() {
        return new SyncCoprocessorRpcChannel(){

            @Override
            protected Message callExecService(RpcController controller, final Descriptors.MethodDescriptor method, final Message request, Message responsePrototype) throws IOException {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Call: " + method.getName() + ", " + request.toString());
                }
                try (MasterCallable<ClientProtos.CoprocessorServiceResponse> callable = new MasterCallable<ClientProtos.CoprocessorServiceResponse>((Connection)HBaseAdmin.this.connection, HBaseAdmin.this.connection.getRpcControllerFactory()){

                    @Override
                    protected ClientProtos.CoprocessorServiceResponse rpcCall() throws Exception {
                        ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request);
                        return this.master.execMasterService(this.getRpcController(), csr);
                    }
                };){
                    callable.prepare(false);
                    int operationTimeout = HBaseAdmin.this.connection.getConnectionConfiguration().getOperationTimeout();
                    ClientProtos.CoprocessorServiceResponse result = (ClientProtos.CoprocessorServiceResponse)callable.call(operationTimeout);
                    Message message = CoprocessorRpcUtils.getResponse(result, responsePrototype);
                    return message;
                }
            }
        };
    }

    @Override
    public CoprocessorRpcChannel coprocessorService(final ServerName serverName) {
        return new SyncCoprocessorRpcChannel(){

            @Override
            protected Message callExecService(RpcController controller, Descriptors.MethodDescriptor method, Message request, Message responsePrototype) throws IOException {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Call: " + method.getName() + ", " + request.toString());
                }
                ClientProtos.CoprocessorServiceRequest csr = CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request);
                ClientProtos.ClientService.BlockingInterface stub = HBaseAdmin.this.connection.getClient(serverName);
                try {
                    ClientProtos.CoprocessorServiceResponse result = stub.execRegionServerService(HBaseAdmin.this.connection.getRpcControllerFactory().newController(), csr);
                    return CoprocessorRpcUtils.getResponse(result, responsePrototype);
                }
                catch (ServiceException e) {
                    throw ProtobufUtil.handleRemoteException(e);
                }
            }
        };
    }

    @Override
    public void updateConfiguration(ServerName server) throws IOException {
        final AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(server);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                admin.updateConfiguration(null, AdminProtos.UpdateConfigurationRequest.getDefaultInstance());
                return null;
            }
        };
        ProtobufUtil.call(callable);
    }

    @Override
    public void updateConfiguration() throws IOException {
        ClusterMetrics status = this.getClusterMetrics(EnumSet.of(ClusterMetrics.Option.LIVE_SERVERS, ClusterMetrics.Option.MASTER, ClusterMetrics.Option.BACKUP_MASTERS));
        for (ServerName server : status.getLiveServerMetrics().keySet()) {
            this.updateConfiguration(server);
        }
        this.updateConfiguration(status.getMasterName());
        for (ServerName server : status.getBackupMasterNames()) {
            this.updateConfiguration(server);
        }
    }

    @Override
    public long getLastMajorCompactionTimestamp(final TableName tableName) throws IOException {
        return (Long)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Long>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Long rpcCall() throws Exception {
                MasterProtos.MajorCompactionTimestampRequest req = MasterProtos.MajorCompactionTimestampRequest.newBuilder().setTableName(ProtobufUtil.toProtoTableName(tableName)).build();
                return this.master.getLastMajorCompactionTimestamp(this.getRpcController(), req).getCompactionTimestamp();
            }
        });
    }

    @Override
    public long getLastMajorCompactionTimestampForRegion(final byte[] regionName) throws IOException {
        return (Long)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Long>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Long rpcCall() throws Exception {
                MasterProtos.MajorCompactionTimestampForRegionRequest req = MasterProtos.MajorCompactionTimestampForRegionRequest.newBuilder().setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).build();
                return this.master.getLastMajorCompactionTimestampForRegion(this.getRpcController(), req).getCompactionTimestamp();
            }
        });
    }

    @Override
    public void compact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.compact(tableName, columnFamily, false, compactType);
    }

    @Override
    public void compact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.compact(tableName, null, false, compactType);
    }

    @Override
    public void majorCompact(TableName tableName, byte[] columnFamily, CompactType compactType) throws IOException, InterruptedException {
        this.compact(tableName, columnFamily, true, compactType);
    }

    @Override
    public void majorCompact(TableName tableName, CompactType compactType) throws IOException, InterruptedException {
        this.compact(tableName, null, true, compactType);
    }

    @Override
    public CompactionState getCompactionState(final TableName tableName, CompactType compactType) throws IOException {
        this.checkTableExists(tableName);
        if (!this.isTableEnabled(tableName)) {
            return ProtobufUtil.createCompactionState(AdminProtos.GetRegionInfoResponse.CompactionState.NONE);
        }
        AdminProtos.GetRegionInfoResponse.CompactionState state = AdminProtos.GetRegionInfoResponse.CompactionState.NONE;
        final HBaseRpcController rpcController = this.rpcControllerFactory.newController();
        switch (compactType) {
            case MOB: {
                final AdminProtos.AdminService.BlockingInterface masterAdmin = this.connection.getAdminForMaster();
                Callable<AdminProtos.GetRegionInfoResponse.CompactionState> callable = new Callable<AdminProtos.GetRegionInfoResponse.CompactionState>(){

                    @Override
                    public AdminProtos.GetRegionInfoResponse.CompactionState call() throws Exception {
                        RegionInfo info = RegionInfo.createMobRegionInfo(tableName);
                        AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(info.getRegionName(), true);
                        AdminProtos.GetRegionInfoResponse response = masterAdmin.getRegionInfo(rpcController, request);
                        return response.getCompactionState();
                    }
                };
                state = ProtobufUtil.call(callable);
                break;
            }
            case NORMAL: {
                for (HRegionLocation loc : this.connection.locateRegions(tableName, false, false)) {
                    ServerName sn = loc.getServerName();
                    if (sn == null) continue;
                    final byte[] regionName = loc.getRegion().getRegionName();
                    final AdminProtos.AdminService.BlockingInterface snAdmin = this.connection.getAdmin(sn);
                    try {
                        Callable<AdminProtos.GetRegionInfoResponse> regionInfoCallable = new Callable<AdminProtos.GetRegionInfoResponse>(){

                            @Override
                            public AdminProtos.GetRegionInfoResponse call() throws Exception {
                                AdminProtos.GetRegionInfoRequest request = RequestConverter.buildGetRegionInfoRequest(regionName, true);
                                return snAdmin.getRegionInfo(rpcController, request);
                            }
                        };
                        AdminProtos.GetRegionInfoResponse response = ProtobufUtil.call(regionInfoCallable);
                        switch (response.getCompactionState()) {
                            case MAJOR_AND_MINOR: {
                                return CompactionState.MAJOR_AND_MINOR;
                            }
                            case MAJOR: {
                                if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MINOR) {
                                    return CompactionState.MAJOR_AND_MINOR;
                                }
                                state = AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR;
                                break;
                            }
                            case MINOR: {
                                if (state == AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) {
                                    return CompactionState.MAJOR_AND_MINOR;
                                }
                                state = AdminProtos.GetRegionInfoResponse.CompactionState.MINOR;
                                break;
                            }
                        }
                    }
                    catch (NotServingRegionException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug("Trying to get compaction state of " + loc.getRegion() + ": " + StringUtils.stringifyException((Throwable)e));
                    }
                    catch (RemoteException e) {
                        if (e.getMessage().indexOf(NotServingRegionException.class.getName()) >= 0) {
                            if (!LOG.isDebugEnabled()) continue;
                            LOG.debug("Trying to get compaction state of " + loc.getRegion() + ": " + StringUtils.stringifyException((Throwable)e));
                            continue;
                        }
                        throw e;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown compactType: " + (Object)((Object)compactType));
            }
        }
        if (state != null) {
            return ProtobufUtil.createCompactionState(state);
        }
        return null;
    }

    @Override
    public List<SecurityCapability> getSecurityCapabilities() throws IOException {
        try {
            return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<SecurityCapability>>(this.getConnection(), this.getRpcControllerFactory()){

                @Override
                protected List<SecurityCapability> rpcCall() throws Exception {
                    MasterProtos.SecurityCapabilitiesRequest req = MasterProtos.SecurityCapabilitiesRequest.newBuilder().build();
                    return ProtobufUtil.toSecurityCapabilityList(this.master.getSecurityCapabilities(this.getRpcController(), req).getCapabilitiesList());
                }
            });
        }
        catch (IOException e) {
            if (e instanceof RemoteException) {
                e = ((RemoteException)((Object)e)).unwrapRemoteException();
            }
            throw e;
        }
    }

    @Override
    public boolean splitSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.splitOrMergeSwitch(enabled, synchronous, MasterSwitchType.SPLIT);
    }

    @Override
    public boolean mergeSwitch(boolean enabled, boolean synchronous) throws IOException {
        return this.splitOrMergeSwitch(enabled, synchronous, MasterSwitchType.MERGE);
    }

    private boolean splitOrMergeSwitch(final boolean enabled, final boolean synchronous, final MasterSwitchType switchType) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                MasterProtos.SetSplitOrMergeEnabledResponse response = this.master.setSplitOrMergeEnabled(this.getRpcController(), RequestConverter.buildSetSplitOrMergeEnabledRequest(enabled, synchronous, switchType));
                return response.getPrevValueList().get(0);
            }
        });
    }

    @Override
    public boolean isSplitEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isSplitOrMergeEnabled(this.getRpcController(), RequestConverter.buildIsSplitOrMergeEnabledRequest(MasterSwitchType.SPLIT)).getEnabled();
            }
        });
    }

    @Override
    public boolean isMergeEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isSplitOrMergeEnabled(this.getRpcController(), RequestConverter.buildIsSplitOrMergeEnabledRequest(MasterSwitchType.MERGE)).getEnabled();
            }
        });
    }

    private RpcControllerFactory getRpcControllerFactory() {
        return this.rpcControllerFactory;
    }

    @Override
    public Future<Void> addReplicationPeerAsync(final String peerId, final ReplicationPeerConfig peerConfig, final boolean enabled) throws IOException {
        ReplicationProtos.AddReplicationPeerResponse response = (ReplicationProtos.AddReplicationPeerResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationProtos.AddReplicationPeerResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationProtos.AddReplicationPeerResponse rpcCall() throws Exception {
                return this.master.addReplicationPeer(this.getRpcController(), RequestConverter.buildAddReplicationPeerRequest(peerId, peerConfig, enabled));
            }
        });
        return new ReplicationFuture(this, peerId, response.getProcId(), () -> "ADD_REPLICATION_PEER");
    }

    @Override
    public Future<Void> removeReplicationPeerAsync(final String peerId) throws IOException {
        ReplicationProtos.RemoveReplicationPeerResponse response = (ReplicationProtos.RemoveReplicationPeerResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationProtos.RemoveReplicationPeerResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationProtos.RemoveReplicationPeerResponse rpcCall() throws Exception {
                return this.master.removeReplicationPeer(this.getRpcController(), RequestConverter.buildRemoveReplicationPeerRequest(peerId));
            }
        });
        return new ReplicationFuture(this, peerId, response.getProcId(), () -> "REMOVE_REPLICATION_PEER");
    }

    @Override
    public Future<Void> enableReplicationPeerAsync(final String peerId) throws IOException {
        ReplicationProtos.EnableReplicationPeerResponse response = (ReplicationProtos.EnableReplicationPeerResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationProtos.EnableReplicationPeerResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationProtos.EnableReplicationPeerResponse rpcCall() throws Exception {
                return this.master.enableReplicationPeer(this.getRpcController(), RequestConverter.buildEnableReplicationPeerRequest(peerId));
            }
        });
        return new ReplicationFuture(this, peerId, response.getProcId(), () -> "ENABLE_REPLICATION_PEER");
    }

    @Override
    public Future<Void> disableReplicationPeerAsync(final String peerId) throws IOException {
        ReplicationProtos.DisableReplicationPeerResponse response = (ReplicationProtos.DisableReplicationPeerResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationProtos.DisableReplicationPeerResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationProtos.DisableReplicationPeerResponse rpcCall() throws Exception {
                return this.master.disableReplicationPeer(this.getRpcController(), RequestConverter.buildDisableReplicationPeerRequest(peerId));
            }
        });
        return new ReplicationFuture(this, peerId, response.getProcId(), () -> "DISABLE_REPLICATION_PEER");
    }

    @Override
    public ReplicationPeerConfig getReplicationPeerConfig(final String peerId) throws IOException {
        return (ReplicationPeerConfig)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationPeerConfig>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationPeerConfig rpcCall() throws Exception {
                ReplicationProtos.GetReplicationPeerConfigResponse response = this.master.getReplicationPeerConfig(this.getRpcController(), RequestConverter.buildGetReplicationPeerConfigRequest(peerId));
                return ReplicationPeerConfigUtil.convert(response.getPeerConfig());
            }
        });
    }

    @Override
    public Future<Void> updateReplicationPeerConfigAsync(final String peerId, final ReplicationPeerConfig peerConfig) throws IOException {
        ReplicationProtos.UpdateReplicationPeerConfigResponse response = (ReplicationProtos.UpdateReplicationPeerConfigResponse)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<ReplicationProtos.UpdateReplicationPeerConfigResponse>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected ReplicationProtos.UpdateReplicationPeerConfigResponse rpcCall() throws Exception {
                return this.master.updateReplicationPeerConfig(this.getRpcController(), RequestConverter.buildUpdateReplicationPeerConfigRequest(peerId, peerConfig));
            }
        });
        return new ReplicationFuture(this, peerId, response.getProcId(), () -> "UPDATE_REPLICATION_PEER_CONFIG");
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers() throws IOException {
        return this.listReplicationPeers(null);
    }

    @Override
    public List<ReplicationPeerDescription> listReplicationPeers(final Pattern pattern) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<ReplicationPeerDescription>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<ReplicationPeerDescription> rpcCall() throws Exception {
                List<ReplicationProtos.ReplicationPeerDescription> peersList = this.master.listReplicationPeers(this.getRpcController(), RequestConverter.buildListReplicationPeersRequest(pattern)).getPeerDescList();
                ArrayList<ReplicationPeerDescription> result = new ArrayList<ReplicationPeerDescription>(peersList.size());
                for (ReplicationProtos.ReplicationPeerDescription peer : peersList) {
                    result.add(ReplicationPeerConfigUtil.toReplicationPeerDescription(peer));
                }
                return result;
            }
        });
    }

    @Override
    public void decommissionRegionServers(final List<ServerName> servers, final boolean offload) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public Void rpcCall() throws ServiceException {
                this.master.decommissionRegionServers(this.getRpcController(), RequestConverter.buildDecommissionRegionServersRequest(servers, offload));
                return null;
            }
        });
    }

    @Override
    public List<ServerName> listDecommissionedRegionServers() throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<ServerName>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public List<ServerName> rpcCall() throws ServiceException {
                MasterProtos.ListDecommissionedRegionServersRequest req = MasterProtos.ListDecommissionedRegionServersRequest.newBuilder().build();
                ArrayList<ServerName> servers = new ArrayList<ServerName>();
                for (HBaseProtos.ServerName server : this.master.listDecommissionedRegionServers(this.getRpcController(), req).getServerNameList()) {
                    servers.add(ProtobufUtil.toServerName(server));
                }
                return servers;
            }
        });
    }

    @Override
    public void recommissionRegionServer(final ServerName server, final List<byte[]> encodedRegionNames) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            public Void rpcCall() throws ServiceException {
                this.master.recommissionRegionServer(this.getRpcController(), RequestConverter.buildRecommissionRegionServerRequest(server, encodedRegionNames));
                return null;
            }
        });
    }

    @Override
    public List<TableCFs> listReplicatedTableCFs() throws IOException {
        ArrayList<TableCFs> replicatedTableCFs = new ArrayList<TableCFs>();
        List<TableDescriptor> tables = this.listTableDescriptors();
        tables.forEach(table -> {
            HashMap<String, Integer> cfs = new HashMap<String, Integer>();
            Stream.of(table.getColumnFamilies()).filter(column -> column.getScope() != 0).forEach(column -> cfs.put(column.getNameAsString(), column.getScope()));
            if (!cfs.isEmpty()) {
                replicatedTableCFs.add(new TableCFs(table.getTableName(), cfs));
            }
        });
        return replicatedTableCFs;
    }

    @Override
    public void enableTableReplication(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name cannot be null");
        }
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException("Table '" + tableName.getNameAsString() + "' does not exists.");
        }
        byte[][] splits = this.getTableSplits(tableName);
        this.checkAndSyncTableDescToPeers(tableName, splits);
        this.setTableRep(tableName, true);
    }

    @Override
    public void disableTableReplication(TableName tableName) throws IOException {
        if (tableName == null) {
            throw new IllegalArgumentException("Table name is null");
        }
        if (!this.tableExists(tableName)) {
            throw new TableNotFoundException("Table '" + tableName.getNameAsString() + "' does not exists.");
        }
        this.setTableRep(tableName, false);
    }

    private void checkAndSyncTableDescToPeers(TableName tableName, byte[][] splits) throws IOException {
        List<ReplicationPeerDescription> peers = this.listReplicationPeers();
        if (peers == null || peers.size() <= 0) {
            throw new IllegalArgumentException("Found no peer cluster for replication.");
        }
        for (ReplicationPeerDescription peerDesc : peers) {
            if (!peerDesc.getPeerConfig().needToReplicate(tableName)) continue;
            Configuration peerConf = ReplicationPeerConfigUtil.getPeerClusterConfiguration(this.conf, peerDesc);
            Connection conn = ConnectionFactory.createConnection(peerConf);
            Throwable throwable = null;
            try {
                Admin repHBaseAdmin = conn.getAdmin();
                Throwable throwable2 = null;
                try {
                    TableDescriptor tableDesc = this.getDescriptor(tableName);
                    TableDescriptor peerTableDesc = null;
                    if (!repHBaseAdmin.tableExists(tableName)) {
                        repHBaseAdmin.createTable(tableDesc, splits);
                        continue;
                    }
                    peerTableDesc = repHBaseAdmin.getDescriptor(tableName);
                    if (peerTableDesc == null) {
                        throw new IllegalArgumentException("Failed to get table descriptor for table " + tableName.getNameAsString() + " from peer cluster " + peerDesc.getPeerId());
                    }
                    if (TableDescriptor.COMPARATOR_IGNORE_REPLICATION.compare(peerTableDesc, tableDesc) == 0) continue;
                    throw new IllegalArgumentException("Table " + tableName.getNameAsString() + " exists in peer cluster " + peerDesc.getPeerId() + ", but the table descriptors are not same when compared with source cluster. Thus can not enable the table's replication switch.");
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (repHBaseAdmin == null) continue;
                    if (throwable2 != null) {
                        try {
                            repHBaseAdmin.close();
                        }
                        catch (Throwable throwable4) {
                            throwable2.addSuppressed(throwable4);
                        }
                        continue;
                    }
                    repHBaseAdmin.close();
                }
            }
            catch (Throwable throwable5) {
                throwable = throwable5;
                throw throwable5;
            }
            finally {
                if (conn == null) continue;
                if (throwable != null) {
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    continue;
                }
                conn.close();
            }
        }
    }

    private void setTableRep(TableName tableName, boolean enableRep) throws IOException {
        TableDescriptor tableDesc = this.getDescriptor(tableName);
        if (!tableDesc.matchReplicationScope(enableRep)) {
            int scope = enableRep ? 1 : 0;
            this.modifyTable(TableDescriptorBuilder.newBuilder(tableDesc).setReplicationScope(scope).build());
        }
    }

    @Override
    public void clearCompactionQueues(ServerName sn, final Set<String> queues) throws IOException, InterruptedException {
        if (queues == null || queues.size() == 0) {
            throw new IllegalArgumentException("queues cannot be null or empty");
        }
        final AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(sn);
        Callable<Void> callable = new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                AdminProtos.ClearCompactionQueuesRequest request = RequestConverter.buildClearCompactionQueuesRequest(queues);
                admin.clearCompactionQueues(controller, request);
                return null;
            }
        };
        ProtobufUtil.call(callable);
    }

    @Override
    public List<ServerName> clearDeadServers(final List<ServerName> servers) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<ServerName>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<ServerName> rpcCall() throws Exception {
                MasterProtos.ClearDeadServersRequest req = RequestConverter.buildClearDeadServersRequest(servers == null ? Collections.EMPTY_LIST : servers);
                return ProtobufUtil.toServerNameList(this.master.clearDeadServers(this.getRpcController(), req).getServerNameList());
            }
        });
    }

    @Override
    public void cloneTableSchema(TableName tableName, TableName newTableName, boolean preserveSplits) throws IOException {
        this.checkTableExists(tableName);
        if (this.tableExists(newTableName)) {
            throw new TableExistsException(newTableName);
        }
        TableDescriptor htd = TableDescriptorBuilder.copy(newTableName, this.getTableDescriptor(tableName));
        if (preserveSplits) {
            this.createTable(htd, this.getTableSplits(tableName));
        } else {
            this.createTable(htd);
        }
    }

    @Override
    public boolean switchRpcThrottle(final boolean enable) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.switchRpcThrottle(this.getRpcController(), MasterProtos.SwitchRpcThrottleRequest.newBuilder().setRpcThrottleEnabled(enable).build()).getPreviousRpcThrottleEnabled();
            }
        });
    }

    @Override
    public boolean isRpcThrottleEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.isRpcThrottleEnabled(this.getRpcController(), MasterProtos.IsRpcThrottleEnabledRequest.newBuilder().build()).getRpcThrottleEnabled();
            }
        });
    }

    @Override
    public boolean exceedThrottleQuotaSwitch(final boolean enable) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                return this.master.switchExceedThrottleQuota(this.getRpcController(), MasterProtos.SwitchExceedThrottleQuotaRequest.newBuilder().setExceedThrottleQuotaEnabled(enable).build()).getPreviousExceedThrottleQuotaEnabled();
            }
        });
    }

    @Override
    public Map<TableName, Long> getSpaceQuotaTableSizes() throws IOException {
        return (Map)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Map<TableName, Long>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Map<TableName, Long> rpcCall() throws Exception {
                QuotaProtos.GetSpaceQuotaRegionSizesResponse resp = this.master.getSpaceQuotaRegionSizes(this.getRpcController(), RequestConverter.buildGetSpaceQuotaRegionSizesRequest());
                HashMap<TableName, Long> tableSizes = new HashMap<TableName, Long>();
                for (QuotaProtos.GetSpaceQuotaRegionSizesResponse.RegionSizes sizes : resp.getSizesList()) {
                    TableName tn = ProtobufUtil.toTableName(sizes.getTableName());
                    tableSizes.put(tn, sizes.getSize());
                }
                return tableSizes;
            }
        });
    }

    public Map<TableName, SpaceQuotaSnapshot> getRegionServerSpaceQuotaSnapshots(ServerName serverName) throws IOException {
        final AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(serverName);
        Callable<QuotaProtos.GetSpaceQuotaSnapshotsResponse> callable = new Callable<QuotaProtos.GetSpaceQuotaSnapshotsResponse>(){

            @Override
            public QuotaProtos.GetSpaceQuotaSnapshotsResponse call() throws Exception {
                return admin.getSpaceQuotaSnapshots(HBaseAdmin.this.rpcControllerFactory.newController(), RequestConverter.buildGetSpaceQuotaSnapshotsRequest());
            }
        };
        QuotaProtos.GetSpaceQuotaSnapshotsResponse resp = ProtobufUtil.call(callable);
        HashMap<TableName, SpaceQuotaSnapshot> snapshots = new HashMap<TableName, SpaceQuotaSnapshot>();
        for (QuotaProtos.GetSpaceQuotaSnapshotsResponse.TableQuotaSnapshot snapshot : resp.getSnapshotsList()) {
            snapshots.put(ProtobufUtil.toTableName(snapshot.getTableName()), SpaceQuotaSnapshot.toSpaceQuotaSnapshot(snapshot.getSnapshot()));
        }
        return snapshots;
    }

    @Override
    public SpaceQuotaSnapshot getCurrentSpaceQuotaSnapshot(final String namespace) throws IOException {
        return (SpaceQuotaSnapshot)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<SpaceQuotaSnapshot>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected SpaceQuotaSnapshot rpcCall() throws Exception {
                QuotaProtos.GetQuotaStatesResponse resp = this.master.getQuotaStates(this.getRpcController(), RequestConverter.buildGetQuotaStatesRequest());
                for (QuotaProtos.GetQuotaStatesResponse.NamespaceQuotaSnapshot nsSnapshot : resp.getNsSnapshotsList()) {
                    if (!namespace.equals(nsSnapshot.getNamespace())) continue;
                    return SpaceQuotaSnapshot.toSpaceQuotaSnapshot(nsSnapshot.getSnapshot());
                }
                return null;
            }
        });
    }

    @Override
    public SpaceQuotaSnapshot getCurrentSpaceQuotaSnapshot(final TableName tableName) throws IOException {
        return (SpaceQuotaSnapshot)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<SpaceQuotaSnapshot>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected SpaceQuotaSnapshot rpcCall() throws Exception {
                QuotaProtos.GetQuotaStatesResponse resp = this.master.getQuotaStates(this.getRpcController(), RequestConverter.buildGetQuotaStatesRequest());
                HBaseProtos.TableName protoTableName = ProtobufUtil.toProtoTableName(tableName);
                for (QuotaProtos.GetQuotaStatesResponse.TableQuotaSnapshot tableSnapshot : resp.getTableSnapshotsList()) {
                    if (!protoTableName.equals(tableSnapshot.getTableName())) continue;
                    return SpaceQuotaSnapshot.toSpaceQuotaSnapshot(tableSnapshot.getSnapshot());
                }
                return null;
            }
        });
    }

    @Override
    public void grant(final UserPermission userPermission, final boolean mergeExistingPermissions) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                AccessControlProtos.GrantRequest req = ShadedAccessControlUtil.buildGrantRequest(userPermission, mergeExistingPermissions);
                this.master.grant(this.getRpcController(), req);
                return null;
            }
        });
    }

    @Override
    public void revoke(final UserPermission userPermission) throws IOException {
        this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Void>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Void rpcCall() throws Exception {
                AccessControlProtos.RevokeRequest req = ShadedAccessControlUtil.buildRevokeRequest(userPermission);
                this.master.revoke(this.getRpcController(), req);
                return null;
            }
        });
    }

    @Override
    public List<UserPermission> getUserPermissions(final GetUserPermissionsRequest getUserPermissionsRequest) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<UserPermission>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<UserPermission> rpcCall() throws Exception {
                AccessControlProtos.GetUserPermissionsRequest req = ShadedAccessControlUtil.buildGetUserPermissionsRequest(getUserPermissionsRequest);
                AccessControlProtos.GetUserPermissionsResponse response = this.master.getUserPermissions(this.getRpcController(), req);
                return response.getUserPermissionList().stream().map(userPermission -> ShadedAccessControlUtil.toUserPermission(userPermission)).collect(Collectors.toList());
            }
        });
    }

    @Override
    public Future<Void> splitRegionAsync(byte[] regionName) throws IOException {
        return this.splitRegionAsync(regionName, null);
    }

    @Override
    public Future<Void> createTableAsync(TableDescriptor desc) throws IOException {
        return this.createTableAsync(desc, null);
    }

    @Override
    public List<Boolean> hasUserPermissions(final String userName, final List<Permission> permissions) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<Boolean>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<Boolean> rpcCall() throws Exception {
                AccessControlProtos.HasUserPermissionsRequest request = ShadedAccessControlUtil.buildHasUserPermissionsRequest(userName, permissions);
                return this.master.hasUserPermissions(this.getRpcController(), request).getHasUserPermissionList();
            }
        });
    }

    @Override
    public boolean snapshotCleanupSwitch(final boolean on, final boolean synchronous) throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                MasterProtos.SetSnapshotCleanupRequest req = RequestConverter.buildSetSnapshotCleanupRequest(on, synchronous);
                return this.master.switchSnapshotCleanup(this.getRpcController(), req).getPrevSnapshotCleanup();
            }
        });
    }

    @Override
    public boolean isSnapshotCleanupEnabled() throws IOException {
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<Boolean>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected Boolean rpcCall() throws Exception {
                MasterProtos.IsSnapshotCleanupEnabledRequest req = RequestConverter.buildIsSnapshotCleanupEnabledRequest();
                return this.master.isSnapshotCleanupEnabled(this.getRpcController(), req).getEnabled();
            }
        });
    }

    private List<LogEntry> getSlowLogResponses(Map<String, Object> filterParams, Set<ServerName> serverNames, int limit, String logType) {
        if (CollectionUtils.isEmpty(serverNames)) {
            return Collections.emptyList();
        }
        return serverNames.stream().map(serverName -> {
            try {
                return this.getSlowLogResponseFromServer((ServerName)serverName, filterParams, limit, logType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toList());
    }

    private List<LogEntry> getSlowLogResponseFromServer(ServerName serverName, final Map<String, Object> filterParams, final int limit, final String logType) throws IOException {
        final AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(serverName);
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<List<LogEntry>>(){

            @Override
            protected List<LogEntry> rpcCall(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                HBaseProtos.LogRequest logRequest = RequestConverter.buildSlowLogResponseRequest(filterParams, limit, logType);
                HBaseProtos.LogEntry logEntry = admin.getLogEntries(controller, logRequest);
                return ProtobufUtil.toSlowLogPayloads(logEntry);
            }
        });
    }

    @Override
    public List<Boolean> clearSlowLogResponses(@Nullable Set<ServerName> serverNames) throws IOException {
        if (CollectionUtils.isEmpty(serverNames)) {
            return Collections.emptyList();
        }
        return serverNames.stream().map(serverName -> {
            try {
                return this.clearSlowLogsResponses((ServerName)serverName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
    }

    @Override
    public List<LogEntry> getLogEntries(Set<ServerName> serverNames, String logType, ServerType serverType, int limit, Map<String, Object> filterParams) throws IOException {
        if (logType == null || serverType == null) {
            throw new IllegalArgumentException("logType and/or serverType cannot be empty");
        }
        if (logType.equals("SLOW_LOG") || logType.equals("LARGE_LOG")) {
            if (ServerType.MASTER.equals((Object)serverType)) {
                throw new IllegalArgumentException("Slow/Large logs are not maintained by HMaster");
            }
            return this.getSlowLogResponses(filterParams, serverNames, limit, logType);
        }
        if (logType.equals("BALANCER_DECISION")) {
            if (ServerType.REGION_SERVER.equals((Object)serverType)) {
                throw new IllegalArgumentException("Balancer Decision logs are not maintained by HRegionServer");
            }
            return this.getBalancerDecisions(limit);
        }
        if (logType.equals("BALANCER_REJECTION")) {
            if (ServerType.REGION_SERVER.equals((Object)serverType)) {
                throw new IllegalArgumentException("Balancer Rejection logs are not maintained by HRegionServer");
            }
            return this.getBalancerRejections(limit);
        }
        return Collections.emptyList();
    }

    private List<LogEntry> getBalancerDecisions(final int limit) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<LogEntry>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<LogEntry> rpcCall() throws Exception {
                HBaseProtos.LogEntry logEntry = this.master.getLogEntries(this.getRpcController(), ProtobufUtil.toBalancerDecisionRequest(limit));
                return ProtobufUtil.toBalancerDecisionResponse(logEntry);
            }
        });
    }

    private List<LogEntry> getBalancerRejections(final int limit) throws IOException {
        return (List)this.executeCallable((RetryingCallable<V> & Closeable)new MasterCallable<List<LogEntry>>(this.getConnection(), this.getRpcControllerFactory()){

            @Override
            protected List<LogEntry> rpcCall() throws Exception {
                HBaseProtos.LogEntry logEntry = this.master.getLogEntries(this.getRpcController(), ProtobufUtil.toBalancerRejectionRequest(limit));
                return ProtobufUtil.toBalancerRejectionResponse(logEntry);
            }
        });
    }

    private Boolean clearSlowLogsResponses(ServerName serverName) throws IOException {
        final AdminProtos.AdminService.BlockingInterface admin = this.connection.getAdmin(serverName);
        return (Boolean)this.executeCallable((RetryingCallable<V> & Closeable)new RpcRetryingCallable<Boolean>(){

            @Override
            protected Boolean rpcCall(int callTimeout) throws Exception {
                HBaseRpcController controller = HBaseAdmin.this.rpcControllerFactory.newController();
                AdminProtos.ClearSlowLogResponses clearSlowLogResponses = admin.clearSlowLogsResponses(controller, RequestConverter.buildClearSlowLogResponseRequest());
                return ProtobufUtil.toClearSlowLogPayload(clearSlowLogResponses);
            }
        });
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    private static class ReplicationFuture
    extends ProcedureFuture<Void> {
        private final String peerId;
        private final Supplier<String> getOperation;

        public ReplicationFuture(HBaseAdmin admin, String peerId, Long procId, Supplier<String> getOperation) {
            super(admin, procId);
            this.peerId = peerId;
            this.getOperation = getOperation;
        }

        public String toString() {
            return "Operation: " + this.getOperation.get() + ", peerId: " + this.peerId;
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected static abstract class NamespaceFuture
    extends ProcedureFuture<Void> {
        private final String namespaceName;

        public NamespaceFuture(HBaseAdmin admin, String namespaceName, Long procId) {
            super(admin, procId);
            this.namespaceName = namespaceName;
        }

        protected String getNamespaceName() {
            return this.namespaceName;
        }

        public abstract String getOperationType();

        public String toString() {
            return "Operation: " + this.getOperationType() + ", Namespace: " + this.getNamespaceName();
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected static abstract class TableFuture<V>
    extends ProcedureFuture<V> {
        private final TableName tableName;

        public TableFuture(HBaseAdmin admin, TableName tableName, Long procId) {
            super(admin, procId);
            this.tableName = tableName;
        }

        public String toString() {
            return this.getDescription();
        }

        protected TableName getTableName() {
            return this.tableName;
        }

        protected TableDescriptor getTableDescriptor() throws IOException {
            return this.getAdmin().getDescriptor(this.getTableName());
        }

        public abstract String getOperationType();

        protected String getDescription() {
            return "Operation: " + this.getOperationType() + ", Table Name: " + this.tableName.getNameWithNamespaceInclAsString() + ", procId: " + this.procId;
        }

        @Override
        protected V postOperationResult(V result, long deadlineTs) throws IOException, TimeoutException {
            LOG.info(this.getDescription() + " completed");
            return super.postOperationResult(result, deadlineTs);
        }

        @Override
        protected V postOperationFailure(IOException exception, long deadlineTs) throws IOException, TimeoutException {
            LOG.info(this.getDescription() + " failed with " + exception.getMessage());
            return super.postOperationFailure(exception, deadlineTs);
        }

        protected void waitForTableEnabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new TableWaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    try {
                        if (this.getAdmin().isTableAvailable(tableName)) {
                            return true;
                        }
                    }
                    catch (TableNotFoundException tnfe) {
                        LOG.debug("Table " + tableName.getNameWithNamespaceInclAsString() + " was not enabled, sleeping. tries=" + tries);
                    }
                    return false;
                }
            });
        }

        protected void waitForTableDisabled(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new TableWaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return this.getAdmin().isTableDisabled(tableName);
                }
            });
        }

        protected void waitTableNotFound(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new TableWaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return !this.getAdmin().tableExists(tableName);
                }
            });
        }

        protected void waitForSchemaUpdate(long deadlineTs) throws IOException, TimeoutException {
            this.waitForState(deadlineTs, new TableWaitForStateCallable(){

                @Override
                public boolean checkState(int tries) throws IOException {
                    return this.getAdmin().getAlterStatus(tableName).getFirst() == 0;
                }
            });
        }

        protected void waitForAllRegionsOnline(long deadlineTs, byte[][] splitKeys) throws IOException, TimeoutException {
            final TableDescriptor desc = this.getTableDescriptor();
            final AtomicInteger actualRegCount = new AtomicInteger(0);
            MetaTableAccessor.Visitor visitor = new MetaTableAccessor.Visitor(){

                @Override
                public boolean visit(Result rowResult) throws IOException {
                    HRegionLocation[] locations;
                    RegionLocations list = MetaTableAccessor.getRegionLocations(rowResult);
                    if (list == null) {
                        LOG.warn("No serialized HRegionInfo in " + rowResult);
                        return true;
                    }
                    HRegionLocation l = list.getRegionLocation();
                    if (l == null) {
                        return true;
                    }
                    if (!l.getRegionInfo().getTable().equals(desc.getTableName())) {
                        return false;
                    }
                    if (l.getRegionInfo().isOffline() || l.getRegionInfo().isSplit()) {
                        return true;
                    }
                    for (HRegionLocation location : locations = list.getRegionLocations()) {
                        ServerName serverName;
                        if (location == null || (serverName = location.getServerName()) == null || serverName.getAddress() == null) continue;
                        actualRegCount.incrementAndGet();
                    }
                    return true;
                }
            };
            int tries = 0;
            int numRegs = (splitKeys == null ? 1 : splitKeys.length + 1) * desc.getRegionReplication();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                actualRegCount.set(0);
                MetaTableAccessor.scanMetaForTableRegions(this.getAdmin().getConnection(), visitor, desc.getTableName());
                if (actualRegCount.get() == numRegs) {
                    return;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("Interrupted when opening regions; " + actualRegCount.get() + " of " + numRegs + " regions processed so far");
                }
            }
            throw new TimeoutException("Only " + actualRegCount.get() + " of " + numRegs + " regions are online; retries exhausted.");
        }

        protected abstract class TableWaitForStateCallable
        implements ProcedureFuture.WaitForStateCallable {
            protected TableWaitForStateCallable() {
            }

            @Override
            public void throwInterruptedException() throws InterruptedIOException {
                throw new InterruptedIOException("Interrupted while waiting for " + TableFuture.this.getDescription());
            }

            @Override
            public void throwTimeoutException(long elapsedTime) throws TimeoutException {
                throw new TimeoutException(TableFuture.this.getDescription() + " has not completed after " + elapsedTime + "ms");
            }
        }
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected static class ProcedureFuture<V>
    implements Future<V> {
        private ExecutionException exception = null;
        private boolean procResultFound = false;
        private boolean done = false;
        private boolean cancelled = false;
        private V result = null;
        private final HBaseAdmin admin;
        protected final Long procId;

        public ProcedureFuture(HBaseAdmin admin, Long procId) {
            this.admin = admin;
            this.procId = procId;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            MasterProtos.AbortProcedureRequest abortProcRequest = MasterProtos.AbortProcedureRequest.newBuilder().setProcId(this.procId).setMayInterruptIfRunning(mayInterruptIfRunning).build();
            try {
                this.cancelled = this.abortProcedureResult(abortProcRequest).getIsProcedureAborted();
                if (this.cancelled) {
                    this.done = true;
                }
            }
            catch (IOException e) {
                LOG.warn("Cancelling the procedure with procId=" + this.procId + " throws exception " + e.getMessage(), e);
                this.cancelled = false;
            }
            return this.cancelled;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        protected MasterProtos.AbortProcedureResponse abortProcedureResult(final MasterProtos.AbortProcedureRequest request) throws IOException {
            return (MasterProtos.AbortProcedureResponse)this.admin.executeCallable(new MasterCallable<MasterProtos.AbortProcedureResponse>(this.admin.getConnection(), this.admin.getRpcControllerFactory()){

                @Override
                protected MasterProtos.AbortProcedureResponse rpcCall() throws Exception {
                    return this.master.abortProcedure(this.getRpcController(), request);
                }
            });
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            try {
                return this.get(this.admin.getProcedureTimeout, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                LOG.warn("Failed to get the procedure with procId=" + this.procId + " throws exception " + e.getMessage(), e);
                return null;
            }
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.done) {
                long deadlineTs = EnvironmentEdgeManager.currentTime() + unit.toMillis(timeout);
                try {
                    try {
                        if (this.procId != null) {
                            this.result = this.waitProcedureResult(this.procId, deadlineTs);
                        }
                        if (!this.procResultFound) {
                            this.result = this.waitOperationResult(deadlineTs);
                        }
                        this.result = this.postOperationResult(this.result, deadlineTs);
                        this.done = true;
                    }
                    catch (IOException e) {
                        this.result = this.postOperationFailure(e, deadlineTs);
                        this.done = true;
                    }
                }
                catch (IOException e) {
                    this.exception = new ExecutionException(e);
                    this.done = true;
                }
            }
            if (this.exception != null) {
                throw this.exception;
            }
            return this.result;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        protected HBaseAdmin getAdmin() {
            return this.admin;
        }

        private V waitProcedureResult(long procId, long deadlineTs) throws IOException, TimeoutException, InterruptedException {
            MasterProtos.GetProcedureResultRequest request = MasterProtos.GetProcedureResultRequest.newBuilder().setProcId(procId).build();
            int tries = 0;
            IOException serviceEx = null;
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                MasterProtos.GetProcedureResultResponse response;
                block7: {
                    response = null;
                    try {
                        response = this.getProcedureResult(request);
                    }
                    catch (IOException e) {
                        serviceEx = ProcedureFuture.unwrapException(e);
                        LOG.warn("failed to get the procedure result procId=" + procId, serviceEx);
                        if (!(serviceEx instanceof DoNotRetryIOException)) break block7;
                        LOG.warn("Proc-v2 is unsupported on this master: " + serviceEx.getMessage(), serviceEx);
                        this.procResultFound = false;
                        return null;
                    }
                }
                if (response != null && response.getState() != MasterProtos.GetProcedureResultResponse.State.RUNNING) {
                    this.procResultFound = response.getState() != MasterProtos.GetProcedureResultResponse.State.NOT_FOUND;
                    return this.convertResult(response);
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    throw new InterruptedException("Interrupted while waiting for the result of proc " + procId);
                }
            }
            if (serviceEx != null) {
                throw serviceEx;
            }
            throw new TimeoutException("The procedure " + procId + " is still running");
        }

        private static IOException unwrapException(IOException e) {
            if (e instanceof RemoteException) {
                return ((RemoteException)e).unwrapRemoteException();
            }
            return e;
        }

        protected MasterProtos.GetProcedureResultResponse getProcedureResult(final MasterProtos.GetProcedureResultRequest request) throws IOException {
            return (MasterProtos.GetProcedureResultResponse)this.admin.executeCallable(new MasterCallable<MasterProtos.GetProcedureResultResponse>(this.admin.getConnection(), this.admin.getRpcControllerFactory()){

                @Override
                protected MasterProtos.GetProcedureResultResponse rpcCall() throws Exception {
                    return this.master.getProcedureResult(this.getRpcController(), request);
                }
            });
        }

        protected V convertResult(MasterProtos.GetProcedureResultResponse response) throws IOException {
            if (response.hasException()) {
                throw ForeignExceptionUtil.toIOException(response.getException());
            }
            return null;
        }

        protected V waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            return null;
        }

        protected V postOperationResult(V result, long deadlineTs) throws IOException, TimeoutException {
            return result;
        }

        protected V postOperationFailure(IOException exception, long deadlineTs) throws IOException, TimeoutException {
            throw exception;
        }

        protected void waitForState(long deadlineTs, WaitForStateCallable callable) throws IOException, TimeoutException {
            int tries = 0;
            IOException serverEx = null;
            long startTime = EnvironmentEdgeManager.currentTime();
            while (EnvironmentEdgeManager.currentTime() < deadlineTs) {
                serverEx = null;
                try {
                    if (callable.checkState(tries)) {
                        return;
                    }
                }
                catch (IOException e) {
                    serverEx = e;
                }
                try {
                    Thread.sleep(this.getAdmin().getPauseTime(tries++));
                }
                catch (InterruptedException e) {
                    callable.throwInterruptedException();
                }
            }
            if (serverEx != null) {
                throw ProcedureFuture.unwrapException(serverEx);
            }
            callable.throwTimeoutException(EnvironmentEdgeManager.currentTime() - startTime);
        }

        protected static interface WaitForStateCallable {
            public boolean checkState(int var1) throws IOException;

            public void throwInterruptedException() throws InterruptedIOException;

            public void throwTimeoutException(long var1) throws TimeoutException;
        }
    }

    private static class ThrowableAbortable
    implements Abortable {
        private ThrowableAbortable() {
        }

        @Override
        public void abort(String why, Throwable e) {
            throw new RuntimeException(why, e);
        }

        @Override
        public boolean isAborted() {
            return true;
        }
    }

    private static class RestoreSnapshotFuture
    extends TableFuture<Void> {
        public RestoreSnapshotFuture(HBaseAdmin admin, SnapshotProtos.SnapshotDescription snapshot, TableName tableName, MasterProtos.RestoreSnapshotResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            if (response != null && !response.hasProcId()) {
                throw new UnsupportedOperationException("Client could not call old version of Server");
            }
        }

        public RestoreSnapshotFuture(HBaseAdmin admin, TableName tableName, Long procId) {
            super(admin, tableName, procId);
        }

        @Override
        public String getOperationType() {
            return "MODIFY";
        }
    }

    private static class ModifyTableFuture
    extends TableFuture<Void> {
        public ModifyTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.ModifyTableResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        public ModifyTableFuture(HBaseAdmin admin, TableName tableName, Long procId) {
            super(admin, tableName, procId);
        }

        @Override
        public String getOperationType() {
            return "MODIFY";
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            this.waitForSchemaUpdate(deadlineTs);
            return result;
        }
    }

    private static class SplitTableRegionFuture
    extends TableFuture<Void> {
        public SplitTableRegionFuture(HBaseAdmin admin, TableName tableName, MasterProtos.SplitTableRegionResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        public SplitTableRegionFuture(HBaseAdmin admin, TableName tableName, Long procId) {
            super(admin, tableName, procId);
        }

        @Override
        public String getOperationType() {
            return "SPLIT_REGION";
        }
    }

    private static class MergeTableRegionsFuture
    extends TableFuture<Void> {
        public MergeTableRegionsFuture(HBaseAdmin admin, TableName tableName, MasterProtos.MergeTableRegionsResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        public MergeTableRegionsFuture(HBaseAdmin admin, TableName tableName, Long procId) {
            super(admin, tableName, procId);
        }

        @Override
        public String getOperationType() {
            return "MERGE_REGIONS";
        }
    }

    private static class ModifyColumnFamilyFuture
    extends ModifyTableFuture {
        public ModifyColumnFamilyFuture(HBaseAdmin admin, TableName tableName, MasterProtos.ModifyColumnResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "MODIFY_COLUMN_FAMILY";
        }
    }

    private static class DeleteColumnFamilyFuture
    extends ModifyTableFuture {
        public DeleteColumnFamilyFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DeleteColumnResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "DELETE_COLUMN_FAMILY";
        }
    }

    private static class AddColumnFamilyFuture
    extends ModifyTableFuture {
        public AddColumnFamilyFuture(HBaseAdmin admin, TableName tableName, MasterProtos.AddColumnResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "ADD_COLUMN_FAMILY";
        }
    }

    private static class DisableTableFuture
    extends TableFuture<Void> {
        public DisableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DisableTableResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "DISABLE";
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableDisabled(deadlineTs);
            return null;
        }
    }

    private static class EnableTableFuture
    extends TableFuture<Void> {
        public EnableTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.EnableTableResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "ENABLE";
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableEnabled(deadlineTs);
            return null;
        }
    }

    private static class TruncateTableFuture
    extends TableFuture<Void> {
        private final boolean preserveSplits;

        public TruncateTableFuture(HBaseAdmin admin, TableName tableName, boolean preserveSplits, MasterProtos.TruncateTableResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.preserveSplits = preserveSplits;
        }

        @Override
        public String getOperationType() {
            return "TRUNCATE";
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableEnabled(deadlineTs);
            byte[][] splitKeys = this.preserveSplits ? this.getAdmin().getTableSplits(this.getTableName()) : (byte[][])null;
            this.waitForAllRegionsOnline(deadlineTs, splitKeys);
            return null;
        }
    }

    private static class DeleteTableFuture
    extends TableFuture<Void> {
        public DeleteTableFuture(HBaseAdmin admin, TableName tableName, MasterProtos.DeleteTableResponse response) {
            super(admin, tableName, response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
        }

        @Override
        public String getOperationType() {
            return "DELETE";
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitTableNotFound(deadlineTs);
            return null;
        }

        @Override
        protected Void postOperationResult(Void result, long deadlineTs) throws IOException, TimeoutException {
            ((ClusterConnection)this.getAdmin().getConnection()).clearRegionCache(this.getTableName());
            return super.postOperationResult(result, deadlineTs);
        }
    }

    private static class CreateTableFuture
    extends TableFuture<Void> {
        private final TableDescriptor desc;
        private final byte[][] splitKeys;

        public CreateTableFuture(HBaseAdmin admin, TableDescriptor desc, byte[][] splitKeys, MasterProtos.CreateTableResponse response) {
            super(admin, desc.getTableName(), response != null && response.hasProcId() ? Long.valueOf(response.getProcId()) : null);
            this.splitKeys = splitKeys;
            this.desc = desc;
        }

        @Override
        protected TableDescriptor getTableDescriptor() {
            return this.desc;
        }

        @Override
        public String getOperationType() {
            return "CREATE";
        }

        @Override
        protected Void waitOperationResult(long deadlineTs) throws IOException, TimeoutException {
            this.waitForTableEnabled(deadlineTs);
            this.waitForAllRegionsOnline(deadlineTs, this.splitKeys);
            return null;
        }
    }

    private static class AbortProcedureFuture
    extends ProcedureFuture<Boolean> {
        private boolean isAbortInProgress;

        public AbortProcedureFuture(HBaseAdmin admin, Long procId, Boolean abortProcResponse) {
            super(admin, procId);
            this.isAbortInProgress = abortProcResponse;
        }

        @Override
        public Boolean get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            if (!this.isAbortInProgress) {
                return false;
            }
            super.get(timeout, unit);
            return true;
        }
    }
}

