/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.fs.ChecksumException;
import org.apache.hadoop.util.DataChecksum;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.util.ChecksumType;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ChecksumUtil {
    public static final Logger LOG = LoggerFactory.getLogger(ChecksumUtil.class);
    public static final int CHECKSUM_BUF_SIZE = 256;
    private static boolean generateExceptions = false;

    static void generateChecksums(byte[] indata, int startOffset, int endOffset, byte[] outdata, int outOffset, ChecksumType checksumType, int bytesPerChecksum) throws IOException {
        if (checksumType == ChecksumType.NULL) {
            return;
        }
        DataChecksum checksum = DataChecksum.newDataChecksum((DataChecksum.Type)checksumType.getDataChecksumType(), (int)bytesPerChecksum);
        checksum.calculateChunkedSums(ByteBuffer.wrap(indata, startOffset, endOffset - startOffset), ByteBuffer.wrap(outdata, outOffset, outdata.length - outOffset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean verifyChunkedSums(DataChecksum dataChecksum, ByteBuff data, ByteBuff checksums, String pathName) {
        if (data instanceof SingleByteBuff && checksums instanceof SingleByteBuff) {
            ByteBuffer dataBB = (ByteBuffer)data.nioByteBuffers()[0].duplicate().position(data.position()).limit(data.limit());
            ByteBuffer checksumBB = (ByteBuffer)checksums.nioByteBuffers()[0].duplicate().position(checksums.position()).limit(checksums.limit());
            try {
                dataChecksum.verifyChunkedSums(dataBB, checksumBB, pathName, 0L);
                return true;
            }
            catch (ChecksumException e) {
                return false;
            }
        }
        int checksumTypeSize = dataChecksum.getChecksumType().size;
        if (checksumTypeSize == 0) {
            return true;
        }
        assert (checksumTypeSize == 4);
        int bytesPerChecksum = dataChecksum.getBytesPerChecksum();
        int startDataPos = data.position();
        data.mark();
        checksums.mark();
        try {
            byte[] buf = new byte[256];
            byte[] sum = new byte[checksumTypeSize];
            while (data.remaining() > 0) {
                int stored;
                int len;
                int n = Math.min(data.remaining(), bytesPerChecksum);
                checksums.get(sum);
                dataChecksum.reset();
                for (int remain = n; remain > 0; remain -= len) {
                    len = Math.min(256, remain);
                    data.get(buf, 0, len);
                    dataChecksum.update(buf, 0, len);
                }
                int calculated = (int)dataChecksum.getValue();
                if (calculated == (stored = sum[0] << 24 & 0xFF000000 | sum[1] << 16 & 0xFF0000 | sum[2] << 8 & 0xFF00 | sum[3] & 0xFF)) continue;
                if (LOG.isTraceEnabled()) {
                    long errPos = data.position() - startDataPos - n;
                    LOG.trace("Checksum error: {} at {} expected: {} got: {}", pathName, errPos, stored, calculated);
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            data.reset();
            checksums.reset();
        }
        return true;
    }

    static boolean validateChecksum(ByteBuff buf, String pathName, long offset, int hdrSize) {
        ChecksumType ctype = ChecksumType.codeToType(buf.get(HFileBlock.Header.CHECKSUM_TYPE_INDEX));
        if (ctype == ChecksumType.NULL) {
            return true;
        }
        int bytesPerChecksum = buf.getInt(HFileBlock.Header.BYTES_PER_CHECKSUM_INDEX);
        DataChecksum dataChecksum = DataChecksum.newDataChecksum((DataChecksum.Type)ctype.getDataChecksumType(), (int)bytesPerChecksum);
        assert (dataChecksum != null);
        int onDiskDataSizeWithHeader = buf.getInt(HFileBlock.Header.ON_DISK_DATA_SIZE_WITH_HEADER_INDEX);
        LOG.trace("dataLength={}, sizeWithHeader={}, checksumType={}, file={}, offset={}, headerSize={}, bytesPerChecksum={}", buf.capacity(), onDiskDataSizeWithHeader, ctype.getName(), pathName, offset, hdrSize, bytesPerChecksum);
        ByteBuff data = buf.duplicate().position(0).limit(onDiskDataSizeWithHeader);
        ByteBuff checksums = buf.duplicate().position(onDiskDataSizeWithHeader).limit(buf.limit());
        return ChecksumUtil.verifyChunkedSums(dataChecksum, data, checksums, pathName);
    }

    static long numBytes(long datasize, int bytesPerChecksum) {
        return ChecksumUtil.numChunks(datasize, bytesPerChecksum) * 4L;
    }

    static long numChunks(long datasize, int bytesPerChecksum) {
        long numChunks = datasize / (long)bytesPerChecksum;
        if (datasize % (long)bytesPerChecksum != 0L) {
            ++numChunks;
        }
        return numChunks;
    }

    public static void generateExceptionForChecksumFailureForTest(boolean value) {
        generateExceptions = value;
    }
}

