/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hudi.org.apache.hadoop.hbase.ClusterId;
import org.apache.hudi.org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hudi.org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hudi.org.apache.hadoop.hbase.security.access.SnapshotScannerHDFSAclHelper;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MasterFileSystem {
    private static final Logger LOG = LoggerFactory.getLogger(MasterFileSystem.class);
    public static final String HBASE_DIR_PERMS = "hbase.rootdir.perms";
    public static final String HBASE_WAL_DIR_PERMS = "hbase.wal.dir.perms";
    private final Configuration conf;
    private ClusterId clusterId;
    private final FileSystem fs;
    private final FileSystem walFs;
    private final Path rootdir;
    private final Path tempdir;
    private final Path walRootDir;
    private final FsPermission secureRootSubDirPerms;
    private final FsPermission secureRootFilePerms = new FsPermission("600");
    private final FsPermission HiddenDirPerms = FsPermission.valueOf((String)"-rwx--x--x");
    private boolean isSecurityEnabled;

    public MasterFileSystem(Configuration conf) throws IOException {
        this.conf = conf;
        this.rootdir = CommonFSUtils.getRootDir(conf);
        this.tempdir = new Path(this.rootdir, ".tmp");
        this.fs = this.rootdir.getFileSystem(conf);
        this.walRootDir = CommonFSUtils.getWALRootDir(conf);
        this.walFs = CommonFSUtils.getWALFileSystem(conf);
        CommonFSUtils.setFsDefault(conf, new Path(this.walFs.getUri()));
        this.walFs.setConf(conf);
        CommonFSUtils.setFsDefault(conf, new Path(this.fs.getUri()));
        this.fs.setConf(conf);
        this.secureRootSubDirPerms = new FsPermission(conf.get(HBASE_DIR_PERMS, "700"));
        this.isSecurityEnabled = "kerberos".equalsIgnoreCase(conf.get("hbase.security.authentication"));
        this.createInitialFileSystemLayout();
        HFileSystem.addLocationsOrderInterceptor(conf);
    }

    private void createInitialFileSystemLayout() throws IOException {
        FsPermission currentRootPerms;
        String[] protectedSubDirs = new String[]{"data", "archive", ".hbck", "mobdir"};
        String[] protectedSubLogDirs = new String[]{"WALs", "oldWALs", "corrupt"};
        this.checkRootDir(this.rootdir, this.conf, this.fs);
        this.checkTempDir(this.tempdir, this.conf, this.fs);
        for (String subDir : protectedSubDirs) {
            this.checkSubDir(new Path(this.rootdir, subDir), HBASE_DIR_PERMS);
        }
        String perms = !this.walRootDir.equals((Object)this.rootdir) ? HBASE_WAL_DIR_PERMS : HBASE_DIR_PERMS;
        for (String subDir : protectedSubLogDirs) {
            this.checkSubDir(new Path(this.walRootDir, subDir), perms);
        }
        this.checkStagingDir();
        if (this.isSecurityEnabled) {
            this.fs.setPermission(new Path(this.rootdir, "hbase.version"), this.secureRootFilePerms);
            this.fs.setPermission(new Path(this.rootdir, "hbase.id"), this.secureRootFilePerms);
        }
        if (!((currentRootPerms = this.fs.getFileStatus(this.rootdir).getPermission()).getUserAction().implies(FsAction.EXECUTE) && currentRootPerms.getGroupAction().implies(FsAction.EXECUTE) && currentRootPerms.getOtherAction().implies(FsAction.EXECUTE))) {
            LOG.warn("rootdir permissions do not contain 'excute' for user, group or other. Automatically adding 'excute' permission for all");
            this.fs.setPermission(this.rootdir, new FsPermission(currentRootPerms.getUserAction().or(FsAction.EXECUTE), currentRootPerms.getGroupAction().or(FsAction.EXECUTE), currentRootPerms.getOtherAction().or(FsAction.EXECUTE)));
        }
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public FileSystem getWALFileSystem() {
        return this.walFs;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public Path getRootDir() {
        return this.rootdir;
    }

    public Path getWALRootDir() {
        return this.walRootDir;
    }

    public Path getRegionDir(RegionInfo region) {
        return FSUtils.getRegionDirFromRootDir(this.getRootDir(), region);
    }

    public Path getTempDir() {
        return this.tempdir;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    private void checkRootDir(Path rd, Configuration c, FileSystem fs) throws IOException {
        FileStatus status;
        int threadWakeFrequency = c.getInt("hbase.server.thread.wakefrequency", 10000);
        FSUtils.waitOnSafeMode(c, threadWakeFrequency);
        try {
            status = fs.getFileStatus(rd);
        }
        catch (FileNotFoundException e) {
            status = null;
        }
        int versionFileWriteAttempts = c.getInt("hbase.server.versionfile.writeattempts", 3);
        try {
            if (status == null) {
                if (!fs.mkdirs(rd)) {
                    throw new IOException("Can not create configured 'hbase.rootdir' " + rd);
                }
                FSUtils.setVersion(fs, rd, threadWakeFrequency, versionFileWriteAttempts);
            } else {
                if (!status.isDirectory()) {
                    throw new IllegalArgumentException("Configured 'hbase.rootdir' " + rd + " is not a directory.");
                }
                FSUtils.checkVersion(fs, rd, true, threadWakeFrequency, versionFileWriteAttempts);
            }
        }
        catch (DeserializationException de) {
            LOG.error(HBaseMarkers.FATAL, "Please fix invalid configuration for '{}' {}", "hbase.rootdir", rd, de);
            throw new IOException(de);
        }
        catch (IllegalArgumentException iae) {
            LOG.error(HBaseMarkers.FATAL, "Please fix invalid configuration for '{}' {}", "hbase.rootdir", rd, iae);
            throw iae;
        }
        if (!FSUtils.checkClusterIdExists(fs, rd, threadWakeFrequency)) {
            FSUtils.setClusterId(fs, rd, new ClusterId(), threadWakeFrequency);
        }
        this.clusterId = FSUtils.getClusterId(fs, rd);
    }

    void checkTempDir(Path tmpdir, Configuration c, FileSystem fs) throws IOException {
        if (fs.exists(tmpdir)) {
            for (Path tableDir : FSUtils.getTableDirs(fs, tmpdir)) {
                HFileArchiver.archiveRegions(c, fs, this.rootdir, tableDir, FSUtils.getRegionDirs(fs, tableDir));
                if (FSUtils.getRegionDirs(fs, tableDir).isEmpty()) continue;
                LOG.warn("Found regions in tmp dir after archiving table regions, {}", (Object)tableDir);
            }
            if (!SnapshotScannerHDFSAclHelper.isAclSyncToHdfsEnabled(c) && !fs.delete(tmpdir, true)) {
                throw new IOException("Unable to clean the temp directory: " + tmpdir);
            }
        }
        if (!fs.exists(tmpdir) && (this.isSecurityEnabled ? !fs.mkdirs(tmpdir, this.secureRootSubDirPerms) : !fs.mkdirs(tmpdir))) {
            throw new IOException("HBase temp directory '" + tmpdir + "' creation failure.");
        }
    }

    private void checkSubDir(Path p, String dirPermsConfName) throws IOException {
        FileSystem fs = p.getFileSystem(this.conf);
        FsPermission dirPerms = new FsPermission(this.conf.get(dirPermsConfName, "700"));
        if (!fs.exists(p) && (this.isSecurityEnabled ? !fs.mkdirs(p, this.secureRootSubDirPerms) : !fs.mkdirs(p))) {
            throw new IOException("HBase directory '" + p + "' creation failure.");
        }
        if (this.isSecurityEnabled && !dirPerms.equals((Object)fs.getFileStatus(p).getPermission())) {
            LOG.warn("Found HBase directory permissions NOT matching expected permissions for " + p.toString() + " permissions=" + fs.getFileStatus(p).getPermission() + ", expecting " + dirPerms + ". Automatically setting the permissions. You can change the permissions by setting \"" + dirPermsConfName + "\" in hbase-site.xml and restarting the master");
            fs.setPermission(p, dirPerms);
        }
    }

    private void checkStagingDir() throws IOException {
        Path p = new Path(this.rootdir, "staging");
        try {
            if (!this.fs.exists(p) && !this.fs.mkdirs(p, this.HiddenDirPerms)) {
                throw new IOException("Failed to create staging directory " + p.toString());
            }
            this.fs.setPermission(p, this.HiddenDirPerms);
        }
        catch (IOException e) {
            LOG.error("Failed to create or set permission on staging directory " + p.toString());
            throw new IOException("Failed to create or set permission on staging directory " + p.toString(), e);
        }
    }

    public void deleteFamilyFromFS(RegionInfo region, byte[] familyName) throws IOException {
        this.deleteFamilyFromFS(this.rootdir, region, familyName);
    }

    public void deleteFamilyFromFS(Path rootDir, RegionInfo region, byte[] familyName) throws IOException {
        Path tableDir = CommonFSUtils.getTableDir(rootDir, region.getTable());
        HFileArchiver.archiveFamily(this.fs, this.conf, region, tableDir, familyName);
        Path familyDir = new Path(tableDir, new Path(region.getEncodedName(), Bytes.toString(familyName)));
        if (!this.fs.delete(familyDir, true) && this.fs.exists(familyDir)) {
            throw new IOException("Could not delete family " + Bytes.toString(familyName) + " from FileSystem for region " + region.getRegionNameAsString() + "(" + region.getEncodedName() + ")");
        }
    }

    public void stop() {
    }

    public void logFileSystemState(Logger log) throws IOException {
        CommonFSUtils.logFileSystemState(this.fs, this.rootdir, log);
    }
}

