/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableState;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@InterfaceAudience.Private
public class MirroringTableStateManager
extends TableStateManager {
    private static final Logger LOG = LoggerFactory.getLogger(MirroringTableStateManager.class);
    static final String MIRROR_TABLE_STATE_TO_ZK_KEY = "hbase.mirror.table.state.to.zookeeper";

    public MirroringTableStateManager(MasterServices master) {
        super(master);
    }

    @Override
    protected void metaStateUpdated(TableName tableName, TableState.State newState) throws IOException {
        this.updateZooKeeper(new TableState(tableName, newState));
    }

    @Override
    protected void metaStateDeleted(TableName tableName) throws IOException {
        this.deleteZooKeeper(tableName);
    }

    private void updateZooKeeper(TableState tableState) throws IOException {
        if (tableState == null) {
            return;
        }
        String znode = ZNodePaths.joinZNode(this.master.getZooKeeper().getZNodePaths().tableZNode, tableState.getTableName().getNameAsString());
        try {
            if (ZKUtil.checkExists((ZKWatcher)this.master.getZooKeeper(), (String)znode) == -1) {
                ZKUtil.createAndFailSilent((ZKWatcher)this.master.getZooKeeper(), (String)znode);
            }
            ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
            builder.setState(ZooKeeperProtos.DeprecatedTableState.State.valueOf(tableState.getState().toString()));
            byte[] data = ProtobufUtil.prependPBMagic(builder.build().toByteArray());
            ZKUtil.setData((ZKWatcher)this.master.getZooKeeper(), (String)znode, (byte[])data);
        }
        catch (KeeperException e) {
            LOG.warn("Failed setting table state to zookeeper mirrored for hbase-1.x clients", e);
        }
    }

    @Override
    protected void fixTableState(TableState tableState) throws IOException {
        this.updateZooKeeper(tableState);
    }
}

