/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.AbstractStateMachineRegionProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.TableProcedureInterface;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureStateSerializer;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureSuspendedException;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureYieldException;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.StateMachineProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.MasterProcedureProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class GCRegionProcedure
extends AbstractStateMachineRegionProcedure<MasterProcedureProtos.GCRegionState> {
    private static final Logger LOG = LoggerFactory.getLogger(GCRegionProcedure.class);

    public GCRegionProcedure(MasterProcedureEnv env, RegionInfo hri) {
        super(env, hri);
    }

    public GCRegionProcedure() {
    }

    @Override
    public TableProcedureInterface.TableOperationType getTableOperationType() {
        return TableProcedureInterface.TableOperationType.REGION_GC;
    }

    protected StateMachineProcedure.Flow executeFromState(MasterProcedureEnv env, MasterProcedureProtos.GCRegionState state) throws ProcedureSuspendedException, ProcedureYieldException, InterruptedException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + " execute state=" + state);
        }
        MasterServices masterServices = env.getMasterServices();
        try {
            switch (state) {
                case GC_REGION_PREPARE: {
                    this.setNextState(MasterProcedureProtos.GCRegionState.GC_REGION_ARCHIVE);
                    break;
                }
                case GC_REGION_ARCHIVE: {
                    Path wrongRegionWALDir;
                    Path regionWALDir;
                    FileSystem walFs;
                    MasterFileSystem mfs = masterServices.getMasterFileSystem();
                    FileSystem fs = mfs.getFileSystem();
                    if (HFileArchiver.exists(masterServices.getConfiguration(), fs, this.getRegion())) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Archiving region=" + this.getRegion().getShortNameToLog());
                        }
                        HFileArchiver.archiveRegion(masterServices.getConfiguration(), fs, this.getRegion());
                    }
                    if ((walFs = mfs.getWALFileSystem()).exists(regionWALDir = CommonFSUtils.getWALRegionDir(env.getMasterConfiguration(), this.getRegion().getTable(), this.getRegion().getEncodedName())) && !walFs.delete(regionWALDir, true)) {
                        LOG.debug("Failed to delete {}", (Object)regionWALDir);
                    }
                    if (walFs.exists(wrongRegionWALDir = CommonFSUtils.getWrongWALRegionDir(env.getMasterConfiguration(), this.getRegion().getTable(), this.getRegion().getEncodedName())) && !walFs.delete(wrongRegionWALDir, true)) {
                        LOG.debug("Failed to delete {}", (Object)regionWALDir);
                    }
                    this.setNextState(MasterProcedureProtos.GCRegionState.GC_REGION_PURGE_METADATA);
                    break;
                }
                case GC_REGION_PURGE_METADATA: {
                    AssignmentManager am = masterServices.getAssignmentManager();
                    if (am != null && am.getRegionStates() != null) {
                        am.getRegionStates().deleteRegion(this.getRegion());
                    }
                    MetaTableAccessor.deleteRegionInfo(masterServices.getConnection(), this.getRegion());
                    masterServices.getServerManager().removeRegion(this.getRegion());
                    FavoredNodesManager fnm = masterServices.getFavoredNodesManager();
                    if (fnm != null) {
                        fnm.deleteFavoredNodesForRegions(Lists.newArrayList(this.getRegion()));
                    }
                    return StateMachineProcedure.Flow.NO_MORE_STATE;
                }
                default: {
                    throw new UnsupportedOperationException(this + " unhandled state=" + state);
                }
            }
        }
        catch (IOException ioe) {
            LOG.warn("Error trying to GC " + this.getRegion().getShortNameToLog() + "; retrying...", ioe);
        }
        return StateMachineProcedure.Flow.HAS_MORE_STATE;
    }

    protected void rollbackState(MasterProcedureEnv env, MasterProcedureProtos.GCRegionState state) throws IOException, InterruptedException {
    }

    protected MasterProcedureProtos.GCRegionState getState(int stateId) {
        return MasterProcedureProtos.GCRegionState.forNumber(stateId);
    }

    protected int getStateId(MasterProcedureProtos.GCRegionState state) {
        return state.getNumber();
    }

    protected MasterProcedureProtos.GCRegionState getInitialState() {
        return MasterProcedureProtos.GCRegionState.GC_REGION_PREPARE;
    }

    @Override
    protected void serializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.serializeStateData(serializer);
        MasterProcedureProtos.GCRegionStateData.Builder msg = MasterProcedureProtos.GCRegionStateData.newBuilder().setRegionInfo(ProtobufUtil.toRegionInfo(this.getRegion()));
        serializer.serialize((Message)msg.build());
    }

    @Override
    protected void deserializeStateData(ProcedureStateSerializer serializer) throws IOException {
        super.deserializeStateData(serializer);
        MasterProcedureProtos.GCRegionStateData msg = (MasterProcedureProtos.GCRegionStateData)serializer.deserialize(MasterProcedureProtos.GCRegionStateData.class);
        this.setRegion(ProtobufUtil.toRegionInfo(msg.getRegionInfo()));
    }
}

