/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.region;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.Abortable;
import org.apache.hudi.org.apache.hadoop.hbase.master.region.MasterRegionFlusherAndCompactor;
import org.apache.hudi.org.apache.hadoop.hbase.master.region.MasterRegionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.wal.AbstractWALRoller;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class MasterRegionWALRoller
extends AbstractWALRoller<Abortable> {
    private static final Logger LOG = LoggerFactory.getLogger(MasterRegionWALRoller.class);
    private volatile MasterRegionFlusherAndCompactor flusherAndCompactor;
    private final FileSystem fs;
    private final Path walArchiveDir;
    private final Path globalWALArchiveDir;
    private final String archivedWALSuffix;

    private MasterRegionWALRoller(String name, Configuration conf, Abortable abortable, FileSystem fs, Path walRootDir, Path globalWALRootDir, String archivedWALSuffix) {
        super(name, conf, abortable);
        this.fs = fs;
        this.walArchiveDir = new Path(walRootDir, "oldWALs");
        this.globalWALArchiveDir = new Path(globalWALRootDir, "oldWALs");
        this.archivedWALSuffix = archivedWALSuffix;
    }

    @Override
    protected void afterWALArchive(Path oldPath, Path newPath) {
        try {
            MasterRegionUtils.moveFilesUnderDir(this.fs, this.walArchiveDir, this.globalWALArchiveDir, this.archivedWALSuffix);
        }
        catch (IOException e) {
            LOG.warn("Failed to move archived wals from {} to global dir {}", this.walArchiveDir, this.globalWALArchiveDir, e);
        }
    }

    @Override
    protected void scheduleFlush(String encodedRegionName, List<byte[]> families) {
        MasterRegionFlusherAndCompactor flusher = this.flusherAndCompactor;
        if (flusher != null) {
            flusher.requestFlush();
        }
    }

    void setFlusherAndCompactor(MasterRegionFlusherAndCompactor flusherAndCompactor) {
        this.flusherAndCompactor = flusherAndCompactor;
    }

    static MasterRegionWALRoller create(String name, Configuration conf, Abortable abortable, FileSystem fs, Path walRootDir, Path globalWALRootDir, String archivedWALSuffix, long rollPeriodMs, long flushSize) {
        conf.setBoolean("hbase.regionserver.hlog.enabled", true);
        conf.setBoolean("hbase.separate.oldlogdir.by.regionserver", false);
        conf.setLong("hbase.regionserver.logroll.period", rollPeriodMs);
        conf.setLong("hbase.regionserver.hlog.blocksize", flushSize * 2L);
        conf.setFloat("hbase.regionserver.logroll.multiplier", 0.5f);
        return new MasterRegionWALRoller(name, conf, abortable, fs, walRootDir, globalWALRootDir, archivedWALSuffix);
    }
}

