/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hudi.org.apache.hadoop.hbase.Stoppable;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.MetricsMaster;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.MasterQuotaManager;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.NamespaceQuotaSnapshotStore;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaRetriever;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaSettings;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaSnapshotStore;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaTableUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaType;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshot;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceQuotaSnapshotNotifier;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.TableQuotaSnapshotStore;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.QuotaProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.HashMultimap;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Iterables;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class QuotaObserverChore
extends ScheduledChore {
    private static final Logger LOG = LoggerFactory.getLogger(QuotaObserverChore.class);
    static final String QUOTA_OBSERVER_CHORE_PERIOD_KEY = "hbase.master.quotas.observer.chore.period";
    static final int QUOTA_OBSERVER_CHORE_PERIOD_DEFAULT = 60000;
    static final String QUOTA_OBSERVER_CHORE_DELAY_KEY = "hbase.master.quotas.observer.chore.delay";
    static final long QUOTA_OBSERVER_CHORE_DELAY_DEFAULT = 15000L;
    static final String QUOTA_OBSERVER_CHORE_TIMEUNIT_KEY = "hbase.master.quotas.observer.chore.timeunit";
    static final String QUOTA_OBSERVER_CHORE_TIMEUNIT_DEFAULT = TimeUnit.MILLISECONDS.name();
    static final String QUOTA_OBSERVER_CHORE_REPORT_PERCENT_KEY = "hbase.master.quotas.observer.report.percent";
    static final double QUOTA_OBSERVER_CHORE_REPORT_PERCENT_DEFAULT = 0.95;
    static final String REGION_REPORT_RETENTION_DURATION_KEY = "hbase.master.quotas.region.report.retention.millis";
    static final long REGION_REPORT_RETENTION_DURATION_DEFAULT = 600000L;
    private final Connection conn;
    private final Configuration conf;
    private final MasterQuotaManager quotaManager;
    private final MetricsMaster metrics;
    private final SpaceQuotaSnapshotNotifier snapshotNotifier;
    private final Map<TableName, SpaceQuotaSnapshot> tableQuotaSnapshots;
    private final Map<TableName, SpaceQuotaSnapshot> readOnlyTableQuotaSnapshots;
    private final Map<String, SpaceQuotaSnapshot> namespaceQuotaSnapshots;
    private final Map<String, SpaceQuotaSnapshot> readOnlyNamespaceSnapshots;
    private final long regionReportLifetimeMillis;
    private QuotaSnapshotStore<TableName> tableSnapshotStore;
    private QuotaSnapshotStore<String> namespaceSnapshotStore;

    public QuotaObserverChore(HMaster master, MetricsMaster metrics) {
        this(master.getConnection(), master.getConfiguration(), master.getSpaceQuotaSnapshotNotifier(), master.getMasterQuotaManager(), master, metrics);
    }

    QuotaObserverChore(Connection conn, Configuration conf, SpaceQuotaSnapshotNotifier snapshotNotifier, MasterQuotaManager quotaManager, Stoppable stopper, MetricsMaster metrics) {
        super(QuotaObserverChore.class.getSimpleName(), stopper, QuotaObserverChore.getPeriod(conf), QuotaObserverChore.getInitialDelay(conf), QuotaObserverChore.getTimeUnit(conf));
        this.conn = conn;
        this.conf = conf;
        this.metrics = metrics;
        this.quotaManager = quotaManager;
        this.snapshotNotifier = Objects.requireNonNull(snapshotNotifier);
        this.tableQuotaSnapshots = new ConcurrentHashMap<TableName, SpaceQuotaSnapshot>();
        this.readOnlyTableQuotaSnapshots = Collections.unmodifiableMap(this.tableQuotaSnapshots);
        this.namespaceQuotaSnapshots = new ConcurrentHashMap<String, SpaceQuotaSnapshot>();
        this.readOnlyNamespaceSnapshots = Collections.unmodifiableMap(this.namespaceQuotaSnapshots);
        this.regionReportLifetimeMillis = conf.getLong(REGION_REPORT_RETENTION_DURATION_KEY, 600000L);
    }

    @Override
    protected void chore() {
        try {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Refreshing space quotas in RegionServer");
            }
            long start = System.nanoTime();
            this._chore();
            if (this.metrics != null) {
                this.metrics.incrementQuotaObserverTime((System.nanoTime() - start) / 1000000L);
            }
        }
        catch (IOException e) {
            LOG.warn("Failed to process quota reports and update quota state. Will retry.", e);
        }
    }

    void _chore() throws IOException {
        TablesWithQuotas tablesWithQuotas = this.fetchAllTablesWithQuotasDefined();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Found following tables with quotas: " + tablesWithQuotas);
        }
        if (this.metrics != null) {
            this.metrics.setNumSpaceQuotas(tablesWithQuotas.getTableQuotaTables().size() + tablesWithQuotas.getNamespacesWithQuotas().size());
        }
        Map<RegionInfo, Long> reportedRegionSpaceUse = this.quotaManager.snapshotRegionSizes();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Using " + reportedRegionSpaceUse.size() + " region space use reports: " + reportedRegionSpaceUse);
        }
        this.pruneOldRegionReports();
        this.initializeSnapshotStores(reportedRegionSpaceUse);
        if (this.metrics != null) {
            this.metrics.setNumRegionSizeReports(reportedRegionSpaceUse.size());
        }
        Set<TableName> tablesInLimbo = tablesWithQuotas.filterInsufficientlyReportedTables(this.tableSnapshotStore);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Filtered insufficiently reported tables, left with " + reportedRegionSpaceUse.size() + " regions reported");
        }
        for (TableName tableInLimbo : tablesInLimbo) {
            SpaceQuotaSnapshot currentSnapshot = this.tableSnapshotStore.getCurrentState(tableInLimbo);
            SpaceQuotaSnapshot.SpaceQuotaStatus currentStatus = currentSnapshot.getQuotaStatus();
            if (!currentStatus.isInViolation()) continue;
            if (LOG.isTraceEnabled()) {
                LOG.trace("Moving " + tableInLimbo + " out of violation because fewer region sizes were reported than required.");
            }
            SpaceQuotaSnapshot targetSnapshot = new SpaceQuotaSnapshot(SpaceQuotaSnapshot.SpaceQuotaStatus.notInViolation(), currentSnapshot.getUsage(), currentSnapshot.getLimit());
            this.snapshotNotifier.transitionTable(tableInLimbo, targetSnapshot);
            this.tableSnapshotStore.setCurrentState(tableInLimbo, targetSnapshot);
            if (SpaceViolationPolicy.DISABLE != currentStatus.getPolicy().orElse(null)) continue;
            QuotaUtil.enableTableIfNotEnabled(this.conn, tableInLimbo);
        }
        Set<TableName> tablesWithTableQuotas = tablesWithQuotas.getTableQuotaTables();
        this.processTablesWithQuotas(tablesWithTableQuotas);
        Set<String> namespacesWithQuotas = tablesWithQuotas.getNamespacesWithQuotas();
        Multimap<String, TableName> tablesByNamespace = tablesWithQuotas.getTablesByNamespace();
        this.processNamespacesWithQuotas(namespacesWithQuotas, tablesByNamespace);
    }

    void initializeSnapshotStores(Map<RegionInfo, Long> regionSizes) {
        Map<RegionInfo, Long> immutableRegionSpaceUse = Collections.unmodifiableMap(regionSizes);
        if (this.tableSnapshotStore == null) {
            this.tableSnapshotStore = new TableQuotaSnapshotStore(this.conn, this, immutableRegionSpaceUse);
        } else {
            this.tableSnapshotStore.setRegionUsage(immutableRegionSpaceUse);
        }
        if (this.namespaceSnapshotStore == null) {
            this.namespaceSnapshotStore = new NamespaceQuotaSnapshotStore(this.conn, this, immutableRegionSpaceUse);
        } else {
            this.namespaceSnapshotStore.setRegionUsage(immutableRegionSpaceUse);
        }
    }

    void processTablesWithQuotas(Set<TableName> tablesWithTableQuotas) throws IOException {
        long numTablesInViolation = 0L;
        for (TableName table : tablesWithTableQuotas) {
            QuotaProtos.SpaceQuota spaceQuota = this.tableSnapshotStore.getSpaceQuota(table);
            if (spaceQuota == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Unexpectedly did not find a space quota for " + table + ", maybe it was recently deleted.");
                continue;
            }
            SpaceQuotaSnapshot currentSnapshot = this.tableSnapshotStore.getCurrentState(table);
            SpaceQuotaSnapshot targetSnapshot = this.tableSnapshotStore.getTargetState(table, spaceQuota);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing " + table + " with current=" + currentSnapshot + ", target=" + targetSnapshot);
            }
            this.updateTableQuota(table, currentSnapshot, targetSnapshot);
            if (!targetSnapshot.getQuotaStatus().isInViolation()) continue;
            ++numTablesInViolation;
        }
        if (this.metrics != null) {
            this.metrics.setNumTableInSpaceQuotaViolation(numTablesInViolation);
        }
    }

    void processNamespacesWithQuotas(Set<String> namespacesWithQuotas, Multimap<String, TableName> tablesByNamespace) throws IOException {
        long numNamespacesInViolation = 0L;
        for (String namespace : namespacesWithQuotas) {
            QuotaProtos.SpaceQuota spaceQuota = this.namespaceSnapshotStore.getSpaceQuota(namespace);
            if (spaceQuota == null) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Could not get Namespace space quota for " + namespace + ", maybe it was recently deleted.");
                continue;
            }
            SpaceQuotaSnapshot currentSnapshot = this.namespaceSnapshotStore.getCurrentState(namespace);
            SpaceQuotaSnapshot targetSnapshot = this.namespaceSnapshotStore.getTargetState(namespace, spaceQuota);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Processing " + namespace + " with current=" + currentSnapshot + ", target=" + targetSnapshot);
            }
            this.updateNamespaceQuota(namespace, currentSnapshot, targetSnapshot, tablesByNamespace);
            if (!targetSnapshot.getQuotaStatus().isInViolation()) continue;
            ++numNamespacesInViolation;
        }
        if (this.metrics != null) {
            this.metrics.setNumNamespacesInSpaceQuotaViolation(numNamespacesInViolation);
        }
    }

    void updateTableQuota(TableName table, SpaceQuotaSnapshot currentSnapshot, SpaceQuotaSnapshot targetSnapshot) throws IOException {
        SpaceQuotaSnapshot.SpaceQuotaStatus currentStatus = currentSnapshot.getQuotaStatus();
        SpaceQuotaSnapshot.SpaceQuotaStatus targetStatus = targetSnapshot.getQuotaStatus();
        if (!currentSnapshot.equals(targetSnapshot)) {
            this.snapshotNotifier.transitionTable(table, targetSnapshot);
            this.tableSnapshotStore.setCurrentState(table, targetSnapshot);
            SpaceViolationPolicy currPolicy = currentStatus.getPolicy().orElse(null);
            SpaceViolationPolicy targetPolicy = targetStatus.getPolicy().orElse(null);
            if (!targetStatus.isInViolation()) {
                if (this.isDisableSpaceViolationPolicy(currPolicy, targetPolicy)) {
                    QuotaUtil.enableTableIfNotEnabled(this.conn, table);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(table + " moved into observance of table space quota.");
                }
            } else {
                if (currPolicy != targetPolicy && SpaceViolationPolicy.DISABLE == currPolicy) {
                    QuotaUtil.enableTableIfNotEnabled(this.conn, table);
                } else if (SpaceViolationPolicy.DISABLE == targetPolicy) {
                    QuotaUtil.disableTableIfNotDisabled(this.conn, table);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug(table + " moved into violation of table space quota with policy of " + (Object)((Object)targetPolicy));
                }
            }
        } else if (LOG.isTraceEnabled()) {
            if (!currentStatus.isInViolation()) {
                LOG.trace(table + " remains in observance of quota.");
            } else {
                LOG.trace(table + " remains in violation of quota.");
            }
        }
    }

    private boolean isDisableSpaceViolationPolicy(SpaceViolationPolicy currPolicy, SpaceViolationPolicy targetPolicy) {
        return SpaceViolationPolicy.DISABLE == currPolicy || SpaceViolationPolicy.DISABLE == targetPolicy;
    }

    void updateNamespaceQuota(String namespace, SpaceQuotaSnapshot currentSnapshot, SpaceQuotaSnapshot targetSnapshot, Multimap<String, TableName> tablesByNamespace) throws IOException {
        SpaceQuotaSnapshot.SpaceQuotaStatus targetStatus = targetSnapshot.getQuotaStatus();
        if (!currentSnapshot.equals(targetSnapshot)) {
            if (!targetStatus.isInViolation()) {
                for (TableName tableInNS : tablesByNamespace.get(namespace)) {
                    if (this.tableSnapshotStore.getCurrentState(tableInNS).getQuotaStatus().isInViolation()) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Not activating Namespace violation policy because a Table violation policy is already in effect for " + tableInNS);
                        continue;
                    }
                    LOG.info(tableInNS + " moving into observance of namespace space quota");
                    this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
                }
            } else {
                for (TableName tableInNS : tablesByNamespace.get(namespace)) {
                    boolean hasTableQuota;
                    SpaceQuotaSnapshot tableQuotaSnapshot = this.tableSnapshotStore.getCurrentState(tableInNS);
                    boolean bl = hasTableQuota = !Objects.equals(QuotaSnapshotStore.NO_QUOTA, tableQuotaSnapshot);
                    if (hasTableQuota && tableQuotaSnapshot.getQuotaStatus().isInViolation()) {
                        if (!LOG.isTraceEnabled()) continue;
                        LOG.trace("Not activating Namespace violation policy because a Table violation policy is already in effect for " + tableInNS);
                        continue;
                    }
                    LOG.info(tableInNS + " moving into violation of namespace space quota with policy " + targetStatus.getPolicy());
                    this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
                }
            }
            this.namespaceSnapshotStore.setCurrentState(namespace, targetSnapshot);
        } else if (!targetStatus.isInViolation()) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(namespace + " remains in observance of quota.");
            }
        } else {
            for (TableName tableInNS : tablesByNamespace.get(namespace)) {
                if (this.tableSnapshotStore.getCurrentState(tableInNS).getQuotaStatus().isInViolation()) {
                    if (!LOG.isTraceEnabled()) continue;
                    LOG.trace("Not activating Namespace violation policy because Table violation policy is already in effect for " + tableInNS);
                    continue;
                }
                LOG.info(tableInNS + " moving into violation of namespace space quota");
                this.snapshotNotifier.transitionTable(tableInNS, targetSnapshot);
            }
        }
    }

    void pruneOldRegionReports() {
        long now = EnvironmentEdgeManager.currentTime();
        long pruneTime = now - this.regionReportLifetimeMillis;
        int numRemoved = this.quotaManager.pruneEntriesOlderThan(pruneTime, this);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Removed " + numRemoved + " old region size reports that were older than " + pruneTime + ".");
        }
    }

    TablesWithQuotas fetchAllTablesWithQuotasDefined() throws IOException {
        Scan scan = QuotaTableUtil.makeScan(null);
        TablesWithQuotas tablesWithQuotas = new TablesWithQuotas(this.conn, this.conf);
        try (QuotaRetriever scanner = new QuotaRetriever();){
            scanner.init(this.conn, scan);
            for (QuotaSettings quotaSettings : scanner) {
                String namespace = quotaSettings.getNamespace();
                TableName tableName = quotaSettings.getTableName();
                if (QuotaType.SPACE != quotaSettings.getQuotaType()) continue;
                if (namespace != null) {
                    TableName[] tablesInNS;
                    assert (tableName == null);
                    for (TableName tableUnderNs : tablesInNS = this.conn.getAdmin().listTableNamesByNamespace(namespace)) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Adding " + tableUnderNs + " under " + namespace + " as having a namespace quota");
                        }
                        tablesWithQuotas.addNamespaceQuotaTable(tableUnderNs);
                    }
                    continue;
                }
                assert (tableName != null);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Adding " + tableName + " as having table quota.");
                }
                tablesWithQuotas.addTableQuotaTable(tableName);
            }
            TablesWithQuotas tablesWithQuotas2 = tablesWithQuotas;
            return tablesWithQuotas2;
        }
    }

    QuotaSnapshotStore<TableName> getTableSnapshotStore() {
        return this.tableSnapshotStore;
    }

    QuotaSnapshotStore<String> getNamespaceSnapshotStore() {
        return this.namespaceSnapshotStore;
    }

    public Map<TableName, SpaceQuotaSnapshot> getTableQuotaSnapshots() {
        return this.readOnlyTableQuotaSnapshots;
    }

    public Map<String, SpaceQuotaSnapshot> getNamespaceQuotaSnapshots() {
        return this.readOnlyNamespaceSnapshots;
    }

    SpaceQuotaSnapshot getTableQuotaSnapshot(TableName table) {
        SpaceQuotaSnapshot state = this.tableQuotaSnapshots.get(table);
        if (state == null) {
            return QuotaSnapshotStore.NO_QUOTA;
        }
        return state;
    }

    void setTableQuotaSnapshot(TableName table, SpaceQuotaSnapshot snapshot) {
        this.tableQuotaSnapshots.put(table, snapshot);
    }

    SpaceQuotaSnapshot getNamespaceQuotaSnapshot(String namespace) {
        SpaceQuotaSnapshot state = this.namespaceQuotaSnapshots.get(namespace);
        if (state == null) {
            return QuotaSnapshotStore.NO_QUOTA;
        }
        return state;
    }

    void setNamespaceQuotaSnapshot(String namespace, SpaceQuotaSnapshot snapshot) {
        this.namespaceQuotaSnapshots.put(namespace, snapshot);
    }

    static int getPeriod(Configuration conf) {
        return conf.getInt(QUOTA_OBSERVER_CHORE_PERIOD_KEY, 60000);
    }

    static long getInitialDelay(Configuration conf) {
        return conf.getLong(QUOTA_OBSERVER_CHORE_DELAY_KEY, 15000L);
    }

    static TimeUnit getTimeUnit(Configuration conf) {
        return TimeUnit.valueOf(conf.get(QUOTA_OBSERVER_CHORE_TIMEUNIT_KEY, QUOTA_OBSERVER_CHORE_TIMEUNIT_DEFAULT));
    }

    static Double getRegionReportPercent(Configuration conf) {
        return conf.getDouble(QUOTA_OBSERVER_CHORE_REPORT_PERCENT_KEY, 0.95);
    }

    static class TablesWithQuotas {
        private final Set<TableName> tablesWithTableQuotas = new HashSet<TableName>();
        private final Set<TableName> tablesWithNamespaceQuotas = new HashSet<TableName>();
        private final Connection conn;
        private final Configuration conf;

        public TablesWithQuotas(Connection conn, Configuration conf) {
            this.conn = Objects.requireNonNull(conn);
            this.conf = Objects.requireNonNull(conf);
        }

        Configuration getConfiguration() {
            return this.conf;
        }

        public void addTableQuotaTable(TableName tn) {
            this.tablesWithTableQuotas.add(tn);
        }

        public void addNamespaceQuotaTable(TableName tn) {
            this.tablesWithNamespaceQuotas.add(tn);
        }

        public boolean hasTableQuota(TableName tn) {
            return this.tablesWithTableQuotas.contains(tn);
        }

        public boolean hasNamespaceQuota(TableName tn) {
            return this.tablesWithNamespaceQuotas.contains(tn);
        }

        public Set<TableName> getTableQuotaTables() {
            return Collections.unmodifiableSet(this.tablesWithTableQuotas);
        }

        public Set<TableName> getNamespaceQuotaTables() {
            return Collections.unmodifiableSet(this.tablesWithNamespaceQuotas);
        }

        public Set<String> getNamespacesWithQuotas() {
            HashSet<String> namespaces = new HashSet<String>();
            for (TableName tn : this.tablesWithNamespaceQuotas) {
                namespaces.add(tn.getNamespaceAsString());
            }
            return namespaces;
        }

        public Multimap<String, TableName> getTablesByNamespace() {
            HashMultimap<String, TableName> tablesByNS = HashMultimap.create();
            for (TableName tn : this.tablesWithNamespaceQuotas) {
                tablesByNS.put(tn.getNamespaceAsString(), tn);
            }
            return tablesByNS;
        }

        public Set<TableName> filterInsufficientlyReportedTables(QuotaSnapshotStore<TableName> tableStore) throws IOException {
            double percentRegionsReportedThreshold = QuotaObserverChore.getRegionReportPercent(this.getConfiguration());
            HashSet<TableName> tablesToRemove = new HashSet<TableName>();
            for (TableName table : Iterables.concat(this.tablesWithTableQuotas, this.tablesWithNamespaceQuotas)) {
                if (tablesToRemove.contains(table)) continue;
                int numRegionsInTable = this.getNumRegions(table);
                if (numRegionsInTable == 0) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Filtering " + table + " because no regions were reported");
                    }
                    tablesToRemove.add(table);
                    continue;
                }
                int reportedRegionsInQuota = this.getNumReportedRegions(table, tableStore);
                double ratioReported = (double)reportedRegionsInQuota / (double)numRegionsInTable;
                if (ratioReported < percentRegionsReportedThreshold) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Filtering " + table + " because " + reportedRegionsInQuota + " of " + numRegionsInTable + " regions were reported.");
                    }
                    tablesToRemove.add(table);
                    continue;
                }
                if (!LOG.isTraceEnabled()) continue;
                LOG.trace("Retaining " + table + " because " + reportedRegionsInQuota + " of " + numRegionsInTable + " regions were reported.");
            }
            for (TableName tableToRemove : tablesToRemove) {
                this.tablesWithTableQuotas.remove(tableToRemove);
                this.tablesWithNamespaceQuotas.remove(tableToRemove);
            }
            return tablesToRemove;
        }

        int getNumRegions(TableName table) throws IOException {
            List<RegionInfo> regions = this.conn.getAdmin().getRegions(table);
            if (regions == null) {
                return 0;
            }
            RegionReplicaUtil.removeNonDefaultRegions(regions);
            return regions.size();
        }

        int getNumReportedRegions(TableName table, QuotaSnapshotStore<TableName> tableStore) throws IOException {
            return Iterables.size(tableStore.filterBySubject(table));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append(this.getClass().getSimpleName()).append(": tablesWithTableQuotas=").append(this.tablesWithTableQuotas).append(", tablesWithNamespaceQuotas=").append(this.tablesWithNamespaceQuotas);
            return sb.toString();
        }
    }
}

