/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.SpaceViolationPolicy;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class SpaceLimitingException
extends QuotaExceededException {
    private static final long serialVersionUID = 2319438922387583600L;
    private static final Logger LOG = LoggerFactory.getLogger(SpaceLimitingException.class);
    private static final String MESSAGE_PREFIX = SpaceLimitingException.class.getName() + ": ";
    private final String policyName;

    public SpaceLimitingException(String msg) {
        super(SpaceLimitingException.parseMessage(msg));
        if (msg != null) {
            for (SpaceViolationPolicy definedPolicy : SpaceViolationPolicy.values()) {
                if (msg.indexOf(definedPolicy.name()) == -1) continue;
                this.policyName = definedPolicy.name();
                return;
            }
        }
        this.policyName = null;
    }

    public SpaceLimitingException(String policyName, String msg) {
        super(msg);
        this.policyName = policyName;
    }

    public SpaceLimitingException(String policyName, String msg, Throwable e) {
        super(msg, e);
        this.policyName = policyName;
    }

    public String getViolationPolicy() {
        return this.policyName;
    }

    private static String parseMessage(String originalMessage) {
        block3: {
            if (originalMessage != null && originalMessage.startsWith(MESSAGE_PREFIX)) {
                try {
                    int index = originalMessage.indexOf(32, MESSAGE_PREFIX.length());
                    return originalMessage.substring(index + 1);
                }
                catch (Exception e) {
                    if (!LOG.isTraceEnabled()) break block3;
                    LOG.trace("Failed to trim exception message", e);
                }
            }
        }
        return originalMessage;
    }

    @Override
    public String getMessage() {
        return (this.policyName == null ? "(unknown policy)" : this.policyName) + " " + super.getMessage();
    }
}

