/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hudi.org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public abstract class FlushLargeStoresPolicy
extends FlushPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(FlushLargeStoresPolicy.class);
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND = "hbase.hregion.percolumnfamilyflush.size.lower.bound";
    public static final String HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = "hbase.hregion.percolumnfamilyflush.size.lower.bound.min";
    public static final long DEFAULT_HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN = 0x1000000L;
    protected long flushSizeLowerBound = -1L;

    public String toString() {
        return "FlushLargeStoresPolicy{flushSizeLowerBound=" + this.flushSizeLowerBound + '}';
    }

    protected void setFlushSizeLowerBounds(HRegion region) {
        String flushedSizeLowerBoundString;
        int familyNumber = region.getTableDescriptor().getColumnFamilyCount();
        this.flushSizeLowerBound = region.getMemStoreFlushSize() / (long)familyNumber;
        long minimumLowerBound = this.getConf().getLong(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND_MIN, 0x1000000L);
        if (minimumLowerBound > this.flushSizeLowerBound) {
            this.flushSizeLowerBound = minimumLowerBound;
        }
        if ((flushedSizeLowerBoundString = region.getTableDescriptor().getValue(HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND)) == null) {
            LOG.debug("No {} set in table {} descriptor;using region.getMemStoreFlushHeapSize/# of families ({}) instead.", HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND, region.getTableDescriptor().getTableName(), StringUtils.humanSize((double)this.flushSizeLowerBound) + ")");
        } else {
            try {
                this.flushSizeLowerBound = Long.parseLong(flushedSizeLowerBoundString);
            }
            catch (NumberFormatException nfe) {
                LOG.warn("Number format exception parsing {} for table {}: {}, {}; using region.getMemStoreFlushHeapSize/# of families ({}) and region.getMemStoreFlushOffHeapSize/# of families ({}) instead.", HREGION_COLUMNFAMILY_FLUSH_SIZE_LOWER_BOUND, region.getTableDescriptor().getTableName(), flushedSizeLowerBoundString, nfe, this.flushSizeLowerBound);
            }
        }
    }

    protected boolean shouldFlush(HStore store) {
        if (store.getMemStoreSize().getHeapSize() + store.getMemStoreSize().getOffHeapSize() > this.flushSizeLowerBound) {
            LOG.debug("Flush {} of {}; heap memstoreSize={} +off heap memstoreSize={} > memstore lowerBound={}", store.getColumnFamilyName(), this.region.getRegionInfo().getEncodedName(), store.getMemStoreSize().getHeapSize(), store.getMemStoreSize().getOffHeapSize(), this.flushSizeLowerBound);
            return true;
        }
        return false;
    }
}

