/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushAllLargeStoresPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.LimitedPrivate(value={"Configuration"})
public class FlushPolicyFactory {
    private static final Logger LOG = LoggerFactory.getLogger(FlushPolicyFactory.class);
    public static final String HBASE_FLUSH_POLICY_KEY = "hbase.regionserver.flush.policy";
    private static final Class<? extends FlushPolicy> DEFAULT_FLUSH_POLICY_CLASS = FlushAllLargeStoresPolicy.class;

    public static FlushPolicy create(HRegion region, Configuration conf) throws IOException {
        Class<? extends FlushPolicy> clazz = FlushPolicyFactory.getFlushPolicyClass(region.getTableDescriptor(), conf);
        FlushPolicy policy = (FlushPolicy)((Object)ReflectionUtils.newInstance(clazz, (Configuration)conf));
        policy.configureForRegion(region);
        return policy;
    }

    public static Class<? extends FlushPolicy> getFlushPolicyClass(TableDescriptor htd, Configuration conf) throws IOException {
        String className = htd.getFlushPolicyClassName();
        if (className == null) {
            className = conf.get(HBASE_FLUSH_POLICY_KEY, DEFAULT_FLUSH_POLICY_CLASS.getName());
        }
        try {
            Class<FlushPolicy> clazz = Class.forName(className).asSubclass(FlushPolicy.class);
            return clazz;
        }
        catch (Exception e) {
            LOG.warn("Unable to load configured flush policy '" + className + "' for table '" + htd.getTableName() + "', load default flush policy " + DEFAULT_FLUSH_POLICY_CLASS.getName() + " instead", e);
            return DEFAULT_FLUSH_POLICY_CLASS;
        }
    }
}

