/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.LocalHBaseCluster;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hudi.org.apache.hadoop.hbase.trace.TraceUtil;
import org.apache.hudi.org.apache.hadoop.hbase.util.ServerCommandLine;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HRegionServerCommandLine
extends ServerCommandLine {
    private static final Logger LOG = LoggerFactory.getLogger(HRegionServerCommandLine.class);
    private final Class<? extends HRegionServer> regionServerClass;
    private static final String USAGE = "Usage: HRegionServer [-D conf.param=value] start";

    public HRegionServerCommandLine(Class<? extends HRegionServer> clazz) {
        this.regionServerClass = clazz;
    }

    @Override
    protected String getUsage() {
        return USAGE;
    }

    private int start() throws Exception {
        Configuration conf = this.getConf();
        TraceUtil.initTracer(conf);
        try {
            if (LocalHBaseCluster.isLocal(conf)) {
                LOG.warn("Not starting a distinct region server because hbase.cluster.distributed is false");
            } else {
                HRegionServerCommandLine.logProcessInfo(this.getConf());
                HRegionServer hrs = HRegionServer.constructRegionServer(this.regionServerClass, conf);
                hrs.start();
                hrs.join();
                if (hrs.isAborted()) {
                    throw new RuntimeException("HRegionServer Aborted");
                }
            }
        }
        catch (Throwable t) {
            LOG.error("Region server exiting", t);
            return 1;
        }
        return 0;
    }

    public int run(String[] args) throws Exception {
        if (args.length != 1) {
            this.usage(null);
            return 1;
        }
        String cmd = args[0];
        if ("start".equals(cmd)) {
            return this.start();
        }
        if ("stop".equals(cmd)) {
            System.err.println("To shutdown the regionserver run hbase-daemon.sh stop regionserver or send a kill signal to the regionserver pid");
            return 1;
        }
        this.usage("Unknown command: " + args[0]);
        return 1;
    }
}

